/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.data.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PaySchePropVal;
import kd.tmc.psd.business.service.paysche.data.provider.IBaseDataProvider;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheBaseDataProvider
implements IBaseDataProvider {
    private static Log logger = LogFactory.getLog(PayScheBaseDataProvider.class);
    private Map<String, Map<Object, DynamicObject>> baseDataMap = new HashMap<String, Map<Object, DynamicObject>>();
    private DynamicObjectType calcEntryProp = PayScheCalcModel.getCalcEntryType();

    public PayScheBaseDataProvider(List<PayScheCalcModel> calcModelList) {
        this.initDataMap(calcModelList);
    }

    private void initDataMap(List<PayScheCalcModel> calcModelList) {
        logger.info("---- initDataMap \u65b9\u6cd5\u53c2\u6570\u4e3a: {}", (Object)PayScheCalcModel.serializeList(calcModelList));
        HashMap<String, Set> baseDataIdMap = new HashMap<String, Set>();
        for (PayScheCalcModel payScheCalcModel : calcModelList) {
            for (PaySchePropVal propVal : payScheCalcModel.getDataMap().values()) {
                String entityType;
                DynamicProperty scheEntryProp = this.calcEntryProp.getProperty(propVal.getScheCalcProp());
                ArrayList idList = new ArrayList();
                if (scheEntryProp == null || propVal.getData() == null) continue;
                if (scheEntryProp instanceof BasedataProp) {
                    entityType = scheEntryProp instanceof ItemClassProp ? (String)payScheCalcModel.getCalcPropVal(((ItemClassProp)scheEntryProp).getTypePropName()) : ((BasedataProp)scheEntryProp).getBaseEntityId();
                    idList.add(propVal.getData());
                } else {
                    if (!(scheEntryProp instanceof MulBasedataProp)) continue;
                    entityType = ((MulBasedataProp)scheEntryProp).getBaseEntityId();
                    idList.addAll((List)propVal.getData());
                }
                entityType = StringUtils.checkEntityType((String)entityType, (String)"cas_recbill_f7", (String)"cas_recbill");
                if (idList.size() <= 0) continue;
                Set idSet = baseDataIdMap.computeIfAbsent(entityType, o -> new HashSet());
                idSet.addAll(idList);
            }
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            Map<Object, DynamicObject> dataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            this.baseDataMap.put(entityType, dataMap);
        }
    }

    @Override
    public List<DynamicObject> getMultiBaseData(String entityType, List<Object> idList) {
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        if (idList == null || idList.size() == 0) {
            return dataList;
        }
        Map<Object, DynamicObject> dataMap = this.baseDataMap.get(entityType);
        if (dataMap == null) {
            return dataList;
        }
        for (Object id : idList) {
            DynamicObject data = dataMap.get(id);
            if (data == null) continue;
            dataList.add(data);
        }
        return dataList;
    }

    @Override
    public DynamicObject getBaseData(String entityType, Object id) {
        if (id == null) {
            return null;
        }
        Map<Object, DynamicObject> dataMap = this.baseDataMap.get(entityType);
        DynamicObject data = null;
        if (dataMap != null) {
            data = dataMap.get(id);
        }
        return data;
    }

    public DynamicObjectType getCalcEntryProp() {
        return this.calcEntryProp;
    }
}

