/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayRpcResult;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheduleHelper {
    private static final Log logger = LogFactory.getLog(PayScheduleHelper.class);

    private PayScheduleHelper() {
    }

    public static PayScheduleHelper getInstance() {
        return Singleton.INSTANCE;
    }

    public void deletePaySchePayBillEntry(DynamicObject[] dataEntities, PayRpcResult rpcResult) {
        if (rpcResult.getDelEntryIdSet() == null) {
            return;
        }
        Set<Long> delPayEntryIdSet = rpcResult.getDelEntryIdSet();
        if (delPayEntryIdSet == null || delPayEntryIdSet.size() <= 0) {
            return;
        }
        ArrayList<String> sourceBillNumbers = new ArrayList<String>(dataEntities.length);
        ArrayList<String> billNos = new ArrayList<String>(dataEntities.length);
        for (DynamicObject paySche : dataEntities) {
            DynamicObjectCollection entryList = paySche.getDynamicObjectCollection("entrys");
            entryList.removeIf(o -> delPayEntryIdSet.contains(o.getLong("e_payentryid")));
            sourceBillNumbers.add(paySche.getString("sourcebillnumber"));
            billNos.add(paySche.getString("billno"));
        }
        logger.info("\u67e5\u8be2\u5176\u5b83\u6392\u7a0b\u5355\u4e2d\u662f\u5426\u5b58\u5728\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a\u6e90\u5355\u7f16\u7801\uff1a{}, \u975e\u672c\u5355\u636e\u7f16\u53f7:{}", sourceBillNumbers, billNos);
        QFilter query = new QFilter("sourcebillnumber", "in", sourceBillNumbers).and(new QFilter("billno", "not in", billNos));
        DynamicObject[] payScheduleBills = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"id,entrys,entrys.e_payentryid,entrys.e_billtype", (QFilter[])new QFilter[]{query});
        if (payScheduleBills == null || payScheduleBills.length <= 0) {
            return;
        }
        logger.info("\u67e5\u8be2\u5230\u5176\u5b83\u6392\u7a0b\u5355\u4e2d\u5b58\u5728\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u4fe1\u606f\u9700\u8981\u5220\u9664");
        for (DynamicObject payScheduleBill : payScheduleBills) {
            DynamicObjectCollection payScheduleBillEntry = payScheduleBill.getDynamicObjectCollection("entrys");
            if (payScheduleBillEntry == null || payScheduleBillEntry.size() == 0) continue;
            payScheduleBillEntry.removeIf(o -> delPayEntryIdSet.contains(o.getLong("e_payentryid")));
        }
        SaveServiceHelper.save((DynamicObject[])payScheduleBills);
    }

    public void deletePayingPayBillEntry(DynamicObject[] dataEntities, Set<Long> delEntryIdSet) {
        if (delEntryIdSet.size() <= 0) {
            return;
        }
        ArrayList<String> sourceBillNumbers = new ArrayList<String>(dataEntities.length);
        ArrayList<String> billNos = new ArrayList<String>(dataEntities.length);
        logger.info("\u67e5\u8be2\u5176\u5b83\u6392\u7a0b\u5355\u4e2d\u662f\u5426\u5b58\u5728\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u4fe1\u606f(\u65b0\u8fd4\u56de\u7684\u4ed8\u6b3e\u4fe1\u606f\u53ea\u662f\u66f4\u65b0\u72b6\u6001)\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a\u6e90\u5355\u7f16\u7801\uff1a{}, \u975e\u672c\u5355\u636e\u7f16\u53f7:{}", sourceBillNumbers, billNos);
        for (DynamicObject paySche : dataEntities) {
            sourceBillNumbers.add(paySche.getString("sourcebillnumber"));
            billNos.add(paySche.getString("billno"));
        }
        QFilter query = new QFilter("sourcebillnumber", "in", sourceBillNumbers).and(new QFilter("billno", "not in", billNos));
        DynamicObject[] payScheduleBills = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"id,entrys,entrys.e_payentryid,entrys.e_billtype", (QFilter[])new QFilter[]{query});
        if (payScheduleBills == null || payScheduleBills.length <= 0) {
            return;
        }
        logger.info("\u67e5\u8be2\u5230\u65f6\u5176\u5b83\u6392\u7a0b\u5355\u4e2d\u5b58\u5728\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u4fe1\u606f(\u65b0\u8fd4\u56de\u7684\u4ed8\u6b3e\u4fe1\u606f\u53ea\u662f\u66f4\u65b0\u72b6\u6001)");
        for (DynamicObject payScheduleBill : payScheduleBills) {
            DynamicObjectCollection payScheduleBillEntry = payScheduleBill.getDynamicObjectCollection("entrys");
            if (payScheduleBillEntry == null || payScheduleBillEntry.size() == 0) continue;
            payScheduleBillEntry.removeIf(o -> delEntryIdSet.contains(o.getLong("e_payentryid")) && "schebill".equals(o.getString("e_billtype")));
        }
        SaveServiceHelper.save((DynamicObject[])payScheduleBills);
    }

    public static Map<String, BigDecimal> getBatchApplyAmount(List<PayScheCalcModel> scheDataList) {
        List notMergeDataList = scheDataList.parallelStream().filter(o -> Objects.nonNull(o) && !o.isArchiveMerger() && o.isBillDibs() == false).collect(Collectors.toList());
        HashMap<String, BigDecimal> batchScheAmount = new HashMap<String, BigDecimal>(16);
        Map scaleNoMerge = TmcAmountHelper.getScaleMap(notMergeDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        for (PayScheCalcModel notMergeData : notMergeDataList) {
            String batchNum = notMergeData.getBatchnum();
            if (!StringUtils.isNotEmpty((String)batchNum)) continue;
            BigDecimal applyAmt = (BigDecimal)batchScheAmount.get(batchNum);
            if (applyAmt == null) {
                applyAmt = BigDecimal.ZERO;
            }
            BigDecimal apply = notMergeData.getApplyAmt().multiply(notMergeData.getExchangerate()).setScale((int)((Integer)scaleNoMerge.get(notMergeData.getCurrencyId())), 4);
            applyAmt = applyAmt.add(apply);
            batchScheAmount.put(batchNum, applyAmt);
        }
        return batchScheAmount;
    }

    static class Singleton {
        private static final PayScheduleHelper INSTANCE = new PayScheduleHelper();

        Singleton() {
        }
    }
}

