/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.repo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PaySchePropVal;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheDataRepository<T extends SumScheData> {
    private String pageId;
    private Type sumScheDataType;
    private static final int MAX_BATCH_OPERATE_CNT = 20;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PayScheDataRepository");

    public PayScheDataRepository(String pageId, Type sumScheDataType) {
        this.pageId = pageId;
        this.sumScheDataType = sumScheDataType;
    }

    public T getScheSumInfo(Long sumId) {
        String sumDataKey = this.getSumDataKey(sumId);
        String sumStr = (String)cache.get(sumDataKey);
        if (sumStr == null) {
            this.redisKeyNotExist(sumDataKey);
        }
        return (T)((SumScheData)JSON.parseObject((String)sumStr, (Type)this.sumScheDataType, (Feature[])new Feature[0]));
    }

    public Boolean existSumDataKey(Long sumId) {
        return null != cache.get(this.getSumDataKey(sumId));
    }

    public String getDimType() {
        String dimValueStr = (String)cache.get(this.getDimValueKey());
        if (dimValueStr == null) {
            return "paytype";
        }
        return dimValueStr;
    }

    public void cacheDimType(String dimValueStr) {
        String dimValueKey = this.getDimValueKey();
        cache.put(dimValueKey, (Object)dimValueStr);
        this.registerKey(dimValueKey);
    }

    public List<T> getAllScheSumInfoList() {
        List<Long> sumIdList = this.getAllSumIdList();
        List sumDataList = sumIdList.stream().map(this::getScheSumInfo).collect(Collectors.toList());
        return sumDataList;
    }

    public List<PayScheCalcModel> getScheDataList(Long sumId, List<Long> scheIdList) {
        ArrayList<PayScheCalcModel> payScheDataList;
        String scheDataKey = this.getScheDataKey(sumId);
        int totalLen = cache.getListLength(scheDataKey);
        Map<Long, Integer> scheIdIndexMap = this.getScheIdIndexMap(sumId);
        if (scheIdList.size() > totalLen / 2 || scheIdList.size() > 20) {
            payScheDataList = this.getScheDataList(sumId).stream().filter(o -> scheIdList.contains(o.getScheId())).collect(Collectors.toList());
        } else {
            payScheDataList = new ArrayList(scheIdList.size());
            for (Long scheId : scheIdList) {
                Integer listIndex = scheIdIndexMap.get(scheId);
                if (listIndex == null) continue;
                String scheDataStr = cache.getListObject(scheDataKey, listIndex.intValue());
                if (scheDataStr == null) {
                    this.redisKeyNotExist(scheDataKey);
                }
                payScheDataList.add(PayScheCalcModel.deserialize(scheDataStr));
            }
        }
        return payScheDataList;
    }

    public List<PayScheCalcModel> getScheDataList(Long sumId) {
        String scheDataKey = this.getScheDataKey(sumId);
        String[] allDataListStr = cache.getList(scheDataKey);
        if (allDataListStr == null) {
            this.redisKeyNotExist(scheDataKey);
        }
        List<PayScheCalcModel> payScheDataList = Arrays.stream(allDataListStr).filter(EmptyUtil::isNoEmpty).map(PayScheCalcModel::deserialize).collect(Collectors.toList());
        Map<String, BigDecimal> batchDraftAmount = this.getBatchDraftAmount(payScheDataList);
        for (PayScheCalcModel payScheCalcModel : payScheDataList) {
            PayScheDataRepository.computeBalance(payScheCalcModel, batchDraftAmount);
        }
        return payScheDataList;
    }

    private Map<String, BigDecimal> getBatchDraftAmount(List<PayScheCalcModel> payScheDataList) {
        HashMap<String, BigDecimal> batchDraftAmount = new HashMap<String, BigDecimal>(16);
        for (PayScheCalcModel payScheCalcModel : payScheDataList) {
            PaySchePropVal batchNum;
            String batchNumStr;
            Map<String, PaySchePropVal> dataMap = payScheCalcModel.getDataMap();
            PaySchePropVal isBillDibsVal = dataMap.get("e_isbilldibs");
            Boolean isBillDibs = (Boolean)isBillDibsVal.getData();
            if (!isBillDibs.booleanValue() || StringUtils.isEmpty((String)(batchNumStr = (String)(batchNum = dataMap.get("e_batchnum")).getData()))) continue;
            PaySchePropVal draftVal = dataMap.get("e_draftamt");
            BigDecimal draftAmt = (BigDecimal)draftVal.getData();
            if (batchDraftAmount.containsKey(batchNumStr)) {
                BigDecimal amount = (BigDecimal)batchDraftAmount.get(batchNumStr);
                amount = amount.add(draftAmt);
                batchDraftAmount.put(batchNumStr, amount);
                continue;
            }
            batchDraftAmount.put(batchNumStr, draftAmt);
        }
        return batchDraftAmount;
    }

    private static void computeBalance(PayScheCalcModel payScheCalcModel, Map<String, BigDecimal> batchDraftAmount) {
        if (payScheCalcModel == null) {
            return;
        }
        Map<String, PaySchePropVal> dataMap = payScheCalcModel.getDataMap();
        PaySchePropVal isBillDibsVal = dataMap.get("e_isbilldibs");
        Boolean isBillDibs = (Boolean)isBillDibsVal.getData();
        if (!isBillDibs.booleanValue()) {
            return;
        }
        List<PayScheDraftInfo> payScheDraftInfos = payScheCalcModel.getPayScheDraftInfos();
        if (EmptyUtil.isEmpty(payScheDraftInfos)) {
            return;
        }
        BigDecimal transAmount = BigDecimal.ZERO;
        for (int inx = 0; inx < payScheDraftInfos.size(); ++inx) {
            PayScheDraftInfo payScheDraftInfo = payScheDraftInfos.get(inx);
            transAmount = transAmount.add(payScheDraftInfo.getTransferAmt());
        }
        PaySchePropVal balanceVal = dataMap.get("e_balance");
        PaySchePropVal batchNum = dataMap.get("e_batchnum");
        String batchNumStr = (String)batchNum.getData();
        BigDecimal applyAmt = batchDraftAmount.get(batchNumStr);
        if (applyAmt == null) {
            PaySchePropVal eDraftAmount = dataMap.get("e_draftamt");
            applyAmt = (BigDecimal)eDraftAmount.getData();
        }
        BigDecimal balance = transAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : transAmount.subtract(applyAmt);
        balanceVal.setData(balance);
    }

    public List<PayScheCalcModel> getAllScheDataList() {
        List<Long> sumIdList = this.getAllSumIdList();
        if (!sumIdList.contains(-1L)) {
            sumIdList.add(-1L);
        }
        List<PayScheCalcModel> allScheDataList = sumIdList.stream().map(this::getScheDataList).flatMap(Collection::stream).collect(Collectors.toList());
        return allScheDataList;
    }

    public void insertScheData(T sumDataList, List<PayScheCalcModel> newDataList) {
        List<T> allScheSumInfoList = this.getAllScheSumInfoList();
        if (!this.existSumDataKey(((SumScheData)sumDataList).getSummaryId()).booleanValue()) {
            allScheSumInfoList.add(sumDataList);
        }
        List<PayScheCalcModel> scheDataList = this.getAllScheDataList();
        scheDataList.addAll(newDataList);
        this.saveAll(allScheSumInfoList, scheDataList);
    }

    public void saveAll(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
        HashSet<String> keySet = new HashSet<String>(10);
        List sumIdList = sumDataList.stream().map(SumScheData::getSummaryId).collect(Collectors.toList());
        String sumIdListKey = this.getAllSumIdListKey();
        keySet.add(sumIdListKey);
        cache.put(sumIdListKey, (Object)JSON.toJSONString(sumIdList), CacheKeyUtil.getPageCacheKeyTimeout());
        this.updateScheSumInfo(sumDataList);
        Map<Long, List<PayScheCalcModel>> scheDataMap = scheDataList.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        if (!scheDataMap.containsKey(-1L)) {
            scheDataMap.put(-1L, new ArrayList(0));
        }
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : scheDataMap.entrySet()) {
            Object[] objectArray;
            Long sumId = entry.getKey();
            List<PayScheCalcModel> payScheList = entry.getValue();
            Object[] payScheJsonArr = (String[])payScheList.stream().map(PayScheCalcModel::serialize).toArray(String[]::new);
            String cacheDataKey = this.getScheDataKey(sumId);
            keySet.add(cacheDataKey);
            cache.remove(cacheDataKey);
            if (EmptyUtil.isEmpty((Object[])payScheJsonArr)) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = "";
            } else {
                objectArray = payScheJsonArr;
            }
            cache.addList(cacheDataKey, (String[])objectArray, CacheKeyUtil.getPageCacheKeyTimeout());
            this.restoreScheIdIndexMap(sumId, payScheList, keySet);
        }
        this.registerKey(keySet.toArray(new String[0]));
    }

    public void updateScheSumInfo(List<T> payScheSumDataList) {
        HashSet<String> keySet = new HashSet<String>(10);
        for (SumScheData sumData : payScheSumDataList) {
            String sumDataKey = this.getSumDataKey(sumData.getSummaryId());
            keySet.add(sumDataKey);
            cache.put(sumDataKey, (Object)JSON.toJSONString((Object)sumData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName}), CacheKeyUtil.getPageCacheKeyTimeout());
        }
        this.registerKey(keySet.toArray(new String[0]));
    }

    public PayScheCalcModel getVirtualPaySche(Long sumid, String batchnum) {
        List<PayScheCalcModel> payScheCalcModels = this.getScheDataList(sumid);
        PayScheCalcModel payScheCalcModel = payScheCalcModels.stream().filter(Objects::nonNull).filter(o -> o.isArchiveMerger()).filter(o -> batchnum.equals(o.getBatchnum())).findFirst().orElseGet(() -> null);
        return payScheCalcModel;
    }

    public List<PayScheCalcModel> getPayScheDataByBatchNum(String batchnum) {
        List<Long> allSumIdList = this.getAllSumIdList();
        allSumIdList.remove(-1L);
        List<PayScheCalcModel> paySches = allSumIdList.stream().map(this::getScheDataList).flatMap(Collection::stream).collect(Collectors.toList());
        paySches = paySches.stream().filter(Objects::nonNull).filter(o -> batchnum.equals(o.getBatchnum())).collect(Collectors.toList());
        return paySches;
    }

    public void updateScheDataList(Long sumId, List<PayScheCalcModel> payScheDataList) {
        String scheDataRedisKey = this.getScheDataKey(sumId);
        Map<Long, Integer> scheIdMap = this.getScheIdIndexMap(sumId);
        int totalLen = cache.getListLength(scheDataRedisKey);
        if (payScheDataList.size() > totalLen / 2 || payScheDataList.size() > 20) {
            List<PayScheCalcModel> prevScheDataList = this.getScheDataList(sumId);
            for (PayScheCalcModel currScheData : payScheDataList) {
                Integer listIndex = scheIdMap.get(currScheData.getScheId());
                prevScheDataList.set(listIndex, currScheData);
            }
            String[] payScheJsonArr = (String[])prevScheDataList.stream().map(PayScheCalcModel::serialize).toArray(String[]::new);
            cache.remove(scheDataRedisKey);
            cache.addList(scheDataRedisKey, payScheJsonArr, CacheKeyUtil.getPageCacheKeyTimeout());
        } else {
            for (PayScheCalcModel currScheData : payScheDataList) {
                Integer listIndex = scheIdMap.get(currScheData.getScheId());
                cache.setListObject(scheDataRedisKey, listIndex.intValue(), currScheData.serialize());
            }
            cache.expireAfter(scheDataRedisKey, CacheKeyUtil.getPageCacheKeyTimeout());
        }
        this.registerKey(scheDataRedisKey);
    }

    public void insertScheDataList(Long sumId, List<PayScheCalcModel> payScheDataList) {
        HashSet<String> keySet = new HashSet<String>();
        String scheDataRedisKey = this.getScheDataKey(sumId);
        keySet.add(scheDataRedisKey);
        List<PayScheCalcModel> prevScheDataList = this.getScheDataList(sumId);
        prevScheDataList.addAll(payScheDataList);
        String[] payScheJsonArr = (String[])prevScheDataList.stream().map(PayScheCalcModel::serialize).toArray(String[]::new);
        cache.remove(scheDataRedisKey);
        cache.addList(scheDataRedisKey, payScheJsonArr, CacheKeyUtil.getPageCacheKeyTimeout());
        this.restoreScheIdIndexMap(sumId, prevScheDataList, keySet);
        this.registerKey(keySet.toArray(new String[0]));
    }

    public void removeScheDataList(Long sumId, List<Long> waitRemoveScheIdList) {
        HashSet<String> keySet = new HashSet<String>();
        String scheDataRedisKey = this.getScheDataKey(sumId);
        keySet.add(scheDataRedisKey);
        List<PayScheCalcModel> scheDataList = this.getScheDataList(sumId);
        boolean isRemoved = scheDataList.removeIf(o -> waitRemoveScheIdList.contains(o.getScheId()));
        if (isRemoved) {
            cache.remove(scheDataRedisKey);
            if (scheDataList.size() > 0) {
                String[] payScheJsonArr = (String[])scheDataList.stream().map(PayScheCalcModel::serialize).toArray(String[]::new);
                cache.addList(scheDataRedisKey, payScheJsonArr, CacheKeyUtil.getPageCacheKeyTimeout());
            }
            this.restoreScheIdIndexMap(sumId, scheDataList, keySet);
        }
        this.registerKey(keySet.toArray(new String[0]));
    }

    public List<PayScheCalcModel> isNewScheData(Long sumId, List<PayScheCalcModel> payScheDataList) {
        Map<Long, Integer> scheIdMap = this.getScheIdIndexMap(sumId);
        return payScheDataList.stream().filter(o -> !scheIdMap.containsKey(o.getScheId())).collect(Collectors.toList());
    }

    public Long getCurrSumId() {
        Long sumId = null;
        String currSumIndexKey = this.getCurrSumIndexKey();
        String indexStr = (String)cache.get(currSumIndexKey);
        if (indexStr != null) {
            sumId = Long.parseLong(indexStr);
        }
        this.registerKey(currSumIndexKey);
        return sumId;
    }

    public void setCurrSumId(Long sumId) {
        String currSumIndexKey = this.getCurrSumIndexKey();
        cache.put(currSumIndexKey, (Object)String.valueOf(sumId));
        this.registerKey(currSumIndexKey);
    }

    public void clearCurrSumId() {
        String currSumIndexKey = this.getCurrSumIndexKey();
        cache.remove(currSumIndexKey);
    }

    public void clearCache() {
        String[] keys = cache.getSetValues(this.getKeySetKey());
        cache.remove(keys);
    }

    private Map<Long, Integer> getScheIdIndexMap(Long sumId) {
        String key = this.getScheIdIndexKey(sumId);
        String idMapStr = (String)cache.get(key);
        if (idMapStr == null) {
            this.redisKeyNotExist(key);
        }
        return (Map)JSON.parseObject((String)idMapStr, (TypeReference)new TypeReference<Map<Long, Integer>>(){}, (Feature[])new Feature[0]);
    }

    private void restoreScheIdIndexMap(Long sumId, List<PayScheCalcModel> payScheList, Set<String> keySet) {
        HashMap<Long, Integer> payScheIdToIndexMap = new HashMap<Long, Integer>(payScheList.size());
        for (int i = 0; i < payScheList.size(); ++i) {
            PayScheCalcModel payScheCalcModel = payScheList.get(i);
            payScheIdToIndexMap.put(payScheCalcModel.getScheId(), i);
        }
        String scheIdIndexKey = this.getScheIdIndexKey(sumId);
        keySet.add(scheIdIndexKey);
        cache.put(scheIdIndexKey, (Object)JSON.toJSONString(payScheIdToIndexMap), CacheKeyUtil.getPageCacheKeyTimeout());
    }

    private List<Long> getAllSumIdList() {
        String allSumIdListKey = this.getAllSumIdListKey();
        String allSumIdListStr = (String)cache.get(allSumIdListKey);
        if (allSumIdListStr == null) {
            this.redisKeyNotExist(allSumIdListKey);
        }
        return (List)JSON.parseObject((String)allSumIdListStr, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
    }

    private void redisKeyNotExist(String key) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u3002\u4ece\u7f13\u5b58\u8bfb\u53d6\u6a21\u578b\u6570\u636e\u5931\u8d25\uff0c\u952e\u503c\uff1a%s\u3002", (String)"PayScheDataRepository_0", (String)"tmc-psd-business", (Object[])new Object[0]), key));
    }

    private String getSumDataKey(Long sumId) {
        return String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheSumData", this.pageId, sumId.toString());
    }

    private String getAllSumIdListKey() {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheSumIdList", this.pageId);
    }

    private String getScheDataKey(Long sumId) {
        return String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheCalcModel", this.pageId, sumId.toString());
    }

    private String getScheIdIndexKey(Long sumId) {
        return String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheIdIndex", this.pageId, sumId.toString());
    }

    private String getKeySetKey() {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheKeySet", this.pageId);
    }

    private String getCurrSumIndexKey() {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheSumIndexKey", this.pageId);
    }

    private String getDimValueKey() {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "tmc.PayScheDimValueKey", this.pageId);
    }

    private void registerKey(String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        cache.addToSet(this.getKeySetKey(), keys);
    }
}

