/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.rpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.rpc.PayScheRpcApi;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayBillBackRequest;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayBillBackResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.PaySchBackCacheInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayScheRpcResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.RpcStatus;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.business.utils.CombineUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheRpcApiImpl
extends EventualConsistencyService
implements PayScheRpcApi {
    private static Log logger = LogFactory.getLog(PayScheRpcApiImpl.class);
    private static String OP_CANCELPAY = "cancelPay";
    private static String OP_SYNPAYSCHE = "synPaySche";
    private static String OP_PAY = "pay";
    private static final String CACHE_KEY_BACKBILL = "TMC:PSD:BACKBILL:";
    private static String[] SELECTOR = new String[]{"acctbanktype", "acctbank", "currency", "srcpaytotalamt", "sourcebillid", "sourcebilltype", "company", "billno", "payid", "payentryid", "schedulstatus", "nopayamt", "draftnopayamt", "checkamt", "paymentno", "paybillstatus"};

    @Override
    public String cancelPay(String payBillIdListJson) {
        logger.info("\u5f00\u59cb\u6267\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c: {}", (Object)payBillIdListJson);
        return this.synPayInfo2PaySche(payBillIdListJson, OP_CANCELPAY);
    }

    @Override
    public String synPaySche(String payBillIdListJson) {
        logger.info("\u5f00\u59cb\u6267\u884c\u4ed8\u6b3e\u64cd\u4f5c: {}", (Object)payBillIdListJson);
        return this.synPayInfo2PaySche(payBillIdListJson, OP_SYNPAYSCHE);
    }

    @Override
    public String pay(String payBillIdListJson) {
        logger.info("\u5f00\u59cb\u6267\u884c\u4ed8\u6b3e\u64cd\u4f5c: {}", (Object)payBillIdListJson);
        return this.synPayInfo2PaySche(payBillIdListJson, OP_PAY);
    }

    @Override
    public boolean isSchePayBill(Long payBillId) {
        return TmcDataServiceHelper.exists((String)"psd_schedulebill", (QFilter[])new QFilter[]{new QFilter("entrys.e_payid", "=", (Object)payBillId), new QFilter("entrys.e_billtype", "=", (Object)"paybill")});
    }

    @Override
    public void chargeBack(String payBillIdListJson) {
        DynamicObject[] payScheBills;
        logger.info("\u5f00\u59cb\u6267\u884c\u9000\u5355\u64cd\u4f5c: {}", (Object)payBillIdListJson);
        Map params = (Map)JSON.parseObject((String)payBillIdListJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        List payBillIdList = (List)JSON.parseObject((String)((String)params.get("payBillIds")), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        for (DynamicObject payScheBill : payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", SELECTOR), (QFilter[])new QFilter[]{new QFilter("payid", "in", (Object)payBillIdList)})) {
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETCHARGEBACK.getValue());
            payScheBill.set("paymentno", null);
            payScheBill.set("paybillstatus", null);
            payScheBill.set("payentryid", null);
            payScheBill.set("payid", null);
        }
        this.doSaveOp(payScheBills);
    }

    @Override
    public String backPayBill(Long backPayBillId, String payBillType, List<Long> draftIds, List<Long> schDataIdList) {
        return this.backPayBill(backPayBillId, payBillType, draftIds, schDataIdList, "", null);
    }

    @Override
    public String backPayBillRollBackSchedule(String parameters) {
        PayBillBackRequest receive = (PayBillBackRequest)JSON.parseObject((String)parameters, PayBillBackRequest.class);
        Long backPayBillId = receive.getBackPayBillId();
        String payBillType = receive.getPayBillType();
        List<Long> draftIds = receive.getDraftIds();
        List<Long> schDataIdList = receive.getSchDataIdList();
        String reason = receive.getReason();
        Map<Long, BigDecimal> backPayAmount = receive.getBackPayAmount();
        return this.backPayBill(backPayBillId, payBillType, draftIds, schDataIdList, reason, backPayAmount);
    }

    private String backPayBill(Long backPayBillId, String payBillType, List<Long> draftIds, List<Long> schDataIdList, String reason, Map<Long, BigDecimal> backPayAmount) {
        Object object;
        logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u4ed8\u6b3e\u5355id\uff1a{%s}\uff0c\u4ed8\u6b3e\u5355\u7c7b\u578b:{%s}\uff0c\u7968\u636eid\uff1a{%s}\uff0c\u6392\u7a0b\u5355id\uff1a{%s}", backPayBillId, payBillType, LoggerPrintHelper.printCollectionLogger(draftIds), LoggerPrintHelper.printCollectionLogger(schDataIdList)));
        DynamicObject paySchDataArr = TmcDataServiceHelper.load((Object[])schDataIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        if (EmptyUtil.isNoEmpty((Object[])paySchDataArr)) {
            Object paysche = paySchDataArr[0];
            String draftPayMethod = paysche.getString("draftpaymethod");
            boolean isDraftBook = "draftbook".equals(draftPayMethod);
            DynamicObjectCollection drafts = paysche.getDynamicObjectCollection("draftno");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)drafts) && EmptyUtil.isNoEmpty(draftIds)) {
                ArrayList<DraftLockInfo> releaseDraftInfos = new ArrayList<DraftLockInfo>(8);
                DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)backPayBillId, (String)"cas_paybill");
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                draftLockInfo.setSourceBillId(payBill.getLong("id"));
                draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
                draftLockInfo.setBizBillNo(payBill.getString("billno"));
                Object draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
                boolean isOld = false;
                if (EmptyUtil.isEmpty((Collection)draftInfoEntrys)) {
                    isOld = true;
                    DynamicObjectCollection draftbills = payBill.getDynamicObjectCollection("draftbill");
                    HashSet needLockDraftIds = new HashSet();
                    draftbills.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)needLockDraftIds)});
                    draftInfoEntrys = new ArrayList(draftArr);
                }
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (DynamicObject draftInfo : draftInfoEntrys) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo = PayScheHelper.getReleaseLockInfo(payBill, isDraftBook, false, draftInfo, isOld);
                    draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
                }
                if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoList)) {
                    draftLockInfo.setLockSubInfoList(draftAmountLockSubInfoList);
                    releaseDraftInfos.add(draftLockInfo);
                }
                if (!CollectionUtils.isEmpty(releaseDraftInfos)) {
                    DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
                    draftLockServiceHelper.releaseOrLockDraft(releaseDraftInfos);
                }
                draftIds.clear();
            }
        }
        PayBillBackResult payBillBackResult = new PayBillBackResult();
        ArrayList<DynamicObject> needCancelPayList = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> oldPsySchDataList = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> newPsySchDataList = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> changeStatusNewPaySch = new ArrayList<DynamicObject>(2);
        ArrayList<String> needCacheFiledList = new ArrayList<String>(10);
        ArrayList<Object> needUpdateList = new ArrayList<Object>(2);
        long[] newPkIds = null;
        if (EmptyUtil.isNoEmpty((Object[])paySchDataArr) && ((Object[])paySchDataArr).length > 0) {
            newPkIds = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias(), (int)((Object[])paySchDataArr).length);
        }
        int index = 0;
        Long curLoginOrg = RequestContext.get().getOrgId();
        String newBatchNum = CombineUtil.generateCombineNum(curLoginOrg);
        for (Object paySchData : paySchDataArr) {
            BigDecimal backAmount;
            List needRemoveData;
            List payData;
            DynamicObjectCollection paySchDataPayEntry;
            BigDecimal applyAmount = paySchData.getBigDecimal("applyamt");
            String batchNum = paySchData.getString("batchnum");
            DynamicObject oldPaySchData = TmcDataServiceHelper.clone((DynamicObject)paySchData);
            oldPaySchData.set("id", paySchData.getPkValue());
            oldPsySchDataList.add(oldPaySchData);
            BigDecimal amount = paySchData.getBigDecimal("amount");
            BigDecimal draftAmount = paySchData.getBigDecimal("draftamt");
            if (new BigDecimal(0).compareTo(amount) == 0 || new BigDecimal(0).compareTo(draftAmount) == 0) {
                logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u6392\u7a0b\u5355\u53ea\u6392\u6b3e\u6216\u53ea\u6392\u7968\uff0c\u65e0\u9700\u62c6\u5355\uff0c\u76f4\u63a5\u9000\u56de\uff0c\u6392\u7a0b\u5355id\uff1a{%s}", paySchData.getPkValue()));
                needCancelPayList.add((DynamicObject)paySchData);
                needUpdateList.add(paySchData);
                continue;
            }
            DynamicObject newPaySchData = TmcDataServiceHelper.clone((DynamicObject)paySchData);
            if (newPkIds == null) continue;
            Long newPkId = newPkIds[index];
            String newBillNo = CodeRuleHelper.generateNumber((String)"psd_schedulebill", (DynamicObject)newPaySchData, (String)newPaySchData.getDynamicObject("company").getPkValue().toString(), (String)"");
            newPaySchData.set("id", (Object)newPkId);
            newPaySchData.set("billno", (Object)newBillNo);
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "applyamt", oldPaySchData.getBigDecimal("applyamt").subtract(oldPaySchData.getBigDecimal("amount")));
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "scheduletotalamt", oldPaySchData.getBigDecimal("draftamt"));
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "amount", new BigDecimal(0));
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "checkamt", new BigDecimal(0));
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "checktotalamt", oldPaySchData.getBigDecimal("checktotalamt").subtract(oldPaySchData.getBigDecimal("checkamt")));
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "paymentno", "");
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "paybillstatus", "");
            this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "nopayamt", new BigDecimal(0));
            newPaySchData.set("draftpayno", (Object)"");
            newPaySchData.set("draftpaystatus", (Object)"");
            newPaySchData.set("draftnopayamt", (Object)new BigDecimal(0));
            newPaySchData.set("draftamt", (Object)new BigDecimal(0));
            newPaySchData.set("applyamt", (Object)oldPaySchData.getBigDecimal("applyamt").subtract(oldPaySchData.getBigDecimal("draftamt")));
            newPaySchData.set("scheduletotalamt", (Object)oldPaySchData.getBigDecimal("amount"));
            newPaySchData.set("checkdraftamt", (Object)new BigDecimal(0));
            newPaySchData.set("checktotalamt", (Object)oldPaySchData.getBigDecimal("checktotalamt").subtract(oldPaySchData.getBigDecimal("checkdraftamt")));
            newPaySchData.set("draftno", null);
            DynamicObjectCollection newPaySchDataPayEntry = newPaySchData.getDynamicObjectCollection("entrys");
            if (SettleMentTypeEnum.CHECK.getValue().equals(payBillType) || SettleMentTypeEnum.BUSINESS.getValue().equals(payBillType) || SettleMentTypeEnum.BANK.getValue().equals(payBillType) || SettleMentTypeEnum.CREDIT.getValue().equals(payBillType)) {
                logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u6240\u9000\u4ed8\u6b3e\u5355\u4e3a\u6392\u7968\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", backPayBillId));
                newPaySchData.set("balanceamt", (Object)oldPaySchData.getBigDecimal("balanceamt"));
                if (BillStatusEnum.PAYED.getValue().equals(oldPaySchData.get("paybillstatus"))) {
                    newPaySchData.set("schedulstatus", (Object)ScheStatusEnum.YETPAY.getValue());
                }
                this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "balanceamt", new BigDecimal(0));
                this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "applyamt", paySchData.getBigDecimal("applyamt").subtract(oldPaySchData.getBigDecimal("balanceamt")));
                paySchDataPayEntry = paySchData.getDynamicObjectCollection("entrys");
                payData = paySchDataPayEntry.stream().filter(i -> !i.get("e_payid").equals(backPayBillId) && i.get("e_billtype").equals("paybill") || i.get("e_billtype").equals("schebill")).collect(Collectors.toList());
                paySchDataPayEntry.removeAll(payData);
                needRemoveData = newPaySchDataPayEntry.stream().filter(i -> i.get("e_payid").equals(backPayBillId)).collect(Collectors.toList());
                newPaySchDataPayEntry.removeAll(needRemoveData);
                if (StringUtils.isNotEmpty((String)batchNum)) {
                    this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "batchnum", newBatchNum);
                } else {
                    this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "batchnum", "");
                }
                needCancelPayList.add((DynamicObject)paySchData);
            } else {
                logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u6240\u9000\u4ed8\u6b3e\u5355\u4e3a\u6392\u6b3e\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", backPayBillId));
                newPaySchData.set("applyamt", (Object)newPaySchData.getBigDecimal("applyamt").subtract(oldPaySchData.getBigDecimal("balanceamt")));
                if (BillStatusEnum.PAYED.getValue().equals(oldPaySchData.get("draftpaystatus"))) {
                    this.buildOldPaySchData(needCacheFiledList, (DynamicObject)paySchData, "schedulstatus", ScheStatusEnum.YETPAY.getValue());
                }
                newPaySchData.set("balanceamt", (Object)new BigDecimal(0));
                paySchDataPayEntry = paySchData.getDynamicObjectCollection("entrys");
                payData = paySchDataPayEntry.stream().filter(i -> i.get("e_payid").equals(backPayBillId)).collect(Collectors.toList());
                paySchDataPayEntry.removeAll(payData);
                needRemoveData = newPaySchDataPayEntry.stream().filter(i -> !i.get("e_payid").equals(backPayBillId) && i.get("e_billtype").equals("paybill") || i.get("e_billtype").equals("schebill")).collect(Collectors.toList());
                newPaySchDataPayEntry.removeAll(needRemoveData);
                newPaySchData.set("batchnum", (Object)"");
                needCancelPayList.add(newPaySchData);
            }
            needUpdateList.add(newPaySchData);
            needUpdateList.add(paySchData);
            newPsySchDataList.add(newPaySchData);
            if (backPayAmount != null && (backAmount = backPayAmount.get(paySchData.getPkValue())) != null && applyAmount.compareTo(backAmount) == 0) {
                changeStatusNewPaySch.add(newPaySchData);
            }
            ++index;
            logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u65e7\u6392\u7a0b\u5355id\uff1a{%s}\uff0c\u65b0\u6392\u7a0b\u5355id\uff1a{%s}", paySchData.getPkValue(), newPaySchData.getPkValue()));
        }
        this.buildCancelPay(needCacheFiledList, needCancelPayList, reason);
        this.setCacheData(backPayBillId, Long.valueOf(((DynamicObject)needCancelPayList.get(0)).getPkValue().toString()), needCacheFiledList, oldPsySchDataList, newPsySchDataList, draftIds);
        this.addNewScheduleBillInfo(changeStatusNewPaySch, reason);
        OperationResult savePayResult = null;
        try (TXHandle h = TX.requiresNew((String)"txsplitbillsave");){
            try {
                savePayResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])needUpdateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u4ed8\u6b3e\u5355\u9000\u5355-\u6392\u7a0b\u5355\u62c6\u5355\u5f02\u5e38", (Throwable)e);
                payBillBackResult.setErrMsg(e.getMessage());
                object = JSON.toJSONString((Object)payBillBackResult);
                if (h != null) {
                    if (var21_25 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable batchNum) {
                            var21_25.addSuppressed(batchNum);
                        }
                    } else {
                        h.close();
                    }
                }
                return object;
            }
        }
        if (savePayResult != null && savePayResult.isSuccess()) {
            logger.info(String.format("\u7968\u636e\u4fe1\u606f\u53d8\u66f4\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}\uff0c\u7968\u636e\u4fe1\u606f\uff1a{%s}", backPayBillId, LoggerPrintHelper.printCollectionLogger(draftIds)));
            if (!CollectionUtils.isEmpty(draftIds)) {
                h = TX.requiresNew((String)"txsplitbillsave");
                var21_25 = null;
                try {
                    try {
                        ArrayList<Object> filterDynamic = new ArrayList<Object>(1);
                        if (needCancelPayList.size() > 1) {
                            for (DynamicObject dynamicObject : needCancelPayList) {
                                Boolean isMasterData = dynamicObject.getBoolean("ismasterdata");
                                String batchNum = dynamicObject.getString("batchnum");
                                if (!isMasterData.booleanValue() || !StringUtils.isNotEmpty((String)batchNum)) continue;
                                filterDynamic.add(dynamicObject);
                            }
                        }
                        if (filterDynamic.size() == 0) {
                            filterDynamic.add(needCancelPayList.get(0));
                        }
                        this.changeDraftLock(draftIds, backPayBillId, Long.valueOf(((DynamicObject)filterDynamic.get(0)).getPkValue().toString()));
                    }
                    catch (Exception e) {
                        this.splitPsySchRollback(backPayBillId);
                        h.markRollback();
                        logger.error("\u4ed8\u6b3e\u5355\u9000\u5355-\u66f4\u65b0\u9501\u7968\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        payBillBackResult.setErrMsg(e.getMessage());
                        object = JSON.toJSONString((Object)payBillBackResult);
                        if (h != null) {
                            if (var21_25 != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable) {
                                    var21_25.addSuppressed(throwable);
                                }
                            } else {
                                h.close();
                            }
                        }
                        return object;
                    }
                }
                catch (Throwable e) {
                    var21_25 = e;
                    throw e;
                }
                finally {
                    if (h != null) {
                        if (var21_25 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable e) {
                                var21_25.addSuppressed(e);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
        }
        List<Long> newPkList = newPsySchDataList.stream().map(i -> (Long)i.getPkValue()).collect(Collectors.toList());
        List<Long> oldPkList = oldPsySchDataList.stream().map(i -> (Long)i.getPkValue()).collect(Collectors.toList());
        payBillBackResult.setNewPaySchBillIdList(newPkList);
        payBillBackResult.setOldPaySchBillIdList(oldPkList);
        String resultStr = JSON.toJSONString((Object)payBillBackResult);
        logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u7ed3\u679c\uff0c{%s}", resultStr));
        return resultStr;
    }

    @Override
    public void backPayBillRollBack(Long backPayBillId) {
        logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355-\u56de\u6eda\u3011\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", backPayBillId));
        DistributeSessionlessCache cacheInstance = TmcCacheHelper.getSessionlessCacheInstance();
        String cacheStr = (String)cacheInstance.get(String.format("%s%s", CACHE_KEY_BACKBILL, backPayBillId.toString()));
        if (StringUtils.isEmpty((String)cacheStr)) {
            logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355-\u56de\u6eda\u3011\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", backPayBillId));
            return;
        }
        this.splitPsySchRollback(backPayBillId);
        this.changeDraftLockRollBack(backPayBillId);
    }

    @Override
    public Set<Long> getSchePayBills(Set<Long> payBillIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("entrys.e_payid", "in", payBillIds), new QFilter("entrys.e_billtype", "=", (Object)"paybill")};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"psd_schedulebill", (String)"entrys.e_payid", (QFilter[])qFilters);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)collection)) {
            return new HashSet<Long>();
        }
        return collection.parallelStream().map(d -> d.getLong("entrys.e_payid")).collect(Collectors.toSet());
    }

    private void setCacheData(Long backPayBillId, Long paySchId, List<String> needCacheFiledList, List<DynamicObject> oldPsySchDataList, List<DynamicObject> newPsySchDataList, List<Long> draftIds) {
        logger.info("\u5b58\u5165\u7f13\u5b58\u7684\u6570\u636e\uff08setCacheData\uff09: backPayBillId={}, paySchId={}, needCacheFiledList={}, oldPsySchDataList={}, newPsySchDataList={}, draftIds={}", new Object[]{backPayBillId, paySchId, LoggerPrintHelper.printCollectionLogger(needCacheFiledList), LoggerPrintHelper.printDyObjLoggerByToString((DynamicObject[])oldPsySchDataList.toArray(new DynamicObject[0])), LoggerPrintHelper.printDyObjLoggerByToString((DynamicObject[])newPsySchDataList.toArray(new DynamicObject[0])), LoggerPrintHelper.printCollectionLogger(draftIds)});
        DistributeSessionlessCache cacheInstance = TmcCacheHelper.getSessionlessCacheInstance();
        PaySchBackCacheInfo paySchBackCacheInfo = new PaySchBackCacheInfo();
        if (!CollectionUtils.isEmpty(newPsySchDataList)) {
            List<Long> newPkList = newPsySchDataList.stream().map(i -> (Long)i.getPkValue()).collect(Collectors.toList());
            paySchBackCacheInfo.setNewPaySchIdList(newPkList);
        }
        HashMap<Long, Map<String, Object>> oldInfoMap = new HashMap<Long, Map<String, Object>>(5);
        HashMap<Long, List<Map<String, Object>>> oldEntryInfoMap = new HashMap<Long, List<Map<String, Object>>>(5);
        for (DynamicObject oldPaySch : oldPsySchDataList) {
            HashMap<String, Object> currOldInfoMap = new HashMap<String, Object>(5);
            for (String key : needCacheFiledList) {
                currOldInfoMap.put(key, oldPaySch.get(key));
            }
            oldInfoMap.put(oldPaySch.getLong("id"), currOldInfoMap);
            DynamicObjectCollection entryColl = oldPaySch.getDynamicObjectCollection("entrys");
            ArrayList currOldEntryInfoList = new ArrayList(5);
            for (DynamicObject entry : entryColl) {
                HashMap<String, Object> currOldEntryInfoMap = new HashMap<String, Object>(3);
                currOldEntryInfoMap.put("e_billtype", entry.get("e_billtype"));
                currOldEntryInfoMap.put("e_payentryid", entry.get("e_payentryid"));
                currOldEntryInfoMap.put("e_payid", entry.get("e_payid"));
                currOldEntryInfoList.add(currOldEntryInfoMap);
            }
            oldEntryInfoMap.put(oldPaySch.getLong("id"), currOldEntryInfoList);
        }
        paySchBackCacheInfo.setOldPaySchInfoMap(oldInfoMap);
        paySchBackCacheInfo.setOldPaySchEntryInfoMap(oldEntryInfoMap);
        if (!CollectionUtils.isEmpty(draftIds)) {
            paySchBackCacheInfo.setSourceBillId(paySchId);
            paySchBackCacheInfo.setSourceBillType("psd_schedulebill");
            paySchBackCacheInfo.setTargetBillId(backPayBillId);
            paySchBackCacheInfo.setTargetBillType("cas_paybill");
            paySchBackCacheInfo.setBillIdList(draftIds);
            logger.info("\u9501\u5b9a\u7684\u7968\u636e\u4fe1\u606f: {}", (Object)LoggerPrintHelper.printObjectLoggerByToString((Object[])new PaySchBackCacheInfo[]{paySchBackCacheInfo}));
        }
        cacheInstance.put(CACHE_KEY_BACKBILL + backPayBillId, (Object)JSON.toJSONString((Object)paySchBackCacheInfo), 300);
    }

    private List<String> buildOldPaySchData(List<String> needCacheFiledList, DynamicObject paySchData, String key, Object value) {
        needCacheFiledList.add(key);
        paySchData.set(key, value);
        return needCacheFiledList;
    }

    private void buildCancelPay(List<String> needCacheFiledList, List<DynamicObject> needCancelPayList, String reason) {
        for (DynamicObject payScheBill : needCancelPayList) {
            this.buildOldPaySchData(needCacheFiledList, payScheBill, "schedulstatus", ScheStatusEnum.YETSCHEDULE.getValue());
            this.buildOldPaySchData(needCacheFiledList, payScheBill, "iscasexitbill", "1");
            this.buildOldPaySchData(needCacheFiledList, payScheBill, "backreason", reason);
            BigDecimal applyAmt = payScheBill.getBigDecimal("applyamt");
            this.buildOldPaySchData(needCacheFiledList, payScheBill, "waitpayamt", applyAmt);
            DynamicObjectCollection entryColl = payScheBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryColl) {
                if (!"paybill".equals(entry.getString("e_billtype"))) continue;
                entry.set("e_billtype", (Object)"schebill");
            }
        }
    }

    private void addNewScheduleBillInfo(List<DynamicObject> newScheduleBills, String reason) {
        for (DynamicObject newScheduleBill : newScheduleBills) {
            newScheduleBill.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
            newScheduleBill.set("iscasexitbill", (Object)"1");
            newScheduleBill.set("backreason", (Object)reason);
            DynamicObjectCollection drafts = newScheduleBill.getDynamicObjectCollection("draftno");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)drafts)) {
                DynamicObjectCollection draftinfoEntryCol = newScheduleBill.getDynamicObjectCollection("draftinfoentry");
                draftinfoEntryCol.clear();
            }
            DynamicObjectCollection entryColl = newScheduleBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryColl) {
                if (!"paybill".equals(entry.getString("e_billtype"))) continue;
                entry.set("e_billtype", (Object)"schebill");
            }
        }
    }

    private void changeDraftLock(List<Long> draftIds, Long backPayBillId, Long paySchId) {
        logger.info(String.format("\u3010\u6392\u7a0b\u4ed8\u6b3e\u5355\u9000\u5355\u3011\u7968\u636e\u9501\u5b9a\u4fe1\u606f\u53d8\u66f4\uff0c\u7968\u636eid\uff1a{%s}\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}\uff0c\u6392\u7a0b\u5355id\uff1a{%s}", JSON.toJSONString(draftIds), backPayBillId, paySchId));
        DraftLockInfo draftLockInfo = PayScheHelper.getPayToSchChangeLockInfo(backPayBillId, paySchId);
        if (EmptyUtil.isNoEmpty((Object)draftLockInfo)) {
            DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
            ArrayList<DraftLockInfo> linkInfoList = new ArrayList<DraftLockInfo>(1);
            linkInfoList.add(draftLockInfo);
            draftLockServiceHelper.changeDraftLock(linkInfoList);
        }
    }

    private void changeDraftLockRollBack(Long backPayBillId) {
        logger.info(String.format("\u4ed8\u6b3e\u5355\u9000\u5355-\u7968\u636e\u9501\u5b9a\u4fe1\u606f\u53d8\u66f4\u56de\u6eda\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", backPayBillId));
        DistributeSessionlessCache cacheInstance = TmcCacheHelper.getSessionlessCacheInstance();
        String cacheStr = (String)cacheInstance.get(String.format("%s%s", CACHE_KEY_BACKBILL, backPayBillId.toString()));
        PaySchBackCacheInfo paySchBackCacheInfo = (PaySchBackCacheInfo)JSON.parseObject((String)cacheStr, PaySchBackCacheInfo.class);
        List<Long> billIdList = paySchBackCacheInfo.getBillIdList();
        if (!CollectionUtils.isEmpty(billIdList)) {
            DraftLockInfo draftLockInfo;
            ArrayList<DraftLockInfo> linkInfoList = new ArrayList<DraftLockInfo>(1);
            String sourceBillType = paySchBackCacheInfo.getSourceBillType();
            Long sourceBillId = paySchBackCacheInfo.getSourceBillId();
            Long targetBillId = paySchBackCacheInfo.getTargetBillId();
            if ("psd_schedulebill".equals(sourceBillType)) {
                draftLockInfo = PayScheHelper.getSchToPayChangeLockInfo(targetBillId, sourceBillId);
                linkInfoList.add(draftLockInfo);
            } else if ("cas_paybill".equals(sourceBillType)) {
                draftLockInfo = PayScheHelper.getPayToSchChangeLockInfo(sourceBillId, targetBillId);
                linkInfoList.add(draftLockInfo);
            }
            if (EmptyUtil.isNoEmpty(linkInfoList)) {
                DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
                draftLockServiceHelper.changeDraftLock(linkInfoList);
            }
        }
    }

    private void splitPsySchRollback(Long backPayBillId) {
        DynamicObject[] oldPaySchDbDataArr;
        logger.info("\u4ed8\u6b3e\u5355\u9000\u5355-\u62c6\u6392\u7a0b\u5355\u56de\u6eda\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}", (Object)backPayBillId);
        DistributeSessionlessCache cacheInstance = TmcCacheHelper.getSessionlessCacheInstance();
        String cacheStr = (String)cacheInstance.get(String.format("%s%s", CACHE_KEY_BACKBILL, backPayBillId.toString()));
        PaySchBackCacheInfo paySchBackCacheInfo = (PaySchBackCacheInfo)JSON.parseObject((String)cacheStr, PaySchBackCacheInfo.class);
        List<Long> newPaySchIdList = paySchBackCacheInfo.getNewPaySchIdList();
        Map<Long, Map<String, Object>> oldPaySchInfoList = paySchBackCacheInfo.getOldPaySchInfoMap();
        Map<Long, List<Map<String, Object>>> oldPaySchEntryInfoMap = paySchBackCacheInfo.getOldPaySchEntryInfoMap();
        Set<Long> oldPaySchIdS = oldPaySchInfoList.keySet();
        for (DynamicObject dbData : oldPaySchDbDataArr = TmcDataServiceHelper.load((Object[])oldPaySchIdS.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"))) {
            Map<String, Object> needSetDataMap = oldPaySchInfoList.get(dbData.getPkValue());
            for (Map.Entry<String, Object> next : needSetDataMap.entrySet()) {
                dbData.set(next.getKey(), next.getValue());
            }
            DynamicObjectCollection entryColl = dbData.getDynamicObjectCollection("entrys");
            entryColl.clear();
            List<Map<String, Object>> needSetEntryDataList = oldPaySchEntryInfoMap.get(dbData.getPkValue());
            for (Map<String, Object> needSetEntryDataMap : needSetEntryDataList) {
                Iterator<Map.Entry<String, Object>> entryIterator = needSetEntryDataMap.entrySet().iterator();
                DynamicObject entryData = entryColl.addNew();
                while (entryIterator.hasNext()) {
                    Map.Entry<String, Object> next = entryIterator.next();
                    entryData.set(next.getKey(), next.getValue());
                }
            }
        }
        try (TXHandle h = TX.requiresNew((String)"txsplitbill");){
            try {
                if (!CollectionUtils.isEmpty(newPaySchIdList)) {
                    DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"), (Object[])newPaySchIdList.toArray());
                }
                SaveServiceHelper.save((DynamicObject[])oldPaySchDbDataArr);
                h.commit();
            }
            catch (Exception e) {
                h.markRollback();
                logger.error(String.format("\u4ed8\u6b3e\u5355\u9000\u5355-\u6392\u7a0b\u5355\u62c6\u5355-\u56de\u6eda\u5f02\u5e38,%s", JSON.toJSONString((Object)e)));
            }
        }
    }

    private String synPayInfo2PaySche(String payBillIdListJson, String opType) {
        logger.info("\u540c\u6b65\u4ed8\u6b3e\u4fe1\u606f\u64cd\u4f5c\u7c7b\u578b\uff1a{}", (Object)opType);
        Map params = (Map)JSON.parseObject((String)payBillIdListJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String payBillStatus = String.valueOf(params.getOrDefault("status", ""));
        if (BeBillStatusEnum.TS.getValue().equals(payBillStatus)) {
            payBillStatus = BillStatusEnum.PAYED.getValue();
        }
        List payBillIdList = (List)JSON.parseObject((String)((String)params.get("payBillIds")), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        DynamicObject[] payBills = TmcDataServiceHelper.load((Object[])payBillIdList.toArray(new Object[payBillIdList.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        DynamicObject[] payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", SELECTOR), (QFilter[])new QFilter[]{new QFilter("entrys.e_payid", "in", (Object)payBillIdList)});
        if (payScheBills.length > 0) {
            List<Object> collect = Stream.of(payScheBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            payScheBills = TmcDataServiceHelper.load((Object[])collect.toArray(new Object[collect.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        }
        HashMap payBillMap = new HashMap();
        Stream.of(payBills).forEach(v -> payBillMap.put(v.getString("id"), v));
        for (DynamicObject payScheBill : payScheBills) {
            if (opType.equals(OP_CANCELPAY)) {
                if (!this.isAllPayed(payScheBill)) {
                    payScheBill.set("schedulstatus", (Object)ScheStatusEnum.PAYING.getValue());
                }
            } else if (opType.equals(OP_PAY) && this.isAllPayed(payScheBill)) {
                payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETPAY.getValue());
                logger.info("\u540c\u6b65\u6392\u7a0b\u5355\u72b6\u6001\u4e3a", (Object)payScheBill.getString("schedulstatus"));
            }
            DynamicObjectCollection payScheEntrys = payScheBill.getDynamicObjectCollection("entrys");
            for (DynamicObject payScheEntry : payScheEntrys) {
                String ePayId = payScheEntry.getString("e_payid");
                String ePayEntryId = payScheEntry.getString("e_payentryid");
                DynamicObject payBill = (DynamicObject)payBillMap.get(ePayId);
                if (null == payBill) continue;
                DynamicObject settleType = payBill.getDynamicObject("settletype");
                String[] settlementtypes = new String[]{SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.CREDIT.getValue()};
                List<String> settlementtypeList = Arrays.asList(settlementtypes);
                DynamicObjectCollection payBillEntrys = payBill.getDynamicObjectCollection("entry");
                if (settleType == null) continue;
                if (settlementtypeList.contains(settleType.getString("settlementtype"))) {
                    payScheBill.set("draftpayno", (Object)payBill.getString("billno"));
                    payScheBill.set("draftpaystatus", (Object)payBillStatus);
                    this.setAmt(payBillEntrys, ePayEntryId, payScheBill, "draftnopayamt", "checkdraftamt");
                    continue;
                }
                payScheBill.set("paymentno", (Object)payBill.getString("billno"));
                payScheBill.set("paybillstatus", (Object)payBillStatus);
                this.setAmt(payBillEntrys, ePayEntryId, payScheBill, "nopayamt", "checkamt");
            }
        }
        List<PayScheRpcResult> resultList = this.doSaveOp(payScheBills);
        return JSON.toJSONString(resultList);
    }

    private void setAmt(DynamicObjectCollection payBillEntrys, String ePayEntryId, DynamicObject payScheBill, String key1, String key2) {
        for (DynamicObject entry : payBillEntrys) {
            if (!ePayEntryId.equals(entry.getString("id"))) continue;
            BigDecimal writeBackAmt = entry.getBigDecimal("e_payableamt");
            payScheBill.set(key1, (Object)payScheBill.getBigDecimal(key2).subtract(writeBackAmt));
            break;
        }
    }

    private boolean isAllPayed(DynamicObject payScheBill) {
        List payBillIds;
        DynamicObjectCollection entrys = payScheBill.getDynamicObjectCollection("entrys");
        if (!CollectionUtils.isEmpty((Collection)entrys) && !CollectionUtils.isEmpty(payBillIds = entrys.stream().filter(Objects::nonNull).filter(p -> p.getString("e_billtype").equals("paybill")).map(o -> Long.valueOf(o.getString("e_payid"))).collect(Collectors.toList()))) {
            DynamicObject[] payBills;
            for (DynamicObject payBill : payBills = TmcDataServiceHelper.load((Object[])payBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"))) {
                if (payBill.getString("billstatus").equals(BillStatusEnum.PAYED.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<PayScheRpcResult> doSaveOp(DynamicObject[] payScheBills) {
        ArrayList<PayScheRpcResult> resultList = new ArrayList<PayScheRpcResult>();
        HashMap billMap = new HashMap();
        Stream.of(payScheBills).forEach(v -> billMap.put(v.getLong("id"), v));
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_schedealbill", (DynamicObject[])payScheBills, (OperateOption)OperateOption.create());
                if (!saveResult.isSuccess()) {
                    String errMessage = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)saveResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"PayScheRpcApiImpl_0", (String)"tmc-psd-business", (Object[])new Object[0]), errMessage));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                resultList.addAll(Stream.of(payScheBills).map(o -> {
                    PayScheRpcResult result = new PayScheRpcResult();
                    result.setPayScheId(o.getLong("id"));
                    result.setStatus(RpcStatus.ROLLBACK);
                    result.setPayBillId(o.getLong("payid"));
                    result.setPayBillEntryId(o.getLong("payentryid"));
                    result.setErrMsg(e.getMessage());
                    return result;
                }).collect(Collectors.toList()));
            }
        }
        return resultList;
    }

    public DtxResponse execute(Object arg01, Object arg02) throws Exception {
        CommonParam param = (CommonParam)arg01;
        String operation = param.getString((Object)"operation");
        logger.info("\u64cd\u4f5c\u53c2\u6570operation\uff1a{}", (Object)operation);
        if ("pay".equals(operation)) {
            this.pay((String)param.get((Object)"pay"));
        } else if ("synPaySche".equals(operation)) {
            this.synPaySche((String)param.get((Object)"synPaySche"));
        }
        return null;
    }
}

