/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;

public abstract class AbstractSumScheService<T extends SumScheData>
implements ISumScheService<T> {
    @Override
    public void calculateSumInfo(List<T> scheSumInfoList, List<PayScheCalcModel> oldDataList, List<PayScheCalcModel> newDataList, List<PayScheCalcModel> deleteDataList) {
        SumScheData sumData;
        Map<Long, SumScheData> scheMapBySumId = scheSumInfoList.stream().collect(Collectors.toMap(SumScheData::getSummaryId, o -> o, (entity1, entity2) -> entity1));
        Map<Long, List<PayScheCalcModel>> oldScheMapBySumId = oldDataList.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        Map<Long, List<PayScheCalcModel>> newScheMapBySumId = newDataList.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        Set currencyIdSet = Stream.concat(oldDataList.stream(), newDataList.stream()).map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet());
        Map scaleMap = TmcAmountHelper.getScaleMap(currencyIdSet);
        for (Map.Entry<Long, List<PayScheCalcModel>> newEntry : newScheMapBySumId.entrySet()) {
            List<PayScheCalcModel> newScheDataList = newEntry.getValue();
            sumData = scheMapBySumId.get(newEntry.getKey());
            if (!EmptyUtil.isNoEmpty((Object)sumData)) continue;
            List<PayScheCalcModel> oldScheDataList = oldScheMapBySumId.get(newEntry.getKey());
            Map scheDataMapByScheId = null;
            if (oldScheDataList != null) {
                scheDataMapByScheId = oldScheDataList.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, o -> o, (o1, o2) -> o1, HashMap::new));
            }
            this.beforeHandleSumInfo(sumData);
            for (PayScheCalcModel newScheData : newScheDataList) {
                if (newScheData.isArchiveMerger()) continue;
                PayScheCalcModel oldScheData = null;
                if (scheDataMapByScheId != null) {
                    oldScheData = (PayScheCalcModel)scheDataMapByScheId.get(newScheData.getScheId());
                }
                this.handleSumInfo(sumData, oldScheData, newScheData, scaleMap);
            }
            this.afterHandleSumInfo(sumData);
        }
        for (PayScheCalcModel deleteData : deleteDataList) {
            if (deleteData.isArchiveMerger()) continue;
            Long sumId = deleteData.getSummaryId();
            sumData = scheMapBySumId.get(sumId);
            this.beforeHandleSumInfo(sumData);
            this.handleSumInfo(sumData, deleteData, null, scaleMap);
            this.afterHandleSumInfo(sumData);
        }
    }

    protected void beforeHandleSumInfo(T sumData) {
    }

    protected void handleSumInfo(T sumData, PayScheCalcModel oldScheData, PayScheCalcModel newScheData, Map<Long, Integer> scaleMap) {
    }

    protected void afterHandleSumInfo(T sumData) {
    }
}

