/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSplitSumData;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractSumScheService;

public class SplitSumScheService
extends AbstractSumScheService<PayScheSplitSumData> {
    private PayScheCalcModel originModel;

    public SplitSumScheService(PayScheCalcModel originModel) {
        this.originModel = originModel;
    }

    @Override
    public List<PayScheSplitSumData> loadSummaryData(List<PayScheCalcModel> payScheDataList) {
        List needCreateSummaryCardPaySches = payScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        PayScheSplitSumData sumData = new PayScheSplitSumData();
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal scheAmt = BigDecimal.ZERO;
        BigDecimal billAmt = BigDecimal.ZERO;
        BigDecimal splitAmt = BigDecimal.ZERO;
        for (PayScheCalcModel scheData : needCreateSummaryCardPaySches) {
            balance = balance.add(scheData.getScheBalance());
            scheAmt = scheAmt.add(scheData.getScheAmt());
            billAmt = billAmt.add(scheData.getDraftBillAmt());
            splitAmt = splitAmt.add(scheData.getApplyAmt());
        }
        sumData.setSummaryId(0L);
        sumData.setScheAmt(scheAmt);
        sumData.setBillAmt(billAmt);
        sumData.setBalance(this.originModel.getApplyAmt());
        sumData.setSplitBalance(this.originModel.getApplyAmt().subtract(splitAmt));
        return new ArrayList<PayScheSplitSumData>(Collections.singletonList(sumData));
    }

    @Override
    public List<PayScheSplitSumData> rebuildSummaryData(List<PayScheCalcModel> payScheDataList) {
        return this.loadSummaryData(payScheDataList);
    }

    @Override
    protected void handleSumInfo(PayScheSplitSumData sumData, PayScheCalcModel oldScheData, PayScheCalcModel newScheData, Map<Long, Integer> scaleMap) {
        BigDecimal splitAmtDiff;
        BigDecimal billAmtDiff;
        BigDecimal scheAmtDiff;
        super.handleSumInfo(sumData, oldScheData, newScheData, scaleMap);
        if (oldScheData == null) {
            BigDecimal rate = newScheData.getExchangerate();
            scheAmtDiff = this.getSumAmt(newScheData.getScheAmt(), rate);
            billAmtDiff = this.getSumAmt(newScheData.getDraftBillAmt(), rate);
            splitAmtDiff = newScheData.getApplyAmt().negate();
        } else if (newScheData == null) {
            BigDecimal rate = oldScheData.getExchangerate();
            scheAmtDiff = this.getSumAmt(oldScheData.getScheAmt().negate(), rate);
            billAmtDiff = this.getSumAmt(oldScheData.getDraftBillAmt().negate(), rate);
            splitAmtDiff = oldScheData.getApplyAmt();
        } else {
            BigDecimal rate = newScheData.getExchangerate();
            scheAmtDiff = this.getSumAmt(newScheData.getScheAmt().subtract(oldScheData.getScheAmt()), rate);
            billAmtDiff = this.getSumAmt(newScheData.getDraftBillAmt().subtract(oldScheData.getDraftBillAmt()), rate);
            splitAmtDiff = newScheData.getApplyAmt().subtract(oldScheData.getApplyAmt()).negate();
        }
        sumData.setScheAmt(sumData.getScheAmt().add(scheAmtDiff));
        sumData.setBillAmt(sumData.getBillAmt().add(billAmtDiff));
        sumData.setSplitBalance(sumData.getSplitBalance().add(splitAmtDiff));
    }

    @Override
    protected void afterHandleSumInfo(PayScheSplitSumData sumData) {
        super.afterHandleSumInfo(sumData);
        sumData.setBalance(this.originModel.getApplyAmt().subtract(sumData.getScheAmt().add(sumData.getBillAmt())));
    }

    private BigDecimal getSumAmt(BigDecimal amt, BigDecimal rate) {
        return amt.divide(rate, RoundingMode.HALF_UP);
    }
}

