/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.sumsche;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.sumsche.data.PrimeRuleVal;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumSchePrimeRule;
import kd.tmc.psd.common.enums.AsstActTypeEnum;
import kd.tmc.psd.common.enums.PsdEffectEleEnum;

public class SumSchePrimeComparator
implements Comparator<WaitScheData> {
    private List<SumSchePrimeRule> ruleList;
    private Map<String, Map<Long, Object>> primeDataValMap;

    public SumSchePrimeComparator(List<SumSchePrimeRule> ruleList, List<WaitScheData> dataList) {
        this.ruleList = ruleList;
        this.buildPrimeValDataMap(dataList);
    }

    @Override
    public int compare(WaitScheData o1, WaitScheData o2) {
        for (SumSchePrimeRule rule : this.ruleList) {
            PayScheCalcModel data2;
            PayScheCalcModel data1;
            int result = this.compare(rule, data1 = o1.getPayScheData(), data2 = o2.getPayScheData());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(SumSchePrimeRule rule, PayScheCalcModel data1, PayScheCalcModel data2) {
        String dimType = rule.getDimType();
        int dimCate = SumSchePrimeRule.getDimCate(dimType);
        Object dimVal1 = this.getPrimeVal(data1, rule.getDimType());
        Object dimVal2 = this.getPrimeVal(data2, rule.getDimType());
        Integer prime1 = null;
        Integer prime2 = null;
        if (dimCate == 1) {
            List sortedValList = rule.getSortedValList();
            for (int i = 0; i < sortedValList.size() && prime1 == null && prime2 == null; ++i) {
                PrimeRuleVal val = (PrimeRuleVal)sortedValList.get(i);
                if (val.getValue().equals(dimVal1)) {
                    prime1 = i;
                }
                if (!val.getValue().equals(dimVal2)) continue;
                prime2 = i;
            }
        } else if (dimCate == 2 || dimCate == 3) {
            List sortedValList = rule.getSortedValList();
            for (int i = 0; i < sortedValList.size() && prime1 == null && prime2 == null; ++i) {
                List val = (List)sortedValList.get(i);
                Set valSet = val.stream().map(PrimeRuleVal::getValue).collect(Collectors.toSet());
                if (valSet.contains(dimVal1)) {
                    prime1 = i;
                }
                if (!valSet.contains(dimVal2)) continue;
                prime2 = i;
            }
        } else {
            if (PsdEffectEleEnum.APPLYDATE.getValue().equals(dimType) || PsdEffectEleEnum.EXPECTPAYDATE.getValue().equals(dimType)) {
                Date date1 = (Date)dimVal1;
                Date date2 = (Date)dimVal2;
                return date1.compareTo(date2);
            }
            return 0;
        }
        if (prime1 == null) {
            prime1 = Integer.MAX_VALUE;
        }
        if (prime2 == null) {
            prime2 = Integer.MAX_VALUE;
        }
        return prime1.compareTo(prime2);
    }

    private void buildPrimeValDataMap(List<WaitScheData> dataList) {
        this.primeDataValMap = new HashMap<String, Map<Long, Object>>();
        Map<Object, Object> projectId2ProjectTypeMap = new HashMap();
        Map<Object, Object> supplierId2SupTypeMap = new HashMap();
        Map<Object, Object> paymentTypeId2SupTypeMap = new HashMap(16);
        List scheDataList = dataList.stream().map(WaitScheData::getPayScheData).collect(Collectors.toList());
        HashSet<Long> projectIdSet = new HashSet<Long>();
        HashSet<Long> supplierIdSet = new HashSet<Long>();
        HashSet<Long> paymentTypeIdSet = new HashSet<Long>(16);
        for (PayScheCalcModel scheData : scheDataList) {
            Long paymentTypeId;
            Long projectId;
            Long recId;
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(scheData.getRecType()) && (recId = scheData.getRecId()) != null && !recId.equals(0L)) {
                supplierIdSet.add(recId);
            }
            if ((projectId = scheData.getProjectId()) != null && !projectId.equals(0L)) {
                projectIdSet.add(projectId);
            }
            if ((paymentTypeId = scheData.getPaymenttypeId()) == null || paymentTypeId.equals(0L)) continue;
            paymentTypeIdSet.add(paymentTypeId);
        }
        if (projectIdSet.size() > 0) {
            DynamicObject[] projectArr = TmcDataServiceHelper.load((Object[])projectIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
            projectId2ProjectTypeMap = Arrays.stream(projectArr).collect(Collectors.toMap(o -> (Long)o.getPkValue(), o -> {
                DynamicObject projectType = o.getDynamicObject("group");
                return projectType != null ? projectType.getPkValue() : Long.valueOf(0L);
            }));
        }
        if (supplierIdSet.size() > 0) {
            DynamicObject[] supplierArr = TmcDataServiceHelper.load((Object[])supplierIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_supplier"));
            supplierId2SupTypeMap = Arrays.stream(supplierArr).collect(Collectors.toMap(o -> (Long)o.getPkValue(), o -> {
                DynamicObject suppierType = o.getDynamicObject("group");
                return suppierType != null ? suppierType.getPkValue() : Long.valueOf(0L);
            }));
        }
        if (paymentTypeIdSet.size() > 0) {
            DynamicObject[] paymentTypeArr = TmcDataServiceHelper.load((Object[])paymentTypeIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paymentbilltype"));
            paymentTypeId2SupTypeMap = Arrays.stream(paymentTypeArr).collect(Collectors.toMap(o -> (Long)o.getPkValue(), Function.identity()));
        }
        this.primeDataValMap.put(PsdEffectEleEnum.PROJECTSORT.getValue(), projectId2ProjectTypeMap);
        this.primeDataValMap.put(PsdEffectEleEnum.SUPPLIERSORT.getValue(), supplierId2SupTypeMap);
        this.primeDataValMap.put(PsdEffectEleEnum.PAYBILLTYPE.getValue(), paymentTypeId2SupTypeMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getPrimeVal(PayScheCalcModel data, String primeDimType) {
        if (PsdEffectEleEnum.APPLYDATE.getValue().equals(primeDimType)) {
            return data.getApplyDate();
        }
        if (PsdEffectEleEnum.EXPECTPAYDATE.getValue().equals(primeDimType)) {
            return data.getExpectDate();
        }
        if (PsdEffectEleEnum.PROJECTSORT.getValue().equals(primeDimType)) {
            Map<Long, Object> map = this.primeDataValMap.get(PsdEffectEleEnum.PROJECTSORT.getValue());
            Long projectId = data.getProjectId();
            if (projectId == null) return null;
            if (projectId.equals(0L)) return null;
            Long typeId = (Long)map.get(data.getProjectId());
            if (typeId == null) return null;
            if (typeId.equals(0L)) return null;
            return typeId.toString();
        }
        if (PsdEffectEleEnum.PROJECTGROUP.getValue().equals(primeDimType)) {
            if (data.getProjectId() == null) return null;
            String string = data.getProjectId().toString();
            return string;
        }
        if (PsdEffectEleEnum.SUPPLIERGROUP.getValue().equals(primeDimType)) {
            if (!AsstActTypeEnum.SUPPLIER.getValue().equals(data.getRecType())) return null;
            if (data.getRecId() == null) return null;
            String string = data.getRecId().toString();
            return string;
        }
        if (PsdEffectEleEnum.SUPPLIERSORT.getValue().equals(primeDimType)) {
            if (!AsstActTypeEnum.SUPPLIER.getValue().equals(data.getRecType())) return null;
            Long supplierId = data.getRecId();
            Map<Long, Object> map = this.primeDataValMap.get(PsdEffectEleEnum.SUPPLIERSORT.getValue());
            if (supplierId == null) return null;
            if (supplierId.equals(0L)) return null;
            Long typeId = (Long)map.get(supplierId);
            if (typeId == null) return null;
            if (typeId.equals(0L)) return null;
            return typeId.toString();
        }
        if (!PsdEffectEleEnum.PAYBILLTYPE.getValue().equals(primeDimType)) throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"SumSchePrimeRule_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        Long payBillId = data.getPaymenttypeId();
        Map<Long, Object> map = this.primeDataValMap.get(PsdEffectEleEnum.PAYBILLTYPE.getValue());
        if (payBillId == null) return null;
        if (payBillId.equals(0L)) return null;
        DynamicObject object = (DynamicObject)map.get(payBillId);
        if (object == null) return null;
        if (!EmptyUtil.isNoEmpty((DynamicObject)object)) return null;
        Long objectId = object.getLong("id");
        return objectId.toString();
    }
}

