/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;
import kd.tmc.psd.common.enums.ScheCycleEnum;

public class WeeklySchePeriodCalc
extends AbstractSchePeriodCalc {
    public WeeklySchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        super(calcResult, schePeriod);
    }

    @Override
    protected void calculate(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        Date startDate = schePeriod.getStartDate();
        Date lastDate = schePeriod.getEndDate();
        Integer year = schePeriod.getYear();
        String cycle = schePeriod.getCycle();
        boolean isCrossMonth = ScheCycleEnum.YEAR.getValue().equals(cycle);
        Date currMaxDay = null;
        int index = 1;
        while (startDate.compareTo(lastDate) < 0) {
            currMaxDay = DateUtils.getMaxMonthDate((Date)startDate);
            Date endDate = null;
            int currWeek = DateUtils.getCurrWeek((Date)startDate);
            endDate = currWeek == 0 && (index == 1 || DateUtils.getDataFormat((Date)startDate, (boolean)true).compareTo(DateUtils.getFirstDayOfMonth((Date)startDate)) == 0) ? (Date)DateUtils.getWeekDate((Date)DateUtils.getNextDay((Date)startDate, (int)1)).get("endDate") : (Date)DateUtils.getWeekDate((Date)startDate).get("endDate");
            if (!(isCrossMonth || endDate.compareTo(currMaxDay) <= 0 && endDate.compareTo(DateUtils.getLastDay((Date)currMaxDay, (int)1)) != 0)) {
                endDate = currMaxDay;
            }
            endDate = lastDate.compareTo(endDate) < 0 ? lastDate : endDate;
            ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(index).name(this.getPeriodName(year, index)).startDate(startDate).endDate(endDate).diffDays(DateUtils.getDiffDays((Date)startDate, (Date)endDate)).build();
            calcResult.add(result);
            startDate = DateUtils.getNextDay((Date)endDate, (int)1);
            ++index;
        }
    }
}

