/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.helper.PayScheHelper;

public class TransNextTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TransNextTask.class);

    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        logger.info("TransNextTask execute start");
        Date currentDate = DateUtils.getCurrentDate();
        QFilter dateFilter = new QFilter("expectdate", "<", (Object)currentDate);
        QFilter balanceFilter = new QFilter("waitpayamt", "!=", (Object)BigDecimal.ZERO);
        QFilter notExisNextFilter = new QFilter("nextscheduleid", "=", (Object)0);
        QFilter statusFilter = new QFilter("schedulstatus", "in", (Object)new String[]{ScheStatusEnum.NOSCHEDULE.getValue(), ScheStatusEnum.PAYING.getValue(), ScheStatusEnum.YETPAY.getValue()});
        DynamicObjectCollection scheduleBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", "id", "company", "expectdate", "schedulstatus", "issplit"), (QFilter[])new QFilter[]{dateFilter, balanceFilter, notExisNextFilter, statusFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)scheduleBills)) {
            return;
        }
        Set<Long> orgIds = new HashSet<Long>(scheduleBills.size());
        for (DynamicObject scheduleBill : scheduleBills) {
            orgIds.add(scheduleBill.getLong("company"));
        }
        orgIds = orgIds.stream().filter(Objects::nonNull).filter(o -> this.isOnTimeSche(Long.valueOf(o.toString()))).collect(Collectors.toSet());
        Object[] autoScheRules = TmcDataServiceHelper.load((String)"psd_autoschedule_rule", (String)String.join((CharSequence)",", "scheduleperiod", "orgentryentity.org"), (QFilter[])new QFilter[]{new QFilter("orgentryentity.org.id", "in", orgIds), new QFilter("enable", "=", (Object)Boolean.TRUE), PayScheHelper.buildAutoRuleEffDateFilter()});
        HashMap autoScheRuleMap = new HashMap(autoScheRules.length);
        if (EmptyUtil.isNoEmpty((Object[])autoScheRules)) {
            for (Object autoScheRule : autoScheRules) {
                DynamicObjectCollection applyOrgs = autoScheRule.getDynamicObjectCollection("orgentryentity");
                applyOrgs.stream().filter(Objects::nonNull).forEach(arg_0 -> this.lambda$execute$1((DynamicObject)autoScheRule, autoScheRuleMap, arg_0));
            }
        }
        int currYear = DateUtils.getYear((Date)currentDate);
        Object[] schePeriods = TmcDataServiceHelper.load((String)"psd_schedule_period", (String)String.join((CharSequence)",", "schetype", "startdate"), (QFilter[])new QFilter[]{new QFilter("periodyear", "=", (Object)currYear), new QFilter("startdate", "<=", (Object)currentDate), new QFilter("enddate", ">=", (Object)currentDate)});
        HashMap periodDates = new HashMap(schePeriods.length);
        if (EmptyUtil.isNoEmpty((Object[])schePeriods)) {
            Arrays.stream(schePeriods).filter(o -> Objects.nonNull(o.getDynamicObject("schetype"))).forEach(schePeriod -> periodDates.put(schePeriod.getDynamicObject("schetype").getPkValue(), schePeriod.getDate("startdate")));
        }
        ArrayList<Long> transBillIds = new ArrayList<Long>(scheduleBills.size());
        for (DynamicObject scheduleBill : scheduleBills) {
            boolean isDiffSplit;
            Date periodDate;
            Long orgPkValue = scheduleBill.getLong("company");
            Date expectDate = scheduleBill.getDate("expectdate");
            Object periodType = autoScheRuleMap.get(orgPkValue);
            if (periodType == null || (periodDate = (Date)periodDates.get(periodType)) == null || (isDiffSplit = scheduleBill.getBoolean("issplit")) || expectDate.compareTo(periodDate) >= 0) continue;
            transBillIds.add(scheduleBill.getLong("id"));
        }
        logger.info("\u8f6c\u4e0b\u671f\u5355\u636eID\u96c6\u5408 transBillIds\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(transBillIds));
        if (!EmptyUtil.isEmpty(transBillIds)) {
            DynamicObject[] transBills;
            ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(transBillIds.size());
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(transBillIds.size());
            for (DynamicObject transBill : transBills = BusinessDataServiceHelper.load((Object[])transBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"))) {
                DynamicObject newScheduleBill = null;
                try {
                    newScheduleBill = AutoScheHelper.transToNextPeriod(transBill);
                }
                catch (Exception e) {
                    logger.info("PayScheBillExecuteService transToNextPeriod : " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    continue;
                }
                insertList.add(newScheduleBill);
                DynamicObject upBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
                upBill.set("id", transBill.getPkValue());
                if (ScheStatusEnum.NOSCHEDULE.getValue().equals(transBill.getString("schedulstatus"))) {
                    upBill.set("schedulstatus", (Object)ScheStatusEnum.TONEXT.getValue());
                }
                upBill.set("nextscheduleid", (Object)newScheduleBill.getLong("id"));
                updateList.add(upBill);
            }
            if (!EmptyUtil.isEmpty(insertList)) {
                SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
            }
            if (!EmptyUtil.isEmpty(updateList)) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
            }
        }
        logger.info("TransNextTask execute end");
    }

    private boolean isOnTimeSche(Long orgId) {
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        return (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)orgId, (String)"ontimesche");
    }

    private /* synthetic */ void lambda$execute$1(DynamicObject autoScheRule, Map autoScheRuleMap, DynamicObject applyOrgEntry) {
        Long orgId = applyOrgEntry.getDynamicObject("org").getLong("id");
        if (null != autoScheRule.getDynamicObject("scheduleperiod") && this.isOnTimeSche(orgId)) {
            autoScheRuleMap.put(orgId, autoScheRule.getDynamicObject("scheduleperiod").getPkValue());
        }
    }
}

