/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.task;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class WaitStatusFixTask
extends AbstractTask {
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        DynamicObjectCollection idResult;
        Set payScheIdSet;
        Object minuteParam = params.get("key_minute");
        int minute = 10;
        if (minuteParam != null) {
            try {
                minute = Integer.parseInt(minuteParam.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (minute <= 0) {
                minute = 10;
            }
        }
        if ((payScheIdSet = (idResult = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])this.getFilters(minute))).stream().map(o -> o.getLong("id")).collect(Collectors.toSet())).size() > 0) {
            TmcOperateServiceHelper.execOperate((String)"respstatusfix", (String)"psd_schedulebill", (Object[])payScheIdSet.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private QFilter[] getFilters(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -1 * minute);
        Date time = calendar.getTime();
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter scheStatusFilter = new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.PAYING.getValue());
        QFilter waitStatusFilter = new QFilter("payrespstatus", "=", (Object)PayScheRespEnum.WAIT_RESP.getValue());
        QFilter timeFilter = new QFilter("paytime", "<=", (Object)time);
        return new QFilter[]{statusFilter, scheStatusFilter, waitStatusFilter, timeFilter};
    }
}

