/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.upgrade.basedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SumScheRuleLanguageUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(SumScheRuleLanguageUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            SumScheRuleLanguageUpgradeService.updateSumScheRuleEntryLanguage();
        }
        catch (Exception e) {
            LOGGER.error("[SumScheRuleLanguageUpgradeService]upgrade error\u3002", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private static void updateSumScheRuleEntryLanguage() {
        DataSet minMaxSet = DB.queryDataSet((String)"SumScheRuleLanguageUpgradeService_queryMinAndMaxId", (DBRoute)DBRouteConst.TMC, (String)"SELECT MIN(fentryid) as minid,MAX(fentryid) as maxid FROM t_psd_sumscherule_entry");
        if (minMaxSet.hasNext()) {
            Row minMaxRow = minMaxSet.next();
            Long minid = minMaxRow.getLong("minid");
            Long maxid = minMaxRow.getLong("maxid");
            LOGGER.info("[SumScheRuleLanguageUpgradeService]minId\uff1a{},maxId\uff1a{}", (Object)minid, (Object)maxid);
            if (EmptyUtil.isEmpty((Long)minid) || EmptyUtil.isEmpty((Long)maxid)) {
                return;
            }
            long size = (maxid - minid) / 2000L;
            size = size == 0L ? 1L : size;
            long start = minid;
            int batchNo = 1;
            String querySql = "SELECT fentryid,fitemname FROM t_psd_sumscherule_entry where fentryid >= ? and fentryid < ?";
            while (start <= maxid) {
                DataSet sumScheRulesDataSet;
                Throwable throwable;
                TXHandle tx;
                long end;
                block24: {
                    block25: {
                        end = start + size;
                        if (end > maxid) {
                            end = maxid;
                        }
                        tx = TX.requiresNew();
                        throwable = null;
                        Object[] param = new Object[]{start, end};
                        sumScheRulesDataSet = DB.queryDataSet((String)"SumScheRuleLanguageUpgradeService_queryEntryData", (DBRoute)DBRouteConst.TMC, (String)querySql, (Object[])param);
                        if (!EmptyUtil.isEmpty((Object)sumScheRulesDataSet) && sumScheRulesDataSet.hasNext()) break block24;
                        start = end + 1L;
                        if (tx == null) continue;
                        if (throwable == null) break block25;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    tx.close();
                    continue;
                }
                try {
                    try {
                        HashMap<Long, String> entryIdMapItemNameMap = new HashMap<Long, String>(256);
                        sumScheRulesDataSet.forEach(row -> entryIdMapItemNameMap.put(row.getLong("fentryid"), row.getString("fitemname")));
                        String cnLang = GLDataServiceHelper.getDefaultLocaleId();
                        StringJoiner askStringJoiner = new StringJoiner(",");
                        IntStream.rangeClosed(1, entryIdMapItemNameMap.size()).forEach(cnt -> askStringJoiner.add("?"));
                        String entryQuerySql = "select fentryid,fitemname from t_psd_sumscherule_entry_l where fentryid in (" + askStringJoiner + ") and flocaleid = ?";
                        Object[] params = entryIdMapItemNameMap.keySet().toArray(new Object[entryIdMapItemNameMap.size() + 1]);
                        params[entryIdMapItemNameMap.size()] = cnLang;
                        DataSet sumScheRuleLangDataSet = DB.queryDataSet((String)"SumScheRuleLanguageUpgradeService_queryLangData", (DBRoute)DBRouteConst.TMC, (String)entryQuerySql, (Object[])params);
                        HashSet<Long> sumScheRuleEntryLangIds = new HashSet<Long>(256);
                        if (sumScheRuleLangDataSet != null) {
                            for (Row r : sumScheRuleLangDataSet) {
                                Long entryId = r.getLong("fentryid");
                                if (!EmptyUtil.isNoEmpty((Long)entryId)) continue;
                                sumScheRuleEntryLangIds.add(entryId);
                            }
                        }
                        ArrayList entryParamsList = new ArrayList(256);
                        entryIdMapItemNameMap.forEach((k, v) -> {
                            if (EmptyUtil.isNoEmpty((Long)k) && EmptyUtil.isNoEmpty((String)v) && !sumScheRuleEntryLangIds.contains(k)) {
                                entryParamsList.add(new Object[]{Uuid16.create().toString(), k, cnLang, v});
                            }
                        });
                        if (EmptyUtil.isNoEmpty(entryParamsList)) {
                            String entrySql = "insert into t_psd_sumscherule_entry_l(fpkid,fentryid,flocaleid,fitemname) values(?,?,?,?)";
                            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)entrySql, entryParamsList);
                        }
                        tx.commit();
                        LOGGER.info("[SumScheRuleLanguageUpgradeService]update {} batch,size:{}", (Object)batchNo, (Object)entryParamsList.size());
                        ++batchNo;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        LOGGER.error("[SumScheRuleLanguageUpgradeService]upgrade error\u3002", (Throwable)e);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                start = end + 1L;
            }
        }
    }
}

