/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.autoschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.helper.PayScheHelper;

public class AutoScheduleRuleStartValidator
extends AbstractTmcBizOppValidator {
    private static final String ENABLE = "1";

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("id");
        lst.add("enabledate");
        lst.add("expireddate");
        lst.add("orgentryentity");
        lst.add("org");
        lst.add("name");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashSet orgIds = new HashSet(16);
        HashSet autoRuleIds = new HashSet(16);
        Arrays.stream(this.dataEntities).forEach(dataEntity -> {
            DynamicObject d = dataEntity.getDataEntity();
            DynamicObjectCollection applyOrgs = d.getDynamicObjectCollection("orgentryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)applyOrgs)) {
                orgIds.addAll(applyOrgs.stream().filter(Objects::nonNull).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toSet()));
            }
            autoRuleIds.add(d.getLong("id"));
        });
        Object[] autoRuleList = BusinessDataServiceHelper.load((String)"psd_autoschedule_rule", (String)"enable,number,name,orgentryentity.org,enabledate,expireddate", (QFilter[])new QFilter[]{new QFilter("id", "not in", autoRuleIds), new QFilter("orgentryentity.org.id", "in", orgIds), new QFilter("enable", "=", (Object)ENABLE)});
        block0: for (ExtendedDataEntity dataEntity2 : this.dataEntities) {
            DynamicObject info = dataEntity2.getDataEntity();
            String status = info.getString("enable");
            if (ENABLE.equals(status)) continue;
            Date expiredDate = info.getDate("expireddate");
            if (expiredDate != null && expiredDate.before(DateUtils.getCurrentDate())) {
                String msg = ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4,\u65e0\u6cd5\u542f\u7528\u3002", (String)"AutoScheduleRuleSaveValidator_9", (String)"tmc-psd-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity2, msg);
                continue;
            }
            DynamicObjectCollection applyOrgs = info.getDynamicObjectCollection("orgentryentity");
            Set applyOrgIds = applyOrgs.stream().filter(Objects::nonNull).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            if (applyOrgIds.isEmpty()) {
                DynamicObjectCollection autoruleList = QueryServiceHelper.query((String)"psd_autoschedule_rule", (String)"enable,number,name,orgentryentity,enabledate,expireddate", (QFilter[])new QFilter[]{QFilter.isNull((String)"orgentryentity.org.id"), new QFilter("enable", "=", (Object)ENABLE), PayScheHelper.buildAutoRuleEffDateFilter()});
                for (DynamicObject autorule : autoruleList) {
                    if (!PayScheHelper.effDateIsCoincident((DynamicObject)info, (DynamicObject)autorule)) continue;
                    String errorMessage = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u9002\u7528\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u89c4\u5219(%s)\uff0c\u6709\u6548\u65f6\u95f4\u5b58\u5728\u91cd\u53e0\u3002", (String)"AutoScheduleRuleSaveValidator_7", (String)"tmc-psd-business", (Object[])new Object[0]), autorule.getString("number"));
                    this.addErrorMessage(dataEntity2, errorMessage);
                    continue block0;
                }
                continue;
            }
            if (!EmptyUtil.isNoEmpty((Object[])autoRuleList)) continue;
            for (Object oldRule : autoRuleList) {
                String sameOrgName = PayScheHelper.hadSameOrg((DynamicObject)info, (DynamicObject)oldRule);
                if (sameOrgName == null || !PayScheHelper.effDateIsCoincident((DynamicObject)info, (DynamicObject)oldRule)) continue;
                this.addErrorMessage(dataEntity2, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u542f\u7528\u72b6\u6001\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u201c%2$s\u201d\u4e0e\u201c%3$s\u201d\u5b58\u5728\u542f\u7528\u671f\u95f4\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u542f\u7528\u65e5\u671f\u8303\u56f4\u3002", (String)"PSD-E-842811", (String)"tmc-psd-business", (Object[])new Object[0]), sameOrgName, oldRule.getString("name"), info.getString("name")));
                continue block0;
            }
        }
    }
}

