/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillCancelTransNextValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("nextscheduleid");
        selector.add("schedealid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<DynamicObject> payScheBills = Stream.of(dataEntity).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map<Long, String> scheStatusMap = AutoScheHelper.getNextBillStatusMap(payScheBills);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject payScheBill = data.getDataEntity();
            String sonBillStatus = scheStatusMap.get(payScheBill.getLong("nextscheduleid"));
            if (sonBillStatus != null && !ScheStatusEnum.NOSCHEDULE.getValue().equals(sonBillStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f6c\u4e0b\u671f\u751f\u6210\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u72b6\u6001\u4e3a\u672a\u6392\u7a0b\u65f6\uff0c\u624d\u5141\u8bb8\u64a4\u9500\u8f6c\u4e0b\u671f\u3002", (String)"PayScheBillCancelTransNextValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Long)payScheBill.getLong("schedealid"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u88ab\u6392\u7a0b\u5904\u7406\u5355\u9501\u5b9a\uff0c\u53ea\u80fd\u5230\u6392\u7a0b\u5904\u7406\u5355\u4e2d\u6267\u884c\u64a4\u9500\u8f6c\u4e0b\u671f\u3002", (String)"PayScheBillCancelTransNextValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }
}

