/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleHelper;
import kd.tmc.psd.common.helper.PayScheHelper;

public class PayScheBillFullAmountValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(PayScheBillFullAmountValidator.class);

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("entryentity");
        list.add("entryentity.e_sourcebilltype");
        list.add("entryentity.e_balanceamt");
        list.add("entryentity.e_amount");
        list.add("entryentity.e_draftamt");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        String cacheDateStr = this.getOption().getVariableValue("key_payschemodel", "");
        if (EmptyUtil.isNoEmpty((String)cacheDateStr)) {
            List<PayScheCalcModel> scheDataList = PayScheCalcModel.deserializeList(cacheDateStr);
            this.fullAmountValidate(scheDataList);
        }
        HashSet<String> sourceBillNos = new HashSet<String>(16);
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject dynamic = data.getDataEntity();
            DynamicObjectCollection entryEntities = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntities) {
                String sourceBillType = dynamicObject.getString("e_sourcebilltype");
                if (!"cas_payapplybill".equals(sourceBillType)) continue;
                String sourceBillNo = dynamicObject.getString("e_sourcebillnumber");
                sourceBillNos.add(sourceBillNo);
            }
        }
        Map isPartPaymentMap = new HashMap(16);
        if (sourceBillNos.size() > 0) {
            isPartPaymentMap = PayScheHelper.isPartPaymentBySourceBillNo(sourceBillNos);
        }
        if (isPartPaymentMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject dynamic = data.getDataEntity();
            DynamicObjectCollection entryEntities = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntities) {
                String sourceBillNo;
                String sourceBillType = dynamicObject.getString("e_sourcebilltype");
                if (!"cas_payapplybill".equals(sourceBillType) || !isPartPaymentMap.containsKey(sourceBillNo = dynamicObject.getString("e_sourcebillnumber")) || ((Boolean)isPartPaymentMap.get(sourceBillNo)).booleanValue()) continue;
                BigDecimal balanceAmount = dynamicObject.getBigDecimal("e_balanceamt");
                BigDecimal amount = dynamicObject.getBigDecimal("e_amount");
                BigDecimal draftAmount = dynamicObject.getBigDecimal("e_draftamt");
                Boolean isSchePartPayment = PayScheHelper.isSchePartPayment((BigDecimal)balanceAmount, (BigDecimal)draftAmount, (BigDecimal)amount);
                if (!isSchePartPayment.booleanValue()) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d44\u91d1\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u62c6\u5206\uff0c\u4e0d\u53ef\u540c\u65f6\u6392\u6b3e\u6392\u7968\uff0c\u4e5f\u4e0d\u53ef\u90e8\u5206\u6392\u6b3e\u6216\u90e8\u5206\u6392\u7968\u3002", (String)"PayScheBillFullAmountValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
        }
    }

    private void fullAmountValidate(List<PayScheCalcModel> scheDataList) {
        List<PayScheCalcModel> mergeDataList = scheDataList.parallelStream().filter(o -> Objects.nonNull(o) && o.isArchiveMerger() && o.isBillDibs() == false).collect(Collectors.toList());
        Map<String, BigDecimal> batchScheAmount = PayScheduleHelper.getBatchApplyAmount(scheDataList);
        if (EmptyUtil.isNoEmpty(mergeDataList)) {
            Map scaleMap = TmcAmountHelper.getScaleMap(mergeDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
            HashSet batchnumSet = new HashSet();
            mergeDataList.forEach(data -> {
                BigDecimal totalAmt;
                String batchNum = data.getBatchnum();
                BigDecimal dealApplyAmt = (BigDecimal)batchScheAmount.get(batchNum);
                BigDecimal applyAmt = data.getApplyAmt().multiply(data.getExchangerate()).setScale((int)((Integer)scaleMap.get(data.getCurrencyId())), 4);
                if (dealApplyAmt != null) {
                    applyAmt = dealApplyAmt;
                }
                if (applyAmt.compareTo(totalAmt = data.getScheAmt().add(data.getDraftBillAmt()).setScale((int)((Integer)scaleMap.get(data.getCurrencyId())), 4)) != 0) {
                    batchnumSet.add(data.getBatchnum());
                }
            });
            if (EmptyUtil.isNoEmpty(batchnumSet)) {
                String numStr = batchnumSet.stream().collect(Collectors.joining(","));
                logger.info("--- PayScheBillFullAmountValidator,fullAmountValidate: error numStr=", (Object)numStr);
                String errormsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5408\u5e76\u6279\u6b21\u53f7[%s]\u672a\u5168\u989d\u6392\u7a0b\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"PayScheBillFullAmountValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), numStr);
                throw new KDBizException(errormsg);
            }
        }
    }
}

