/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.BillTypeEnum;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("billstatus");
        selector.add("schedulstatus");
        selector.add("applyamt");
        selector.add("scheduletotalamt");
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntity.length);
        for (ExtendedDataEntity data : dataEntity) {
            String freezeStatus;
            DynamicObject payScheBill = data.getDataEntity();
            billNos.add(payScheBill.getString("billno"));
            String billStatus = payScheBill.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4ed8\u6b3e\u3002", (String)"PayScheBillPayValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            String scheStatus = payScheBill.getString("schedulstatus");
            BigDecimal applyAmt = payScheBill.getBigDecimal("applyamt");
            BigDecimal scheTotalAmt = payScheBill.getBigDecimal("scheduletotalamt");
            if (!(ScheStatusEnum.YETSCHEDULE.getValue().equals(scheStatus) || scheTotalAmt.compareTo(applyAmt) > 0 && ScheStatusEnum.PAYING.getValue().equals(scheStatus))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u6392\u7a0b\u4e14\u672a\u5b8c\u6210\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u624d\u80fd\u4ed8\u6b3e\u3002", (String)"PayScheBillPayValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (null != (freezeStatus = payScheBill.getString("freezestatus")) && !freezeStatus.trim().equals("") && !FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s \u672a\u51bb\u7ed3\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u624d\u5141\u8bb8\u4ed8\u6b3e\u3002", (String)"PayScheBillPayValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]), payScheBill.getString("billno")));
            }
            DynamicObjectCollection entryList = payScheBill.getDynamicObjectCollection("entrys");
            boolean nonWaitSchePayBill = entryList.stream().noneMatch(o -> BillTypeEnum.SCHEBILL.getValue().equals(o.getString("e_billtype")));
            if (entryList.size() != 0 && !nonWaitSchePayBill) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u5206\u5f55\u4e2d\uff0c\u65e0\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u4fe1\u606f\uff0c\u65e0\u6cd5\u4ed8\u6b3e\u3002", (String)"PayScheBillPayValidator_4", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"PayScheBillPayValidator_5", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

