/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;

public class PayScheBillTransNextValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(2);
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntity.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject selectRowObj = extendedDataEntity.getDataEntity();
            billNos.add(selectRowObj.getString("billno"));
            String freezeStatus = selectRowObj.getString("freezestatus");
            if (null == freezeStatus || freezeStatus.trim().equals("") || FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u9700\u4e3a\u672a\u51bb\u7ed3\u72b6\u6001\uff0c\u65b9\u53ef\u8f6c\u81f3\u4e0b\u4e00\u671f\u3002", (String)"PayScheBillTransNextValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u8f6c\u4e0b\u671f", (String)"PayScheBillTransNextValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

