/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheChargeBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("expectpaydate");
        selector.add("billno");
        selector.add("sourcebilltype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String isSkipvalidate = this.getOption().getVariables().getOrDefault("key_isskipvalidate", "");
        if (EmptyUtil.isNoEmpty((String)isSkipvalidate)) {
            return;
        }
        HashSet<String> collScheTypes = new HashSet<String>(2);
        ArrayList<String> billNos = new ArrayList<String>(dataEntity.length);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject payScheBill = data.getDataEntity();
            billNos.add(payScheBill.getString("billno"));
            Long pkValue = payScheBill.getDynamicObject("company").getLong("id");
            String chargeBackSet = PsdParameterHelper.getAppStringParameter((long)pkValue, (String)"chargebackset");
            if (EmptyUtil.isEmpty((String)chargeBackSet)) {
                chargeBackSet = "chargeback";
            }
            collScheTypes.add(chargeBackSet);
            if (collScheTypes.size() > 1) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6392\u7a0b\u5355\u7684\u201c\u6392\u7a0b\u5355\u9000\u5355\u8bbe\u7f6e\u201d\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u9000\u5355\u548c\u5220\u9664\u4e24\u79cd\u914d\u7f6e\u3002", (String)"PayScheChargeBackValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            String schedulStatus = payScheBill.getString("schedulstatus");
            if (ScheStatusEnum.NOSCHEDULE.getValue().equals(schedulStatus) || ScheStatusEnum.YETSCHEDULE.getValue().equals(schedulStatus)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6392\u7a0b\u548c\u5df2\u6392\u7a0b\u72b6\u6001\u4e0b\uff0c\u624d\u80fd\u9000\u5355\u3002", (String)"PayScheChargeBackValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u9000\u5355", (String)"PayScheChargeBackValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

