/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;

public class ScheduleBillThawValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selectors = new ArrayList<String>(2);
        selectors.add("freezestatus");
        selectors.add("billno");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject scheduleBill = dataEntity.getDataEntity();
            billNos.add(scheduleBill.getString("billno"));
            String freezeStatus = scheduleBill.getString("freezestatus");
            if (null == freezeStatus || freezeStatus.trim().equals("") || FreezeStatusEnum.ManualFrozen.getValue().equals(freezeStatus)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u624b\u5de5\u51bb\u7ed3\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u89e3\u51bb\u3002", (String)"ScheduleBillThawValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u89e3\u51bb", (String)"ScheduleBillThawValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

