/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payscheprocessor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.PayScheHelper;

public class PayScheProcAutoSubmitValidator
extends AbstractTmcBizOppValidator {
    private Map<Object, DynamicObject> draftBillMap = new HashMap<Object, DynamicObject>(16);
    private static final String DRAFT_TYPE_ARRIVAL = "7";

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(10);
        list.add("id");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Object[] accBanks;
        Map idAndDyMap = Stream.of(this.dataEntities).collect(Collectors.toMap(data -> data.getDataEntity().getPkValue(), Function.identity()));
        Set<Object> ids = idAndDyMap.keySet();
        DynamicObject[] payScheduleBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedealid", "in", ids)});
        List payScheduleBillIds = Arrays.stream(payScheduleBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        payScheduleBills = TmcDataServiceHelper.load((Object[])payScheduleBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        Map<Long, List<DynamicObject>> scheDealIdAndScheduleListMap = Arrays.stream(payScheduleBills).collect(Collectors.groupingBy(s -> s.getLong("schedealid")));
        HashMap accBankMap = new HashMap(16);
        HashMap settleTypeMap = new HashMap(16);
        HashMap draftPayAccMap = new HashMap(16);
        HashMap draftSettleTypeMap = new HashMap(16);
        Set accBankIdSet = Arrays.stream(payScheduleBills).filter(s -> EmptyUtil.isNoEmpty((DynamicObject)s.getDynamicObject("acctbank"))).map(s -> s.getDynamicObject("acctbank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(accBankIdSet) && EmptyUtil.isNoEmpty((Object[])(accBanks = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,settlementtype,strategy", (QFilter[])new QFilter[]{new QFilter("id", "in", accBankIdSet)})))) {
            Arrays.stream(accBanks).forEach(accBank -> accBankMap.put(accBank.getLong("id"), accBank));
        }
        Arrays.stream(payScheduleBills).forEach(s -> {
            Optional.ofNullable(s.getDynamicObject("settletype")).ifPresent(settleType -> settleTypeMap.put(settleType.getLong("id"), settleType));
            Optional.ofNullable(s.getDynamicObject("draftpayacct")).ifPresent(acc -> draftPayAccMap.put(acc.getLong("id"), acc));
            Optional.ofNullable(s.getDynamicObject("draftsettletype")).ifPresent(settleType -> draftSettleTypeMap.put(settleType.getLong("id"), settleType));
        });
        HashSet<String> sourceBillNos = new HashSet<String>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : scheDealIdAndScheduleListMap.entrySet()) {
            List draftBillIds;
            long scheDealId = entry.getKey();
            List<DynamicObject> scheduleList = entry.getValue();
            ExtendedDataEntity data2 = (ExtendedDataEntity)idAndDyMap.get(scheDealId);
            if (EmptyUtil.isEmpty((Object)data2)) continue;
            List<PayScheCalcModel> scheDataList = new PayScheDataTransfer().transScheDataToCalcModelList(scheduleList);
            List mergeModelList = scheDataList.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isArchiveMerger).collect(Collectors.toList());
            Set batchNumbers = mergeModelList.stream().map(PayScheCalcModel::getBatchnum).collect(Collectors.toSet());
            ArrayList<PayScheCalcModel> toValidate = new ArrayList<PayScheCalcModel>();
            for (PayScheCalcModel psc : scheDataList) {
                String batchNum = psc.getBatchnum();
                if (batchNumbers.contains(batchNum)) continue;
                toValidate.add(psc);
            }
            toValidate.addAll(mergeModelList);
            List<PayScheCalcModel> notMergeModelList = scheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (PayScheCalcModel payScheCalcModel : notMergeModelList) {
                totalAmt = totalAmt.add(payScheCalcModel.getScheAmt().abs()).add(payScheCalcModel.getDraftBillAmt().abs());
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(data2, ResManager.loadKDString((String)"\u6392\u7a0b\u603b\u989d\u4e3a0\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"PayScheProcSubmitValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if ((draftBillIds = scheDataList.stream().map(PayScheCalcModel::getDraftBillIds).filter(EmptyUtil::isNoEmpty).flatMap(Collection::stream).collect(Collectors.toList())).size() > 0) {
                DynamicObject[] draftBills = TmcDataServiceHelper.load((Object[])draftBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                this.draftBillMap = Stream.of(draftBills).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            }
            this.validateSubmit(data2, notMergeModelList);
            this.checkBids(data2, toValidate);
            this.checkEntrustScheduleBill(notMergeModelList);
            for (PayScheCalcModel payScheCalcModel : scheDataList) {
                String sourceBillType;
                Date expectDate;
                BigDecimal draftAmount;
                DynamicObject settleType;
                long settleTypeId;
                long accBankId;
                DynamicObject acctBank;
                String acctBankType;
                String billNo = payScheCalcModel.getScheNumber();
                BigDecimal amount = payScheCalcModel.getScheAmt();
                if (amount.compareTo(BigDecimal.ZERO) > 0 && "bd_accountbanks".equals(acctBankType = payScheCalcModel.getAcctBankType()) && EmptyUtil.isNoEmpty((DynamicObject)(acctBank = (DynamicObject)accBankMap.get(accBankId = EmptyUtil.isNoEmpty((Long)payScheCalcModel.getAcctBankId()) ? payScheCalcModel.getAcctBankId() : 0L)))) {
                    BigDecimal singlelimit;
                    settleTypeId = EmptyUtil.isNoEmpty((Long)payScheCalcModel.getSettleTypeId()) ? payScheCalcModel.getSettleTypeId() : 0L;
                    settleType = (DynamicObject)settleTypeMap.get(settleTypeId);
                    this.checkSettleType(acctBank, settleType, data2, billNo, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_33", (String)"tmc-psd-business", (Object[])new Object[0]));
                    DynamicObject strategy = acctBank.getDynamicObject("strategy");
                    if (EmptyUtil.isNoEmpty((DynamicObject)strategy) && EmptyUtil.isNoEmpty((BigDecimal)(singlelimit = strategy.getBigDecimal("singlelimit"))) && amount.compareTo(singlelimit) > 0) {
                        this.addErrorMessage(data2, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u6392\u6b3e\u91d1\u989d\u8d85\u51fa\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u5355\u7b14\u652f\u4ed8\u9650\u989d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_34", (String)"tmc-psd-business", (Object[])new Object[0]), billNo));
                    }
                }
                if ((draftAmount = payScheCalcModel.getDraftBillAmt()).compareTo(BigDecimal.ZERO) > 0 && EmptyUtil.isNoEmpty((DynamicObject)(acctBank = (DynamicObject)draftPayAccMap.get(accBankId = EmptyUtil.isNoEmpty((Long)payScheCalcModel.getDraftAcctBankId()) ? payScheCalcModel.getDraftAcctBankId() : 0L)))) {
                    settleTypeId = EmptyUtil.isNoEmpty((Long)payScheCalcModel.getDraftSettleTypeId()) ? payScheCalcModel.getDraftSettleTypeId() : 0L;
                    settleType = (DynamicObject)draftSettleTypeMap.get(settleTypeId);
                    this.checkSettleType(acctBank, settleType, data2, billNo, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_35", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
                if ((amount.compareTo(BigDecimal.ZERO) != 0 || draftAmount.compareTo(BigDecimal.ZERO) != 0) && DateUtils.getDataFormat((Date)(expectDate = payScheCalcModel.getExpectDate()), (boolean)true).before(DateUtils.getCurrentDate())) {
                    this.addErrorMessage(data2, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayScheProcSubmitValidator_18", (String)"tmc-psd-business", (Object[])new Object[0]), billNo));
                }
                if (!"cas_payapplybill".equals(sourceBillType = payScheCalcModel.getSourceBillType())) continue;
                String sourceBillNo = payScheCalcModel.getSourceBillNo();
                sourceBillNos.add(sourceBillNo);
            }
            Map isPartPaymentMap = new HashMap(16);
            if (sourceBillNos.size() > 0) {
                isPartPaymentMap = PayScheHelper.isPartPaymentBySourceBillNo(sourceBillNos);
            }
            if (isPartPaymentMap.size() > 0) {
                for (PayScheCalcModel payScheCalcModel : scheDataList) {
                    String sourceBillNo;
                    String sourceBillType = payScheCalcModel.getSourceBillType();
                    if (!"cas_payapplybill".equals(sourceBillType) || !isPartPaymentMap.containsKey(sourceBillNo = payScheCalcModel.getSourceBillNo()) || ((Boolean)isPartPaymentMap.get(sourceBillNo)).booleanValue()) continue;
                    BigDecimal balanceAmount = payScheCalcModel.getScheBalance();
                    BigDecimal amount = payScheCalcModel.getScheAmt();
                    BigDecimal draftAmount = payScheCalcModel.getDraftBillAmt();
                    boolean isSchePartPayment = PayScheHelper.isSchePartPayment((BigDecimal)balanceAmount, (BigDecimal)draftAmount, (BigDecimal)amount);
                    if (!isSchePartPayment) continue;
                    this.addErrorMessage(data2, ResManager.loadKDString((String)"\u8d44\u91d1\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u62c6\u5206\uff0c\u4e0d\u53ef\u540c\u65f6\u6392\u6b3e\u6392\u7968\uff0c\u4e5f\u4e0d\u53ef\u90e8\u5206\u6392\u6b3e\u6216\u90e8\u5206\u6392\u7968\u3002", (String)"PayScheProcSubmitValidator_27", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
            }
            this.draftInfoValidate(scheDataList, data2);
        }
    }

    private void checkSettleType(DynamicObject acctBank, DynamicObject settleType, ExtendedDataEntity data, String billNo, String errorMsg) {
        Set settlementTypeIds;
        DynamicObjectCollection settlementType = acctBank.getDynamicObjectCollection("settlementtype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)settlementType) && !(settlementTypeIds = settlementType.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())).contains(settleType.getLong("id"))) {
            this.addErrorMessage(data, String.format(errorMsg, billNo));
        }
    }

    private String checkEntrustScheduleBill(List<PayScheCalcModel> notMergeModelList) {
        StringBuilder errMsg = new StringBuilder();
        notMergeModelList.forEach(model -> {
            if (EmptyUtil.isNoEmpty((Long)model.getEntrustPayId())) {
                BigDecimal balanceAmount = model.getScheBalance();
                BigDecimal amount = model.getScheAmt();
                BigDecimal draftAmount = model.getDraftBillAmt();
                if (PayScheHelper.isSchePartPayment((BigDecimal)balanceAmount, (BigDecimal)draftAmount, (BigDecimal)amount)) {
                    if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                        errMsg.append("\r\n");
                    }
                    errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c{0}\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u6392\u6b3e\u3001\u90e8\u5206\u6392\u7968\u3001\u540c\u65f6\u6392\u6b3e\u6392\u7968\u3001\u6279\u91cf\u6392\u6b3e\u3001\u6279\u91cf\u6392\u7968\u3001\u81ea\u52a8\u6392\u7a0b\u3001\u6c47\u603b\u6392\u7a0b\u3002", (String)"PayScheProcSubmitValidator_39", (String)"tmc-psd-business", (Object[])new Object[]{model.getScheNumber()}));
                }
            }
        });
        return errMsg.toString();
    }

    private void validateSubmit(ExtendedDataEntity entity, List<PayScheCalcModel> payScheDataList) {
        PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(payScheDataList);
        HashSet lookUpIds = new HashSet();
        payScheDataList.stream().filter(Objects::nonNull).forEach(o -> {
            Long settleTypeId = o.getSettleTypeId();
            if (EmptyUtil.isNoEmpty((Long)settleTypeId)) {
                lookUpIds.add(settleTypeId);
            }
        });
        payScheDataList.stream().filter(Objects::nonNull).forEach(o -> {
            Long draftSettleTypeId = o.getDraftSettleTypeId();
            if (EmptyUtil.isNoEmpty((Long)draftSettleTypeId)) {
                lookUpIds.add(draftSettleTypeId);
            }
        });
        DynamicObjectCollection settleTypeArr = QueryServiceHelper.query((String)"bd_settlementtype", (String)"id,paymentchannel,settlementtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)lookUpIds.toArray())});
        Map<Object, DynamicObject> settleTypeMap = settleTypeArr.stream().filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (PayScheCalcModel payScheCalcModel : payScheDataList) {
            Set currencyIdSet;
            Object payChannel;
            Date expectDate;
            String mark;
            String billno = payScheCalcModel.getScheNumber();
            BigDecimal scheAmt = payScheCalcModel.getScheAmt();
            BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
            String scheStatus = payScheCalcModel.getScheStatus();
            String string = mark = EmptyUtil.isEmpty((String)billno) ? payScheCalcModel.getBatchnum() : billno;
            if (EmptyUtil.isEmpty((String)scheStatus) || !scheStatus.equals(ScheStatusEnum.SCHEDULING.getValue())) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(draftBillAmt) < 0 && (EmptyUtil.isEmpty((Long)payScheCalcModel.getCurrencyId()) || EmptyUtil.isEmpty((Long)payScheCalcModel.getApplyCurrencyId()) || payScheCalcModel.getCurrencyId().compareTo(payScheCalcModel.getApplyCurrencyId()) != 0)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u4e0d\u652f\u6301\u6392\u7968", (String)"PayScheProcSubmitValidator_32", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if ((scheAmt.compareTo(BigDecimal.ZERO) != 0 || draftBillAmt.compareTo(BigDecimal.ZERO) != 0) && EmptyUtil.isEmpty((Object)(expectDate = payScheCalcModel.getExpectDate()))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_7", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (scheAmt.compareTo(BigDecimal.ZERO) != 0) {
                Long settleTypeId = payScheCalcModel.getSettleTypeId();
                if (null == settleTypeId || 0L == settleTypeId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                Long acctBankId = payScheCalcModel.getAcctBankId();
                DynamicObject settleTypeDO = settleTypeMap.get(settleTypeId);
                Long orgId = payScheCalcModel.getOrgId();
                boolean isCheckOurAcc = PayScheHelper.isCheckOurAccBySysParam((Long)orgId, (DynamicObject)settleTypeDO);
                if ((null == acctBankId || 0L == acctBankId) && isCheckOurAcc) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isEmpty((CharSequence)(payChannel = payScheCalcModel.getPayChannel()))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (settleTypeDO == null) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_31", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                } else {
                    String paymentchannel = settleTypeDO.getString("paymentchannel");
                    if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains((CharSequence)payChannel)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_28", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                    }
                }
            }
            if (draftBillAmt.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject settleTypeDO;
                boolean isDraftBePayChannelType;
                Set currencyIdSet2;
                Long draftSettleTypeId = payScheCalcModel.getDraftSettleTypeId();
                String draftPayChannel = payScheCalcModel.getDraftpaychannel();
                if (null == draftSettleTypeId || 0L == draftSettleTypeId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_4", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isEmpty((CharSequence)draftPayChannel)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_5", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                String draftPayMethod = payScheCalcModel.getDraftPayMethod();
                if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod)) {
                    List<Long> draftBillIds = payScheCalcModel.getDraftBillIds();
                    if (EmptyUtil.isEmpty(draftBillIds) || draftBillIds.size() < 1) {
                        String freezeStatus = payScheCalcModel.getFreezeStatus();
                        if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u7968\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_6", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                        }
                    } else {
                        BigDecimal draftnoAmt = BigDecimal.ZERO;
                        payChannel = draftBillIds.iterator();
                        while (payChannel.hasNext()) {
                            Long draftBillId = (Long)payChannel.next();
                            DynamicObject draft = this.draftBillMap.get(draftBillId);
                            draftnoAmt = draftnoAmt.add(draft.getBigDecimal("amount"));
                        }
                    }
                }
                Long draftPayAcctId = payScheCalcModel.getDraftAcctBankId();
                DynamicObject draftBankAcct = null;
                if (EmptyUtil.isNoEmpty((Long)draftPayAcctId) && !(currencyIdSet2 = (draftBankAcct = dataProvider.getBaseData("bd_accountbanks", draftPayAcctId)).getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())).contains(payScheCalcModel.getCurrencyId())) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheProcSubmitValidator_24", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (isDraftBePayChannelType = PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getDraftpaychannel())) {
                    boolean hasBeOfDraftBankAcct = false;
                    if (draftBankAcct != null) {
                        hasBeOfDraftBankAcct = draftBankAcct.getBoolean("issetbankinterface");
                    }
                    if (!hasBeOfDraftBankAcct && draftBillAmt.compareTo(BigDecimal.ZERO) != 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7968\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde\uff0c\u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_25", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                }
                if ((settleTypeDO = settleTypeMap.get(draftSettleTypeId)) == null) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_30", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                } else {
                    String paymentchannel = settleTypeDO.getString("paymentchannel");
                    if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains(draftPayChannel)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_29", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                    }
                }
                this.validateArrival(entity, payScheCalcModel, mark);
            }
            String bankAcctType = payScheCalcModel.getAcctBankType();
            Long bankAcctId = payScheCalcModel.getAcctBankId();
            Long currencyId = payScheCalcModel.getCurrencyId();
            boolean isBankAcctType = "bd_accountbanks".equals(bankAcctType);
            boolean isBePayType = PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getPayChannel());
            DynamicObject bankAcct = null;
            if (isBankAcctType && bankAcctId != null && bankAcctId != 0L && !(currencyIdSet = (bankAcct = dataProvider.getBaseData("bd_accountbanks", bankAcctId)).getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())).contains(currencyId)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheProcSubmitValidator_14", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (!isBePayType) continue;
            boolean hasBe = false;
            if (isBankAcctType && bankAcct != null) {
                hasBe = bankAcct.getBoolean("issetbankinterface");
            }
            if (hasBe || scheAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde\uff0c\u8bf7\u66f4\u6362\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_15", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
        }
    }

    private void validateArrival(ExtendedDataEntity entity, PayScheCalcModel payScheCalcModel, String mark) {
        Long settlementId = payScheCalcModel.getDraftSettleTypeId();
        if (settlementId == null) {
            return;
        }
        DynamicObject settlementTypeObj = TmcDataServiceHelper.loadSingleFromCache((Object)settlementId, (String)"bd_settlementtype");
        String settlementType = Optional.ofNullable(settlementTypeObj).map(o -> o.getString("settlementtype")).orElseGet(() -> null);
        if (StringUtils.isEmpty((CharSequence)settlementType) || !DRAFT_TYPE_ARRIVAL.equals(settlementType)) {
            return;
        }
        String arrivalNo = payScheCalcModel.getLcArrivalNo();
        if (StringUtils.isEmpty((CharSequence)arrivalNo)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u7ed3\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_38", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
        }
    }

    private void checkBids(ExtendedDataEntity entity, List<PayScheCalcModel> toValidate) {
        for (PayScheCalcModel payScheCalcModel : toValidate) {
            List<Long> draftBillIds;
            String draftPayMethod = payScheCalcModel.getDraftPayMethod();
            if (!DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod) || EmptyUtil.isEmpty(draftBillIds = payScheCalcModel.getDraftBillIds()) || draftBillIds.size() < 1) continue;
            BigDecimal draftnoAmt = BigDecimal.ZERO;
            for (Long draftBillId : draftBillIds) {
                DynamicObject draft = this.draftBillMap.get(draftBillId);
                draftnoAmt = draftnoAmt.add(draft.getBigDecimal("amount"));
            }
            this.checkBids(entity, payScheCalcModel, draftnoAmt);
        }
    }

    private void checkBids(ExtendedDataEntity entity, PayScheCalcModel payScheCalcModel, BigDecimal draftnoAmt) {
        Boolean isBillBids = payScheCalcModel.isBillDibs();
        if (!isBillBids.booleanValue()) {
            return;
        }
        BigDecimal scheAmt = payScheCalcModel.getScheAmt();
        BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
        String billno = payScheCalcModel.getScheNumber();
        if (draftnoAmt.compareTo(draftBillAmt) < 0) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u627e\u96f6\u4e1a\u52a1\u4e0b\uff0c\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u7968\u636e\u7968\u9762\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u7968", (String)"PayScheProcSubmitValidator_20", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            return;
        }
        Long dibsBalance = payScheCalcModel.getDibsBalance();
        if (EmptyUtil.isEmpty((Long)dibsBalance)) {
            this.addBidsError(entity, billno);
            return;
        }
        DynamicObject payBillObj = BusinessDataServiceHelper.loadSingle((Object)dibsBalance, (String)"cas_recbill", (String)"id,actrecamt");
        if (EmptyUtil.isEmpty((DynamicObject)payBillObj)) {
            this.addBidsError(entity, billno);
            return;
        }
        BigDecimal receiveAmount = payBillObj.getBigDecimal("actrecamt");
        Boolean isFalse = scheAmt.compareTo(BigDecimal.ZERO) == 0 && draftBillAmt.compareTo(payScheCalcModel.getApplyAmt()) == 0 && draftBillAmt.add(receiveAmount).compareTo(draftnoAmt) == 0;
        if (!isFalse.booleanValue()) {
            this.addBidsError(entity, billno);
        }
    }

    private void addBidsError(ExtendedDataEntity entity, String billno) {
        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ed8\u6b3e\u6392\u7a0b\u5355%1$s\u8fdb\u884c\u7968\u636e\u627e\u96f6\u4e1a\u52a1, \u6240\u9009\u7968\u636e\u6216\u6536\u6b3e\u5355\u91d1\u989d\u6709\u8bef\uff0c\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"PayScheProcSubmitValidator_21", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
    }

    private void draftInfoValidate(List<PayScheCalcModel> scheDataList, ExtendedDataEntity data) {
        scheDataList = scheDataList.stream().filter(o -> EmptyUtil.isNoEmpty(o.getPayScheDraftInfos())).filter(o -> o.isArchiveMerger() || EmptyUtil.isEmpty((String)o.getBatchnum())).collect(Collectors.toList());
        for (PayScheCalcModel payScheCalcModel : scheDataList) {
            List<PayScheDraftInfo> payScheDraftInfos;
            List lessZeroTransferAmtModel;
            String mark = payScheCalcModel.isArchiveMerger() ? String.format("BatchNo=%s", payScheCalcModel.getBatchnum()) : payScheCalcModel.getScheNumber();
            Optional<PayScheDraftInfo> anyEmptyTransferAmtOp = payScheCalcModel.getPayScheDraftInfos().stream().filter(o -> EmptyUtil.isEmpty((BigDecimal)o.getTransferAmt())).findAny();
            if (anyEmptyTransferAmtOp.isPresent()) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s \u6392\u7a0b\u5355\u5bf9\u5e94\u7684\u7968\u9762\u4fe1\u606f\u5185\u7684\u7968\u636e\u8f6c\u8ba9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"PayScheSaveOfDraftInfoValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
            }
            if (payScheCalcModel.isBillDibs().booleanValue()) continue;
            BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
            if (EmptyUtil.isEmpty((BigDecimal)draftBillAmt)) {
                draftBillAmt = BigDecimal.ZERO;
            }
            if (!(lessZeroTransferAmtModel = (payScheDraftInfos = payScheCalcModel.getPayScheDraftInfos()).stream().filter(o -> BigDecimal.ZERO.compareTo(o.getTransferAmt()) > 0).collect(Collectors.toList())).isEmpty()) {
                String errMsg = lessZeroTransferAmtModel.stream().map(draftinfo -> String.format(ResManager.loadKDString((String)"%1$s \u6392\u7a0b\u5355\u5bf9\u5e94\u7968\u9762\u4fe1\u606f\u8f6c\u8ba9\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u5f53\u524d\u91d1\u989d\u4e3a %2$s\uff0c\u8bf7\u4fee\u6539", (String)"PayScheSaveOfDraftInfoValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]), mark, draftinfo.getTransferAmt())).collect(Collectors.joining("/r/n"));
                this.addErrorMessage(data, errMsg);
                continue;
            }
            BigDecimal draftTransferAmtSum = payScheCalcModel.getPayScheDraftInfos().stream().filter(Objects::nonNull).map(PayScheDraftInfo::getTransferAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (draftBillAmt.compareTo(draftTransferAmtSum) == 0) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s \u6392\u7a0b\u5355\u5bf9\u5e94\u7684\u7968\u9762\u4fe1\u606f\u5185\u7684\u7968\u636e\u8f6c\u8ba9\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6539", (String)"PayScheSaveOfDraftInfoValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
        }
    }
}

