/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payscheprocessor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;

public class PayScheProcSubmitExpectDateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        String cacheDateStr = this.getOption().getVariableValue("key_payschemodel", "");
        if (EmptyUtil.isNoEmpty((String)cacheDateStr)) {
            this.editFormValidate(cacheDateStr, extendedDataEntities);
        }
    }

    private void editFormValidate(String cacheDateStr, ExtendedDataEntity[] extendedDataEntities) {
        List<PayScheCalcModel> scheDataList = PayScheCalcModel.deserializeList(cacheDateStr);
        this.validateExpectDate(scheDataList, extendedDataEntities[0]);
    }

    private void validateExpectDate(List<PayScheCalcModel> scheDataList, ExtendedDataEntity entity) {
        for (PayScheCalcModel payScheCalcModel : scheDataList) {
            Date expectDate;
            String billno = payScheCalcModel.getScheNumber();
            BigDecimal scheAmt = payScheCalcModel.getScheAmt();
            BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
            if (scheAmt.compareTo(BigDecimal.ZERO) == 0 && draftBillAmt.compareTo(BigDecimal.ZERO) == 0 || !DateUtils.getDataFormat((Date)(expectDate = payScheCalcModel.getExpectDate()), (boolean)true).before(DateUtils.getCurrentDate())) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayScheProcSubmitValidator_18", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
        }
    }
}

