/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class ArapDataSetHelper {
    private static final Log logger = LogFactory.getLog(ArapDataSetHelper.class);
    private static final String SETTLE_FIELD = "billtype, paymentday, agingseq, agingname, entry.currency.id as currency, entry.amount as amount, entry.count as count, entry.custsupptype as custsupptype, org.id as orgid, org.name as orgname, org.simplename as simplename,entry.customer as customerid, entry.customername as customername, entry.supplier as supplierid, entry.suppliername as suppliername,case when billtype = 'ar_finarbill' then '" + ArapDataSetHelper.getARfinarBillStr() + "' when billtype = 'cas_recbill' then '" + ArapDataSetHelper.getCasrecBill() + "' when billtype = 'ap_finapbill' then '" + ArapDataSetHelper.getApFinapBillStr() + "' when billtype = 'cas_paybill' then '" + ArapDataSetHelper.getCasPayBillStr() + "' end as billname ";

    private static String getInsideStr() {
        return ResManager.loadKDString((String)"\u5185\u90e8", (String)"ArapDataSetHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getOutsideStr() {
        return ResManager.loadKDString((String)"\u5916\u90e8", (String)"ArapDataSetHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getAllsideStr() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"ArapDataSetHelper_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getARfinarBillStr() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u8d26\u6b3e", (String)"ArapDataSetHelper_4", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getCasrecBill() {
        return ResManager.loadKDString((String)"\u9884\u6536\u8d26\u6b3e", (String)"ArapDataSetHelper_5", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getApFinapBillStr() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u8d26\u6b3e", (String)"ArapDataSetHelper_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getCasPayBillStr() {
        return ResManager.loadKDString((String)"\u9884\u4ed8\u8d26\u6b3e", (String)"ArapDataSetHelper_7", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static DataSet queryArapSummaryData(String algoKey, Map<String, Object> paramMap, int period) {
        String cacheKey = ArapDataSetHelper.getCacheKey(paramMap);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            List<Long> orgIdSet = ArapDataSetHelper.getOrgIds(paramMap);
            DataSet filterDs = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> ArapDataSetHelper.doQueryArapSummaryData(algoKey, period, queryDate, orgViewId, allViewOrgs, baseCurrency)).filter("orgid in orgids", Collections.singletonMap("orgids", orgIdSet));
            return filterDs;
        }
        List<Long> allorgids = ArapDataSetHelper.getOrgIds(paramMap);
        return ArapDataSetHelper.doQueryArapSummaryData(algoKey, period, queryDate, orgViewId, allorgids, baseCurrency);
    }

    private static DataSet doQueryArapSummaryData(String algoKey, int period, Date queryDate, Long orgViewId, List<Long> allOrgIds, Long baseCurrency) {
        long start = System.currentTimeMillis();
        List<String> paymentdays = ArapDataSetHelper.getPaymentDays(queryDate, period);
        QFilter qFilter = new QFilter("paymentday", "in", paymentdays);
        qFilter.and("org.id", "in", allOrgIds);
        DataSet allDs = QueryServiceHelper.queryDataSet((String)("tda-decisanls-algo-" + ArapDataSetHelper.class + ".queryArapSummaryData"), (String)"tda_arap_sumbill", (String)SETTLE_FIELD, (QFilter[])qFilter.toArray(), null);
        allDs = AmountTransHelper.tranDataSetRate((DataSet)allDs, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        logger.info("\u5e94\u6536\u5e94\u4ed8\uff1a" + algoKey + "cost:" + (System.currentTimeMillis() - start));
        return allDs;
    }

    protected static List<Long> getOrgIds(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        return TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
    }

    public static List<String> getPaymentDays(Date queryDate, int period) {
        ArrayList<String> paymentDays = new ArrayList<String>(12);
        for (int i = period; i > 0; --i) {
            Date lastMonth = DateUtils.getLastMonth((Date)queryDate, (int)i);
            String yearMonth = DateUtils.formatString((Date)lastMonth, (String)"yyyy-MM");
            paymentDays.add(yearMonth);
        }
        return paymentDays;
    }

    public static DataSet updateCustsuppTypeAndPaymentDay(DataSet deal) {
        return deal.updateField("custsupptype", "case when custsupptype = 'inside' then '" + ArapDataSetHelper.getInsideStr() + "' when custsupptype = 'outside' then '" + ArapDataSetHelper.getOutsideStr() + "' when custsupptype = 'allside' then '" + ArapDataSetHelper.getAllsideStr() + "'  end ");
    }

    public static void setParameterFilter(List<String> ids, ReportShowParameter parameter) {
        String[] split = ids.get(0).split("_");
        String custSuppType = split[0];
        String paymentDay = split[1];
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("paymentDay", paymentDay);
        customParams.put("custsupptype", custSuppType);
        parameter.setCustomParams(customParams);
    }

    public static String getCacheKey(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        return "ArapDataSetHelper-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

