/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.qing.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IPageCache;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractArApTreeQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String[] ORG_SELECTFIELD = new String[]{"rowid", "mixorgname", "pid", "isgroupnode", "level", "orgid", "orgname", "simplename", "0  as sumlevel"};
    private static final String[] SUMMARY_SELECTFIELD = new String[]{"paymentday", "custsupptype", "amount", "count"};
    private static final List<String> SUM_FIELD = Arrays.asList("amount", "count");

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractAaApQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"custsupptype", ResManager.loadKDString((String)"\u5ba2\u5546\u7c7b\u578b", (String)"AbstractAaApQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"paymentday", ResManager.loadKDString((String)"\u8d26\u671f", (String)"AbstractAaApQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AbstractAaApQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"simplename", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7b80\u79f0", (String)"AbstractAaApQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ratio", ResManager.loadKDString((String)"\u5360\u6bd4", (String)"AbstractAaApQingDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"AbstractAaApQingDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        this.getQueryParam(paramMap);
        DataSet filter = allDs.filter("billtype = " + this.getBillType());
        return filter.groupBy(new String[]{"orgid", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> paramMap) {
        String custsuppType = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentDay = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        ds = ds.filter("paymentday = '" + paymentDay + "'");
        if (EmptyUtil.isNoEmpty((String)custsuppType) && !"allside".equals(custsuppType)) {
            ds = ds.filter("custsupptype = '" + custsuppType + "'");
        } else {
            ds = ds.updateField("custsupptype", "'allside'");
            ds = ds.groupBy(new String[]{"orgid", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
        }
        return this.handleDataSet(ds, paramMap);
    }

    private DataSet handleDataSet(DataSet ds, Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String custsuppType = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentDay = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        ds = orgDateSet.leftJoin(ds).on("orgid", "orgid").select(ORG_SELECTFIELD, SUMMARY_SELECTFIELD).finish().updateFields(new String[]{"paymentday", "custsupptype"}, new String[]{"'" + paymentDay + "'", "'" + custsuppType + "'"});
        ds = DecisionAnlsHelper.getSumDataSetByLevel(ds, SUM_FIELD, "orgid, orgname, simplename, paymentday, custsupptype").filter("amount>0");
        List filterOrg = EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            ds = ds.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", filterOrg));
        }
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        DataSet ratioDs = dataSets[1].groupBy(new String[]{"paymentday", "custsupptype"}).sum("amount", "orgtotalamt").finish();
        DataSet deal = ds.leftJoin(ratioDs).on("paymentday", "paymentday").on("custsupptype", "custsupptype").select(ds.getRowMeta().getFieldNames(), new String[]{"orgtotalamt"}).finish();
        deal = deal.addFields(new String[]{"case when orgtotalamt = 0 then 0 else amount/orgtotalamt*100 end", "concat(custsupptype, '_' , paymentday)"}, new String[]{"ratio", "param"});
        return ArapDataSetHelper.updateCustsuppTypeAndPaymentDay(deal);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("amount");
    }

    private void getQueryParam(Map<String, Object> paramMap) {
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        paramMap.put("allorgids", allorgids);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        paramMap.put("suborgids", secondOrgIds);
    }

    protected abstract String getBillType();
}

