/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.sdk.tmc.tda.extpoint.arap.IArApTopCustSuppInterface;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.AccountReceiveAndPayableHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractExtArApTopCustSuppQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet[] totalDataSets;
        DataSet allDs = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        List<String> custSuppFieldNames = this.getCustSuppFieldName();
        String propertyName = custSuppFieldNames.get(1);
        allDs = allDs.filter("billtype = '" + this.getBillType() + "' and custsupptype in ('inside', 'outside')").filter(this.buildExtendFilter(propertyName));
        custSuppFieldNames.add("custsupptype");
        custSuppFieldNames.add("paymentday");
        DataSet dataSet = allDs.groupBy(custSuppFieldNames.toArray(new String[0])).sum("amount").finish();
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        DataSet unionDs = DecisionAnlsHelper.createEmptyDataSet(fieldNames, dataSet.getRowMeta().getDataTypes());
        DataSet[] dataSets = dataSet.splitByGroup(new String[]{"paymentday", "custsupptype"});
        String orderStr = "customerid";
        if (!Arrays.asList(fieldNames).contains(orderStr)) {
            orderStr = "supplierid";
        }
        for (DataSet ds : dataSets) {
            DataSet topDs = ds.orderBy(new String[]{"amount desc", orderStr}).top(10);
            unionDs = unionDs.union(topDs);
        }
        DataSet allUnionDs = DecisionAnlsHelper.createEmptyDataSet(fieldNames, dataSet.getRowMeta().getDataTypes());
        for (DataSet ds : totalDataSets = unionDs.copy().splitByGroup(new String[]{"paymentday"})) {
            DataSet allTopDs = ds.orderBy(new String[]{"amount desc", orderStr}).top(10);
            allUnionDs = allUnionDs.union(allTopDs);
        }
        allUnionDs = allUnionDs.updateField("custsupptype", "'allside'");
        DataSet union = unionDs.union(allUnionDs).addField("concat(custsupptype, '_' , paymentday)", "param");
        return ArapDataSetHelper.updateCustsuppTypeAndPaymentDay(union);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> paramMap) {
        String custsupptype = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentday = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        return AccountReceiveAndPayableHelper.getAfterFilterDataSet((DataSet)ds, (String)custsupptype, (String)paymentday, (int)12, paramMap);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkFormId());
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(this.getLinkFormId());
        ArapDataSetHelper.setParameterFilter(ids, parameter);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId(this.getLinkFormId());
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("paymentDay", paramMap.get("paymentday"));
        customParams.put("custsupptype", paramMap.get("custsupptype"));
        param.setCustomParams(customParams);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("amount");
    }

    private FilterFunction buildExtendFilter(String propertyName) {
        PluginProxy pluginProxy = PluginProxy.create(IArApTopCustSuppInterface.class, (String)"kd.sdk.tmc.tda.extpoint.arap.IArApTopCustSuppInterface");
        List filterFunctions = pluginProxy.callReplace(p -> p.buildExtendFilter(propertyName));
        if (EmptyUtil.isNoEmpty((Object)filterFunctions) && EmptyUtil.isNoEmpty(filterFunctions.get(0))) {
            return (FilterFunction)filterFunctions.get(0);
        }
        return new FilterFunction(){

            public boolean test(Row row) {
                return true;
            }
        };
    }

    protected abstract String getBillType();

    protected abstract String getLinkFormId();

    protected abstract List<String> getCustSuppFieldName();
}

