/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bank.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.bank.helper.BankDrCrDistHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankDrCrDistDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "99";
    private static final String BANK_SUM = "bankSum";
    private static final String BANK_DRAW_SUM = "bankDrawSum";
    private static final String SUM_ID = "-1";
    private static final String SUB_SUM_ID = "-2";
    private static final String ROWID = "rowid";
    private static final String STAT = "stat";
    private static final String DRAWSTAT = "drawstat";
    private static final String[] STAT_FIELDS = new String[]{"stat", "drawstat"};

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return BankDrCrDistHelper.getCommonDataSet(paramMap, orgIds, queryDate);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, this.getAmtFields());
        queryParam.getCustomParam().put("topBankMap", this.getTopBankType(ds));
        Pair<DataSet, DataSet> splitBankDataSet = this.splitTopBank(ds);
        DataSet topBankDs = (DataSet)splitBankDataSet.getValue0();
        DataSet otherBankDs = (DataSet)splitBankDataSet.getValue1();
        if (otherBankDs != null) {
            DataSet otherSumDs = otherBankDs.copy().updateField("bankcate", OHTERBANK_ID);
            topBankDs = topBankDs.union(new DataSet[]{otherBankDs, otherSumDs});
        }
        DataSet groupSet = topBankDs.select(new String[]{"company", "bankcate", "valibalance", "drawamount"}).groupBy(new String[]{"company", "bankcate"}).sum("valibalance").sum("drawamount").finish();
        DataSet result = DecisionAnlsHelper.ChangeMultRowToColDataSet(groupSet, "bankcate", "company", PREFIX, Arrays.asList("valibalance", "drawamount"));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = BankDrCrDistDataListPlugin.getSumField(result);
        List<String> selectField = BankDrCrDistDataListPlugin.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on(ROWID, "company").select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "mixorgname,rowid orgid,sortcode");
        sumField.remove("bankcate_99valibalance");
        sumField.remove("bankcate_99drawamount");
        sumDataSet = sumDataSet.addFields(new String[]{this.getTotalSumColExpr(sumField, "valibalance"), this.getTotalSumColExpr(sumField, "drawamount")}, STAT_FIELDS);
        sumDataSet = this.removeAllZeroRow(sumDataSet, this.getStatFields()).orderBy(new String[]{"sortcode"});
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat+drawstat > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat+drawstat > 0");
        sumField.add(STAT);
        sumField.add(DRAWSTAT);
        this.addOtherBankId(sumDataSet, sumField);
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        return sumDataSet.union(totalSet);
    }

    private void addOtherBankId(DataSet ds, List<String> sumField) {
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String s1 = "bankcate_99valibalance";
        String s2 = "bankcate_99drawamount";
        for (String fieldName : fieldNames) {
            if (fieldName.equals(s1)) {
                sumField.add(s1);
                continue;
            }
            if (!fieldName.equals(s2)) continue;
            sumField.add(s2);
        }
    }

    private Pair<DataSet, DataSet> splitTopBank(DataSet ds) {
        DataSet topBankTempDs = ds.copy().filter("bankcate IS NOT NULL and bankcate > 1").groupBy(new String[]{"bankcate"}).sum("valibalance").sum("drawamount").finish().orderBy(new String[]{"valibalance DESC", "drawamount DESC"}).top(10);
        Set<String> topBankCate = DecisionAnlsHelper.getTopBanks(topBankTempDs, "bankcate");
        if (EmptyUtil.isEmpty(topBankCate)) {
            return new Pair((Object)ds, (Object)DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta()));
        }
        this.getQueryParam().getCustomParam().put("topBankCate", topBankCate);
        String topFilter = "bankcate in (" + String.join((CharSequence)",", topBankCate) + ")";
        DataSet[] dataSets = ds.splitByFilter(new String[]{topFilter}, true);
        return new Pair((Object)dataSets[0], (Object)dataSets[1]);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map<String, String> topBank = (Map<String, String>)this.getQueryParam().getCustomParam().get("topBankMap");
        if (topBank == null) {
            topBank = this.getTopBankType(null);
        }
        Set topBankCate = (Set)this.getQueryParam().getCustomParam().get("topBankCate");
        String[] amountFieldName = new String[]{"valibalance", "drawamount"};
        Boolean isShowAll = (Boolean)this.getQueryParam().getCustomParam().get("isShowAll");
        for (Map.Entry<String, String> topBankEntry : topBank.entrySet()) {
            String bankCate = topBankEntry.getKey();
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(PREFIX + bankCate);
            newColGroup.setCaption(new LocaleString(topBankEntry.getValue()));
            for (String amountField : amountFieldName) {
                String colFieldKey = PREFIX + bankCate + amountField;
                String caption = "";
                switch (amountField) {
                    case "valibalance": {
                        caption = ResManager.loadKDString((String)"\u5b58\u6b3e", (String)"BankCrDrDistDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
                        if (SUB_SUM_ID.equals(bankCate)) {
                            colFieldKey = BANK_SUM;
                            break;
                        }
                        if (!SUM_ID.equals(bankCate)) break;
                        colFieldKey = STAT;
                        break;
                    }
                    case "drawamount": {
                        caption = ResManager.loadKDString((String)"\u8d37\u6b3e", (String)"BankCrDrDistDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
                        if (SUB_SUM_ID.equals(bankCate)) {
                            colFieldKey = BANK_DRAW_SUM;
                            break;
                        }
                        if (!SUM_ID.equals(bankCate)) break;
                        colFieldKey = DRAWSTAT;
                        break;
                    }
                }
                ReportColumn newCol = new ReportColumn();
                if (OHTERBANK_ID.equals(bankCate)) {
                    newCol.setHyperlink(true);
                }
                if (EmptyUtil.isNoEmpty((Object)topBankCate) && !topBankCate.contains(bankCate)) {
                    if (isShowAll != null && isShowAll.booleanValue()) {
                        newCol.setHide(false);
                        if (OHTERBANK_ID.equals(bankCate)) {
                            newCol.setHide(true);
                        }
                    } else {
                        newCol.setHide(true);
                        if (SUM_ID.equals(bankCate) || OHTERBANK_ID.equals(bankCate)) {
                            newCol.setHide(false);
                        }
                    }
                }
                newCol.setScale(2);
                newCol.setZeroShow(true);
                newCol.setFieldKey(colFieldKey);
                newCol.setFieldType("decimal");
                newCol.setCaption(new LocaleString(caption));
                newColGroup.getChildren().add(newCol);
            }
            columns.add((AbstractReportColumn)newColGroup);
        }
        return columns;
    }

    private Set<String> getAmtFields() {
        HashSet<String> amtSet = new HashSet<String>(8);
        amtSet.add("valibalance");
        amtSet.add("drawamount");
        amtSet.add(MergeOffsetHandler.COL_OFFSETFILENAME);
        return amtSet;
    }

    private Set<String> getStatFields() {
        HashSet<String> statSet = new HashSet<String>(4);
        statSet.add(STAT);
        statSet.add(DRAWSTAT);
        return statSet;
    }

    private static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(32);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(32);
        selectField.addAll(sumField);
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }

    private Map<String, String> getTopBankType(DataSet bankDs) {
        Map paramMap = this.transQueryParam(this.getQueryParam());
        if (bankDs == null) {
            List orgids = (List)paramMap.get("allorgids");
            Date queryDate = DateUtils.getDataFormat((Date)((Date)paramMap.get("querydate")), (boolean)false);
            bankDs = BankDrCrDistHelper.getCommonDataSet(paramMap, orgids, queryDate);
        }
        Map<String, String> topBank = this.getTopBankCate(bankDs);
        topBank.put(OHTERBANK_ID, ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"BankCrDrDistDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        topBank.put(SUM_ID, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BankCrDrDistDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        return topBank;
    }

    private Map<String, String> getTopBankCate(DataSet bankDs) {
        LinkedHashMap<String, String> topBank = new LinkedHashMap<String, String>(16);
        DataSet topBankCateSet = bankDs.copy().select(new String[]{"bankcate", "bankname", "valibalance", "drawamount"}).groupBy(new String[]{"bankcate", "bankname"}).sum("valibalance").sum("drawamount").finish().orderBy(new String[]{"valibalance desc", "drawamount desc"});
        while (topBankCateSet.hasNext()) {
            Row row = topBankCateSet.next();
            topBank.put(String.valueOf(row.getLong(0)), row.getString(1));
        }
        return topBank;
    }

    private String getTotalSumColExpr(List<String> sumField, String originalAmtField) {
        String totalSumColExpr = sumField.stream().filter(f -> f.endsWith(originalAmtField)).collect(Collectors.joining("+"));
        if (EmptyUtil.isEmpty((String)totalSumColExpr)) {
            totalSumColExpr = "0";
        }
        return totalSumColExpr;
    }
}

