/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bank.data;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.bank.helper.BankDrCrDistHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankOtherDrCrDistDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String BANK_NAME = "bankname";
    private static final String VALIBALANCE = "valibalance";
    private static final String DRAWAMOUNT = "drawamount";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        String orgViewNumber = orgView.getString("number");
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(orgId), (boolean)true, (boolean)true);
        return BankDrCrDistHelper.getCommonDataSet(paramMap, allOrgIds, queryDate).select(new String[]{COMPANY, BANK_NAME, VALIBALANCE, DRAWAMOUNT});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = this.getNoTopBankDs(ds);
        String currentOrgId = (String)paramMap.get("current_org_id");
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(Long.valueOf(currentOrgId)), (boolean)true, (boolean)true);
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        if (EmptyUtil.isNoEmpty((String)currentOrgId) && currentOrgId.equals("" + orgId)) {
            subOrgIds.remove(orgId);
        }
        ds = ds.filter("company in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("valibalance+drawamount>0");
        ds = ds.groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).sum(DRAWAMOUNT).finish().orderBy(new String[]{"valibalance DESC", "drawamount DESC"});
        DataSet sumDs = ds.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).sum(DRAWAMOUNT).finish();
        ds = ds.addField("0", "sumlevel");
        sumDs = sumDs.addField("1", "sumlevel");
        return ds.union(sumDs);
    }

    private DataSet getNoTopBankDs(DataSet ds) {
        DataSet topBankTempDs = ds.copy().filter("bankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).sum(DRAWAMOUNT).finish().orderBy(new String[]{"valibalance DESC", "drawamount DESC"}).top(10);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        DataSet noTopBankDs = ds.copy().filter(DecisionAnlsHelper.buildOtherFilter(topBanks, BANK_NAME));
        return noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(VALIBALANCE).sum(DRAWAMOUNT).finish();
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(VALIBALANCE);
        fields.add(DRAWAMOUNT);
        return fields;
    }
}

