/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bank.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.StringUtils;

public class BankDrCrDistHelper {
    private static final Log LOGGER = LogFactory.getLog(BankDrCrDistHelper.class);
    private static final String ALGOKEY = BankDrCrDistHelper.class.getName();
    public static final String TMC_TDA_REPORT = "tmc-tda-report";
    public static final String DISPLAY_TYPE = "displayType";
    public static final String BANKCATE = "bankcate";
    public static final String ISOFFSET = "isoffset";
    public static final String COMPANY = "company";
    public static final String ISDOMESTIC = "isdomestic";
    public static final String BANKNAME = "bankname";
    public static final String VALIBALANCE = "valibalance";
    public static final String DRAWAMOUNT = "drawamount";
    public static final String CURRENCY = "currency";
    public static final String MIXORGNAME = "mixorgname";
    public static final String FINORGTYPE = "finorgtype";
    public static final char BLANKCHAR = ' ';
    public static final int TOP = 10;

    public static DataSet getQingDataSet(Map<String, Object> paramMap, List<Long> orgIds, AcctDisplayByBankTypeEnum dataRangeType) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet drDs = CashFundsDataHelper.getFundDataSet((String)(ALGOKEY + "_getFundDataSet"), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        drDs = drDs.select(new String[]{"bankcatename bankname", "bankcateid bankcate", ISDOMESTIC, FINORGTYPE, VALIBALANCE, "realvalibalance", "realrestrictedamt"}).filter("finorgtype = '" + FinOrgTypeEnum.BANK.getValue() + "'" + BankDrCrDistHelper.getDomesticFilter(dataRangeType)).updateField(VALIBALANCE, "realvalibalance + realrestrictedamt").select(new String[]{BANKNAME, BANKCATE, VALIBALANCE});
        drDs = drDs.groupBy(new String[]{BANKNAME, BANKCATE}).sum(VALIBALANCE).finish();
        Pair<DataSet, DataSet> splitBankDataSet = DecisionAnlsHelper.splitTopBank(drDs, VALIBALANCE, 10);
        DataSet topBankDrDs = (DataSet)splitBankDataSet.getValue0();
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet crDs = FinanceDataHelper.getFinanceDataSet((String)(ALGOKEY + "_getFinanceDataSet"), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        crDs = crDs.select("creditortype,bankcatename bankname,bankcate,repayamount drawamount,region,isequity").filter("isequity=false and creditortype='bank' and bankcate > 0" + BankDrCrDistHelper.getRegionFilter(dataRangeType)).groupBy(new String[]{BANKNAME, BANKCATE}).sum(DRAWAMOUNT).finish();
        DataSet unionDs = BankDrCrDistHelper.fullJoin(topBankDrDs, crDs, new String[]{BANKCATE, BANKNAME}, new String[]{VALIBALANCE}, new String[]{DRAWAMOUNT});
        unionDs = unionDs.groupBy(new String[]{BANKNAME}).sum(VALIBALANCE).sum(DRAWAMOUNT).finish().orderBy(new String[]{"valibalance desc", "drawamount desc"}).top(10);
        return unionDs;
    }

    public static DataSet getCommonDataSet(Map<String, Object> paramMap, List<Long> orgIds, Date queryDate) {
        AcctDisplayByBankTypeEnum dataRangeType = BankDrCrDistHelper.getAcctDisplayByBankTypeEnum(paramMap);
        DataSet drDs = CashFundsDataHelper.getFundDataSet((String)(ALGOKEY + "_getFundDataSet"), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        drDs = drDs.select(new String[]{COMPANY, "bankcatename bankname", "bankcateid bankcate", ISDOMESTIC, FINORGTYPE, VALIBALANCE, "realvalibalance", "realrestrictedamt", ISOFFSET}).filter("finorgtype = '" + FinOrgTypeEnum.BANK.getValue() + "'" + BankDrCrDistHelper.getDomesticFilter(dataRangeType)).updateField(VALIBALANCE, "realvalibalance + realrestrictedamt");
        drDs = drDs.groupBy(new String[]{COMPANY, BANKNAME, BANKCATE, ISDOMESTIC, FINORGTYPE, ISOFFSET}).sum(VALIBALANCE).finish().filter("valibalance > 0");
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet crDs = FinanceDataHelper.getFinanceDataSet((String)(ALGOKEY + "_getFinanceDataSet"), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        crDs = crDs.select("creditortype,bankcatename bankname,bankcate,repayamount drawamount,region,isequity,org company,rowoffset,coloffset").filter("isequity=false and creditortype='bank' and bankcate > 0" + BankDrCrDistHelper.getRegionFilter(dataRangeType)).groupBy(new String[]{COMPANY, BANKNAME, BANKCATE}).sum(MergeOffsetHandler.COL_OFFSETFILENAME).sum(DRAWAMOUNT).finish();
        DataSet unionDs = BankDrCrDistHelper.fullJoin(drDs, crDs, new String[]{BANKCATE, BANKNAME, COMPANY}, new String[]{ISDOMESTIC, FINORGTYPE, ISOFFSET, VALIBALANCE}, new String[]{MergeOffsetHandler.COL_OFFSETFILENAME, DRAWAMOUNT});
        return unionDs.updateFields(new String[]{VALIBALANCE, DRAWAMOUNT}, new String[]{"case when valibalance is null then 0.0 else valibalance end", "case when drawamount is null then 0.0 else drawamount end"});
    }

    public static AcctDisplayByBankTypeEnum getAcctDisplayByBankTypeEnum(Map<String, Object> paramMap) {
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        LOGGER.info("BankDrCrDistDataListPlugin.getAcctDisplayByBankTypeEnum displayType:" + displayType);
        return AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
    }

    private static String getDomesticFilter(AcctDisplayByBankTypeEnum dataRangeType) {
        String isDomesticFilter = "";
        if (AcctDisplayByBankTypeEnum.DOMESTIC == dataRangeType) {
            isDomesticFilter = " and isdomestic = '1'";
        } else if (AcctDisplayByBankTypeEnum.OVERSEAS == dataRangeType) {
            isDomesticFilter = " and isdomestic = '0'";
        }
        return isDomesticFilter;
    }

    private static String getRegionFilter(AcctDisplayByBankTypeEnum dataRangeType) {
        String isDomesticFilter = "";
        if (dataRangeType == AcctDisplayByBankTypeEnum.DOMESTIC) {
            isDomesticFilter = " and region = 1 ";
        } else if (dataRangeType == AcctDisplayByBankTypeEnum.OVERSEAS) {
            isDomesticFilter = " and region = 0 ";
        }
        return isDomesticFilter;
    }

    private static DataSet fullJoin(DataSet left, DataSet right, String[] commonColumns, String[] leftOwnColumns, String[] rightOwnColumns) {
        String[] ss;
        String[] leftCommonColumns = (String[])Arrays.stream(commonColumns).map(o -> o + " as left" + o).toArray(String[]::new);
        String[] rightCommonColumns = (String[])Arrays.stream(commonColumns).map(o -> o + " as right" + o).toArray(String[]::new);
        String[] selectedColumns = new String[commonColumns.length + leftOwnColumns.length + rightOwnColumns.length];
        String[] leftColumns = new String[leftCommonColumns.length + leftOwnColumns.length];
        String[] rightColumns = new String[rightCommonColumns.length + rightOwnColumns.length];
        int index = 0;
        int leftIndex = 0;
        int rightIndex = 0;
        String bankCateId = StringUtils.split((String)leftCommonColumns[0], (char)' ')[2];
        for (int i = 0; i < commonColumns.length; ++i) {
            selectedColumns[index++] = "(case when " + bankCateId + " > 0 then " + StringUtils.split((String)leftCommonColumns[i], (char)' ')[2] + " else " + StringUtils.split((String)rightCommonColumns[i], (char)' ')[2] + " end) as " + commonColumns[i];
        }
        for (String leftCommonColumn : leftCommonColumns) {
            leftColumns[leftIndex++] = leftCommonColumn;
        }
        for (String leftOwnColumn : leftOwnColumns) {
            ss = StringUtils.split((String)leftOwnColumn, (char)' ');
            selectedColumns[index++] = ss.length == 1 ? ss[0] : ss[2];
            leftColumns[leftIndex++] = leftOwnColumn;
        }
        for (String rightCommonColumn : rightCommonColumns) {
            rightColumns[rightIndex++] = rightCommonColumn;
        }
        for (String rightOwnColumn : rightOwnColumns) {
            ss = StringUtils.split((String)rightOwnColumn, (char)' ');
            selectedColumns[index++] = ss.length == 1 ? ss[0] : ss[2];
            rightColumns[rightIndex++] = rightOwnColumn;
        }
        JoinDataSet joinDataSet = left.join(right, JoinType.FULL);
        for (String commonColumn : commonColumns) {
            joinDataSet = joinDataSet.on(commonColumn, commonColumn);
        }
        return joinDataSet.select(leftColumns, rightColumns).finish().select(selectedColumns);
    }
}

