/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.BankAcctDateRangeEnum;
import kd.tmc.tda.report.bankacct.data.AcctDetailDataListPlugin;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class AcctChangeDetailDataListPlugin
extends AcctDetailDataListPlugin {
    private static final String ACCTCOUNT = "acctcount";
    private static final String CHANGEDATE = "changedate";
    private static final String CHANGETYPE = "changetype";
    private static final String OP_DATE = "opDate";

    @Override
    protected List<Object[]> getColumnItems() {
        List<Object[]> columnItems = super.getColumnItems();
        columnItems.add(new Object[]{CHANGEDATE, ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f", (String)"AcctDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        columnItems.add(new Object[]{CHANGETYPE, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"AcctDetailDataListPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("open", ResManager.loadKDString((String)"\u5f00\u6237", (String)"AcctDetailDataListPlugin_32", (String)"tmc-tda-report", (Object[])new Object[0]), "close", ResManager.loadKDString((String)"\u9500\u6237", (String)"AcctDetailDataListPlugin_33", (String)"tmc-tda-report", (Object[])new Object[0]), "change", ResManager.loadKDString((String)"\u53d8\u66f4", (String)"AcctDetailDataListPlugin_34", (String)"tmc-tda-report", (Object[])new Object[0]))});
        return columnItems;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Object> dateRangeMap = BankAcctHelper.getDateRangeMap(queryDate);
        DataSet bankAcctSet = BankAcctHelper.queryUncloseacct(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] configDataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        bankAcctSet = configDataSets[0].union(BankAcctHelper.getUnBankAcctSet(configDataSets));
        bankAcctSet = bankAcctSet.filter("opendate != NULL AND opendate < querydate AND opendate >= minDate", dateRangeMap);
        DataSet acctOpenSet = bankAcctSet.copy().addNullField(CHANGEDATE).addFields(new String[]{"'open'", "opendate", "1"}, new String[]{CHANGETYPE, OP_DATE, ACCTCOUNT});
        DataSet acctCloseSet = bankAcctSet.copy().filter("closedate != NULL AND closedate < querydate AND closedate >= minDate", dateRangeMap).addNullField(CHANGEDATE).addFields(new String[]{"'close'", "closedate", "1"}, new String[]{CHANGETYPE, OP_DATE, ACCTCOUNT});
        DataSet acctChangeSet = BankAcctHelper.getAcctChangeSet(paramMap);
        acctChangeSet = acctChangeSet.leftJoin(bankAcctSet).on("accountid", "id").select(new String[]{"auditdate as changedate"}, bankAcctSet.getRowMeta().getFieldNames()).finish().filter("id is not null").addFields(new String[]{"'change'", CHANGEDATE, "1"}, new String[]{CHANGETYPE, OP_DATE, ACCTCOUNT});
        DataSet union = acctOpenSet.union(new DataSet[]{acctChangeSet.select(acctOpenSet.getRowMeta().getFieldNames()), acctCloseSet});
        String dateRange = (String)paramMap.get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = BankAcctDateRangeEnum.CURRENT_MONTH.getValue();
        }
        union = union.addField("TO_CHAR(opDate,'yyyyMMdd')", "dateSub");
        DataSet[] dataSets = union.splitByFilter(new String[]{"dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(dateRange)), (String)"yyyyMMdd")}, false);
        union = dataSets[0].addFields(new String[]{"org", "org_name", "case when bankinterface = 'bi_true' then 'true' else 'false' end"}, new String[]{"company", "orgname", "isbankinterface"});
        DataSet resultSet = this.updateFields(union, paramMap);
        return resultSet;
    }
}

