/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;

public class AcctDetailDataListPlugin
extends AbstractDetailDataPlugin {
    private static final Log logger = LogFactory.getLog(AcctDetailDataListPlugin.class);

    @Override
    protected List<Object[]> getColumnItems() {
        List<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"AcctDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"companyname", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"AcctDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acctcount", ResManager.loadKDString((String)"\u8d26\u6237\u6570", (String)"AcctDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"AcctDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acctname", ResManager.loadKDString((String)"\u8d26\u6237\u540d\u79f0", (String)"AcctDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acctsimplename", ResManager.loadKDString((String)"\u8d26\u6237\u7b80\u79f0", (String)"AcctDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"finorgtype", ResManager.loadKDString((String)"\u5f00\u6237\u673a\u6784\u7c7b\u578b", (String)"AcctDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("0", TdaFinOrgTypeEnum.BANK.getName(), "1", TdaFinOrgTypeEnum.CLEARINGHOUSE.getName(), "3", TdaFinOrgTypeEnum.FINCOMP.getName(), "4", TdaFinOrgTypeEnum.TRDPARTPAY.getName(), "999", TdaFinOrgTypeEnum.OTHERACCT.getName())});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"AcctDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"finorgname", ResManager.loadKDString((String)"\u5f00\u6237\u94f6\u884c", (String)"AcctDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AcctDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"defaultcurrency", ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u79cd", (String)"AcctDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, BankAcctHelper.getEnumItemsByProperty("acctstyle").values().stream().collect(Collectors.toList())});
        field.add(new Object[]{"accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, BankAcctHelper.getEnumItemsByProperty("accttype").values().stream().collect(Collectors.toList())});
        field.add(new Object[]{"acctusagename", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"areas", ResManager.loadKDString((String)"\u5883\u5185\u5916\u6807\u8bc6", (String)"AcctDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("domestic", ResManager.loadKDString((String)"\u5883\u5185", (String)"AcctDetailDataListPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "overseas", ResManager.loadKDString((String)"\u5883\u5916", (String)"AcctDetailDataListPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"province", ResManager.loadKDString((String)"\u6240\u5728\u7701", (String)"AcctDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"city", ResManager.loadKDString((String)"\u6240\u5728\u5e02", (String)"AcctDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"isbankinterface", ResManager.loadKDString((String)"\u5f00\u901a\u94f6\u4f01\u63a5\u53e3", (String)"AcctDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"isopenbank", ResManager.loadKDString((String)"\u5f00\u901a\u7f51\u4e0a\u94f6\u884c", (String)"AcctDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"bebankfunc", ResManager.loadKDString((String)"\u94f6\u4f01\u529f\u80fd", (String)"AcctDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"opendate", ResManager.loadKDString((String)"\u5f00\u6237\u65e5\u671f", (String)"AcctDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"closedate", ResManager.loadKDString((String)"\u9500\u6237\u65e5\u671f", (String)"AcctDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"acctstatus", ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001", (String)"AcctDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, BankAcctHelper.getEnumItemsByProperty("acctstatus").values().stream().collect(Collectors.toList())});
        field = AcctDetailDataListPlugin.getDetailColumnItemsExt(field);
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        String bankInterface;
        String acctUsage;
        DataSet query = BankAcctHelper.query(((Object)((Object)this)).getClass().getSimpleName(), paramMap);
        DataSet[] configDataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(query);
        query = configDataSets[0].union(BankAcctHelper.getUnBankAcctSet(configDataSets));
        query = query.addFields(new String[]{"org", "org_name", "case when bankinterface = 'bi_true' then 'true' else 'false' end", "1"}, new String[]{"company", "orgname", "isbankinterface", "acctcount"});
        DataSet resultSet = this.updateFields(query, paramMap);
        String displayType = (String)paramMap.get("displayType");
        if (displayType != null) {
            resultSet = resultSet.filter("areas = '" + displayType + "'");
        }
        if (EmptyUtil.isNoEmpty((String)(acctUsage = (String)paramMap.get("acctUsage")))) {
            resultSet = resultSet.filter("usagelongnumber != null and usagelongnumber != ''");
        }
        if (EmptyUtil.isNoEmpty((String)(bankInterface = (String)paramMap.get("bankInterface")))) {
            resultSet = BasicParamHelper.getBasicParamApplicationConfigs((DataSet)resultSet, (String)"bankapplyconditiontag");
        }
        return resultSet;
    }

    @Override
    protected String getCountField() {
        return "acctcount";
    }

    @Override
    protected List<String> getSumLists() {
        return new ArrayList<String>(2);
    }

    @Override
    protected String getBaseString() {
        return "orgname";
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("bankaccountnumber", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        return hyperLinkClickEvent -> BankAcctHelper.getMetadataSignExt();
    }

    protected DataSet updateFields(DataSet dataSet, Map<String, Object> paramMap) {
        final Map<Object, DynamicObject> currencyMap = BankAcctHelper.queryAccountCurrency(paramMap);
        final Map<String, ValueMapItem> bebankfuncMap = BankAcctHelper.getEnumItemsByProperty("bebankfunc");
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Object accountId = row.get("id");
                DynamicObject dynamicObject = (DynamicObject)currencyMap.get(accountId);
                StringJoiner currencyNames = new StringJoiner("\uff0c");
                dynamicObject.getDynamicObjectCollection("currency").stream().forEach(currencyObj -> {
                    DynamicObject currency = currencyObj.getDynamicObject("fbasedataid");
                    if (currency == null) {
                        return;
                    }
                    String name = currency.getString("name");
                    currencyNames.add(name);
                });
                int currencynameIndex = rowMeta.getFieldIndex("currencyname");
                data[currencynameIndex] = currencyNames.toString();
                String bebankfunc = row.getString("bebankfunc");
                String[] split = bebankfunc.split(",");
                StringJoiner bebankfuncNameStr = new StringJoiner("\uff1b");
                for (int i = 0; i < split.length; ++i) {
                    String value = split[i];
                    ValueMapItem valueMapItem = (ValueMapItem)bebankfuncMap.get(value);
                    if (valueMapItem == null) continue;
                    bebankfuncNameStr.add(valueMapItem.getName().getLocaleValue());
                }
                int bebankfuncIndex = rowMeta.getFieldIndex("bebankfunc");
                data[bebankfuncIndex] = bebankfuncNameStr.toString();
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private static List<Object[]> getDetailColumnItemsExt(List<Object[]> fieldColumns) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.detailColumnItemsExt");
        List resultList = pluginProxy.callReplace(p -> p.detailColumnItemsExt(fieldColumns));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IBankAcctInterface.detailColumnItemsExt \u4e0d\u4e3a\u7a7a\uff0c\u660e\u7ec6\u5217\u6570\uff1a" + ((List)resultList.get(0)).size());
            return (List)resultList.get(0);
        }
        logger.info("IBankAcctInterface.detailColumnItemsExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return fieldColumns;
    }
}

