/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctByBankInterfaceRPA;
import kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.report.bankacct.extpoint.BankInterfaceRPADefaultExt;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctByBankInterfaceDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(BankAcctByBankInterfaceDataListPlugin.class);
    private static final List<String> FINCOM_FIELDS = Arrays.asList("fincom_domestic_bi_false", "fincom_domestic_bi_true", "fincom_overseas_bi_false", "fincom_overseas_bi_true");
    private static final String ORG = "org";
    private static final String ORG_NAME = "org_name";
    private static final String MIX_ORGNAME = "mixorgname";
    private static final String ROWID = "rowid";
    private static final String PID = "pid";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String LEVEL = "level";
    private static final String BANK_INTERFACE = "bankinterface";
    private static final String BANK_ACCTS = "bankaccts";
    private static final String COMPANY_ACCTS = "companyaccts";
    private static final String ACCTS = "accts";
    private static final String DOMESTIC_BI_TRUE = "domestic_bi_true";
    private static final String DOMESTIC_BI_FALSE = "domestic_bi_false";
    private static final String DOMESTIC_RPA = "domestic_rpa";
    private static final String DOMESTIC_SUBTOTAL = "domestic_subtotal";
    private static final String OVERSEAS_BI_TRUE = "overseas_bi_true";
    private static final String OVERSEAS_BI_FALSE = "overseas_bi_false";
    private static final String OVERSEAS_RPA = "overseas_rpa";
    private static final String OVERSEAS_SUBTOTAL = "overseas_subtotal";
    private static final String RPA_COUNT = "rpa_count";
    private static final String DOMESTIC_OPENING_RATE = "domestic_opening_rate";
    private static final String OVERSEAS_OPENING_RATE = "overseas_opening_rate";
    private static final String OPENING_RATE = "opening_rate";
    private static List<String> sumFields = new ArrayList<String>(Arrays.asList("domestic_bi_true", "domestic_bi_false", "overseas_bi_true", "overseas_bi_false", "domestic_rpa", "overseas_rpa"));
    List<String> allSumFilds = new ArrayList<String>(sumFields);

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map transQueryParam = this.transQueryParam(reportQueryParam);
        DataSet bankAcctRPASet = this.getBankAcctRPASet(transQueryParam);
        return bankAcctRPASet.select(new String[]{"id", ORG, "areas", "finorgtype", BANK_INTERFACE, RPA_COUNT, "bankcate"});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        RowMeta rowMeta = ds.getRowMeta();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map reportQueryMap = this.transQueryParam(queryParam);
        ds = this.processDataSet(ds, reportQueryMap);
        List subOrgIds = EmptyUtil.isNoEmpty(reportQueryMap.get("suborgids")) ? (List)reportQueryMap.get("suborgids") : (List)reportQueryMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            ds = ds.where("org in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(ds, this.allSumFilds, ORG_NAME);
        if (Arrays.asList(ds.getRowMeta().getFieldNames()).contains("sortcode")) {
            ds = ds.orderBy(new String[]{"sortcode"});
        }
        DataSet resultSet = ds.union(sDataSet);
        String companyField = "bankcate_" + TdaFinOrgTypeEnum.FINCOMP.getValue();
        resultSet = resultSet.getRowMeta().getFieldIndex(companyField, false) < 0 ? resultSet.addField("0", COMPANY_ACCTS) : resultSet.addField(companyField, COMPANY_ACCTS);
        resultSet = resultSet.addField("domestic_bi_true + domestic_bi_false", DOMESTIC_SUBTOTAL);
        resultSet = resultSet.addField("overseas_bi_true + overseas_bi_false", OVERSEAS_SUBTOTAL);
        resultSet = resultSet.addField("domestic_subtotal + overseas_subtotal", BANK_ACCTS);
        String join = String.join((CharSequence)"+", Arrays.stream(resultSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith("bankcate_")).collect(Collectors.toSet()));
        resultSet = EmptyUtil.isNoEmpty((String)join) ? resultSet.addField("bankaccts + " + join, ACCTS) : resultSet.addField(BANK_ACCTS, ACCTS);
        resultSet = DecisionAnlsHelper.updateValueWhenNull(resultSet, Arrays.asList(DOMESTIC_BI_TRUE, DOMESTIC_SUBTOTAL, FINCOM_FIELDS.get(0), FINCOM_FIELDS.get(1), OVERSEAS_BI_TRUE, OVERSEAS_SUBTOTAL, FINCOM_FIELDS.get(2), FINCOM_FIELDS.get(3), COMPANY_ACCTS, ACCTS));
        resultSet = resultSet.addField("case when (domestic_subtotal + fincom_domestic_bi_false + fincom_domestic_bi_true) = 0 then 0.00 else (domestic_bi_true + fincom_domestic_bi_true)*1.0/(domestic_subtotal + fincom_domestic_bi_false + fincom_domestic_bi_true) end", DOMESTIC_OPENING_RATE);
        resultSet = resultSet.addField("case when (overseas_subtotal + fincom_overseas_bi_false + fincom_overseas_bi_true) = 0 then 0.00 else (overseas_bi_true + fincom_overseas_bi_true)*1.0/(overseas_subtotal + fincom_overseas_bi_false + fincom_overseas_bi_true) end", OVERSEAS_OPENING_RATE);
        resultSet = resultSet.addField("case when (domestic_subtotal + overseas_subtotal + companyaccts) = 0 then 0.00 else (domestic_bi_true + overseas_bi_true + fincom_domestic_bi_true + fincom_overseas_bi_true)*1.0/(domestic_subtotal + overseas_subtotal + companyaccts) end", OPENING_RATE);
        resultSet = resultSet.filter("accts != 0 and accts != null");
        resultSet = BankAcctByBankInterfaceDataListPlugin.getReportDataSetExt(resultSet, queryParam);
        return resultSet.addField(ROWID, "orgid");
    }

    private DataSet getBankAcctRPASet(Map<String, Object> reportQueryMap) {
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), reportQueryMap);
        bankAcctSet = bankAcctSet.select(new String[]{"id", ORG, "areas", "finorgtype", BANK_INTERFACE, "bankcate"});
        DataSet[] bankAcctSets = bankAcctSet.splitByFilter(new String[]{"true", "true"}, false);
        Iterator iterator = bankAcctSets[0].iterator();
        if (!iterator.hasNext()) {
            return bankAcctSets[1].addField("0", RPA_COUNT);
        }
        ArrayList<Long> acctIds = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            acctIds.add(next.getLong("id"));
        }
        DataSet rpaDataSetByExtPoint = this.getRPADataSetByExtPoint(Collections.singletonMap("acctIds", acctIds));
        DataSet bankAcctRPASet = bankAcctSets[1].leftJoin(rpaDataSetByExtPoint).on("id", "acct_id").select(bankAcctSets[1].getRowMeta().getFieldNames(), new String[]{RPA_COUNT}).finish();
        return bankAcctRPASet;
    }

    private DataSet getRPADataSetByExtPoint(Map<String, Object> param) {
        BankInterfaceRPADefaultExt interfaceRPA = new BankInterfaceRPADefaultExt();
        PluginProxy pluginProxy = PluginProxy.create((Object)interfaceRPA, IBankAcctByBankInterfaceRPA.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.RPA", null);
        List dataSet = pluginProxy.callReplaceIfPresent(p -> p.queryRPADataSet(param));
        return (DataSet)dataSet.get(0);
    }

    private DataSet processDataSet(DataSet ds, Map<String, Object> reportQueryMap) {
        ds = BasicParamHelper.getBasicParamApplicationConfigs((DataSet)ds, (String)"bankapplyconditiontag");
        DataSet[] splitDataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(ds);
        DataSet[] bankAcctSets = splitDataSets[0].splitByFilter(new String[]{"true", "true"}, false);
        DataSet interfaceSet = bankAcctSets[0].select(new String[]{ORG, "concat(areas,concat('_',bankinterface)) as bankinterface"}).addField("1", "count").groupBy(new String[]{ORG, BANK_INTERFACE}).sum("count").finish();
        interfaceSet = DecisionAnlsHelper.ChangeRowToColDataSet(interfaceSet, BANK_INTERFACE, ORG, "");
        DataSet rpaSet = bankAcctSets[1].select(new String[]{ORG, "case when areas = 'domestic' then 'domestic_rpa' else 'overseas_rpa' end as rpa", "case when rpa_count is Null then 0 else rpa_count end as count"}).groupBy(new String[]{ORG, "rpa"}).sum("count").finish();
        rpaSet = DecisionAnlsHelper.ChangeRowToColDataSet(rpaSet, "rpa", ORG, "");
        DataSet bankSet = interfaceSet.leftJoin(rpaSet).on(ORG, ORG).select(BankAcctHelper.getFieldNameSet(interfaceSet.getRowMeta().getFieldNames(), rpaSet.getRowMeta().getFieldNames()).toArray(new String[0])).finish();
        bankSet = DecisionAnlsHelper.addAbsentFields(bankSet, sumFields);
        DataSet[] fincoms = splitDataSets[2].splitByFilter(new String[]{"true", "true"}, false);
        splitDataSets[2] = fincoms[0];
        DataSet fincom = fincoms[1].select(new String[]{ORG, "concat(areas,concat('_',bankinterface)) as bankinterface"}).addField("1", "count").groupBy(new String[]{ORG, BANK_INTERFACE}).sum("count").finish();
        fincom = DecisionAnlsHelper.ChangeRowToColDataSet(fincom, BANK_INTERFACE, ORG, "fincom_");
        fincom = DecisionAnlsHelper.addAbsentFields(fincom, FINCOM_FIELDS);
        DataSet unBankAcctSet = BankAcctHelper.getUnBankAcctSet(splitDataSets);
        unBankAcctSet = unBankAcctSet.select(new String[]{ORG, "bankcate"}).addField("1", "count").groupBy(new String[]{ORG, "bankcate"}).sum("count").finish();
        unBankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(unBankAcctSet, "bankcate", ORG, "bankcate_");
        Long orgViewId = ((DynamicObject)reportQueryMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDataSet = orgDateSet.leftJoin(bankSet).on(ORG, ORG).select(new String[]{ORG, ROWID, PID, ISGROUPNODE, LEVEL, "mixorgname as org_name", "sortcode"}, sumFields.toArray(new String[0])).finish();
        List<String> unbankfields = Arrays.stream(unBankAcctSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith("bankcate_")).collect(Collectors.toList());
        leftJoinDataSet = leftJoinDataSet.leftJoin(unBankAcctSet).on(ORG, ORG).select(leftJoinDataSet.getRowMeta().getFieldNames(), unbankfields.toArray(new String[0])).finish().addField("0", "sumlevel");
        leftJoinDataSet = leftJoinDataSet.leftJoin(fincom).on(ORG, ORG).select(leftJoinDataSet.getRowMeta().getFieldNames(), FINCOM_FIELDS.toArray(new String[0])).finish();
        this.allSumFilds.addAll(unbankfields);
        this.allSumFilds.addAll(FINCOM_FIELDS);
        DataSet sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDataSet, this.allSumFilds, "org,org_name,sortcode");
        return DecisionAnlsHelper.removeNoDataTreeDs(sumResultSet, this.allSumFilds, false);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List amFinOrgTypeConfigs = BankAcctHelper.getAmFinOrgTypeConfigs().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        int index = 5;
        for (String finOrgTypeValue : amFinOrgTypeConfigs) {
            String name = TdaFinOrgTypeEnum.getName((String)finOrgTypeValue);
            columns.add(index, (AbstractReportColumn)this.createColumn("bankcate_" + finOrgTypeValue, name, false));
        }
        columns = BankAcctByBankInterfaceDataListPlugin.getReportColumnsExt(columns);
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption, boolean isHide) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("integer");
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setHide(isHide);
        return reportColumn;
    }

    public static DataSet getReportDataSetExt(DataSet dataSet, ReportQueryParam queryParam) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.reportDataSetExt");
        List resultList = pluginProxy.callReplace(p -> p.reportDataSetExt(dataSet, queryParam));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IBankAcctInterface.reportDataSetExt \u4e0d\u4e3a\u7a7a");
            return (DataSet)resultList.get(0);
        }
        logger.info("IBankAcctInterface.reportDataSetExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return dataSet;
    }

    private static List<AbstractReportColumn> getReportColumnsExt(List<AbstractReportColumn> reportColumns) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.reportColumnsExt");
        List resultList = pluginProxy.callReplace(p -> p.reportColumnsExt(reportColumns));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IBankAcctInterface.reportColumnsExt \u8fd4\u56de\u7ed3\u679c\u62a5\u8868\u5217\u6570:" + ((List)resultList.get(0)).size());
            return (List)resultList.get(0);
        }
        logger.info("IBankAcctInterface.reportColumnsExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return reportColumns;
    }
}

