/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctByTypeDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ACCT_TYPE = "accttype";
    private static final String TYPE_PREFIX = "type_";
    private static final String TYPE_TOTAL = "type_total";
    private List<String> COUNT_FIELDS = new ArrayList<String>(10);

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] configSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        bankAcctSet = configSets[0].union(BankAcctHelper.getUnBankAcctSet(configSets));
        DataSet dataSet = bankAcctSet.select(new String[]{"org", "acctstyle as accttype"});
        if ((dataSet = dataSet.filter("accttype != null and accttype != ''")).isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(new String[]{"org", ACCT_TYPE, "count"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.IntegerType});
        }
        return dataSet.groupBy(new String[]{"org", ACCT_TYPE}).count().finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        DataSet changeRowToColDataSet = DecisionAnlsHelper.ChangeRowToColDataSet(ds, ACCT_TYPE, "org", TYPE_PREFIX);
        List<String> countFields = Arrays.stream(changeRowToColDataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(TYPE_PREFIX)).collect(Collectors.toList());
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDs = orgDateSet.leftJoin(changeRowToColDataSet).on("rowid", "org").select(new String[]{"orgid", "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, "orgid,mixorgname,sortcode");
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumDataSet = sumDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = DecisionAnlsHelper.removeNoDataTreeDs(sumDataSet, countFields, false);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, countFields, "mixorgname");
        List<String> zeroColNames = BankAcctHelper.getZeroColNames(totalDataSet, countFields);
        DataSet resultSet = sumDataSet.union(totalDataSet);
        if (EmptyUtil.isNoEmpty(zeroColNames)) {
            resultSet = resultSet.removeFields(zeroColNames.toArray(new String[0]));
        }
        this.COUNT_FIELDS = Arrays.stream(resultSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(TYPE_PREFIX)).collect(Collectors.toList());
        resultSet = resultSet.addField(String.join((CharSequence)"+", this.COUNT_FIELDS), TYPE_TOTAL);
        this.COUNT_FIELDS.add(TYPE_TOTAL);
        return resultSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map<String, ValueMapItem> acctTypeEnum = BankAcctHelper.getEnumItemsByProperty("acctstyle");
        this.COUNT_FIELDS.stream().forEach(fieldName -> {
            String caption = "";
            if (TYPE_TOTAL.equals(fieldName)) {
                caption = ResManager.loadKDString((String)"\u8d26\u6237\u5408\u8ba1", (String)"BankAcctByTypeDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
            } else {
                String s = fieldName.substring(TYPE_PREFIX.length());
                ValueMapItem valueMapItem = (ValueMapItem)acctTypeEnum.get(s);
                if (valueMapItem != null) {
                    caption = valueMapItem.getName().getLocaleValue();
                }
            }
            columns.add((AbstractReportColumn)this.createColumn((String)fieldName, caption));
        });
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(0);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        return reportColumn;
    }
}

