/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.StringUtils;

public class BankAcctByUsageDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ONE_LEVEL_USAGE_ID = "onelevelId";
    private static final String USAGE_PREFIX = "usage_";
    private static final String USAGE_TOTAL = "usage_total";
    private List<String> COUNT_FIELDS = new ArrayList<String>();
    Map<String, String> usageNumberToIdMap;
    Map<String, String> usageIdToNameMap;

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] configSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        bankAcctSet = configSets[0].union(BankAcctHelper.getUnBankAcctSet(configSets));
        DataSet dataSet = bankAcctSet.select(new String[]{"id", "org", "acctusageid", "usagelongnumber"});
        if ((dataSet = dataSet.filter("usagelongnumber != null and usagelongnumber != ''")).isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(new String[]{"org", ONE_LEVEL_USAGE_ID, "count"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.IntegerType});
        }
        dataSet = dataSet.addField("'0'", ONE_LEVEL_USAGE_ID);
        dataSet = this.dealUsageNumber(dataSet);
        return dataSet.groupBy(new String[]{"org", ONE_LEVEL_USAGE_ID}).count().finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        DataSet changeRowToColDataSet = DecisionAnlsHelper.ChangeRowToColDataSet(ds, ONE_LEVEL_USAGE_ID, "org", USAGE_PREFIX);
        List<String> countFields = Arrays.stream(changeRowToColDataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(USAGE_PREFIX)).collect(Collectors.toList());
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDs = orgDateSet.leftJoin(changeRowToColDataSet).on("rowid", "org").select(new String[]{"orgid", "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, "orgid,mixorgname,sortcode");
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumDataSet = sumDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = DecisionAnlsHelper.removeNoDataTreeDs(sumDataSet, countFields, false);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, countFields, "mixorgname");
        List<String> zeroColNames = BankAcctHelper.getZeroColNames(totalDataSet, countFields);
        DataSet resultSet = sumDataSet.union(totalDataSet);
        if (EmptyUtil.isNoEmpty(zeroColNames)) {
            resultSet = resultSet.removeFields(zeroColNames.toArray(new String[0]));
        }
        this.COUNT_FIELDS = Arrays.stream(resultSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(USAGE_PREFIX)).collect(Collectors.toList());
        resultSet = resultSet.addField(String.join((CharSequence)"+", this.COUNT_FIELDS), USAGE_TOTAL);
        this.COUNT_FIELDS.add(USAGE_TOTAL);
        return resultSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (this.usageIdToNameMap == null) {
            this.initUsageMapForOneLevel();
        }
        int otherIndex = columns.size();
        int totalIndex = columns.size();
        for (int i = 0; i < this.COUNT_FIELDS.size(); ++i) {
            String fieldName = this.COUNT_FIELDS.get(i);
            String caption = this.usageIdToNameMap.get(fieldName);
            if ("usage_0".equals(fieldName)) {
                caption = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"BankAcctByUsageDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
                otherIndex += i;
            }
            if (USAGE_TOTAL.equals(fieldName)) {
                caption = ResManager.loadKDString((String)"\u8d26\u6237\u5408\u8ba1", (String)"BankAcctByTypeDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
                totalIndex += i;
            }
            columns.add((AbstractReportColumn)this.createColumn(fieldName, caption));
        }
        ReportColumn otherColumn = (ReportColumn)columns.get(otherIndex);
        columns.set(otherIndex, columns.get(totalIndex - 1));
        columns.set(totalIndex - 1, (AbstractReportColumn)otherColumn);
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(0);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        return reportColumn;
    }

    private DataSet dealUsageNumber(DataSet dataSet) {
        this.initUsageMapForOneLevel();
        if (EmptyUtil.isEmpty(this.usageNumberToIdMap)) {
            return dataSet;
        }
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String usageLongNumber = row.getString("usagelongnumber");
                String[] s = usageLongNumber.split("\\.");
                int usageNumberIndex = rowMeta.getFieldIndex(BankAcctByUsageDataListPlugin.ONE_LEVEL_USAGE_ID, false);
                String oneLevelUsageId = BankAcctByUsageDataListPlugin.this.usageNumberToIdMap.get(s[0]);
                if (EmptyUtil.isNoEmpty((String)oneLevelUsageId)) {
                    data[usageNumberIndex] = BankAcctByUsageDataListPlugin.this.usageNumberToIdMap.get(s[0]);
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private void initUsageMapForOneLevel() {
        Map queryUsages = BusinessDataServiceHelper.loadFromCache((String)"bd_acctpurpose", (String)String.join((CharSequence)",", "id", "longnumber", "name"), (QFilter[])new QFilter[]{new QFilter("level", "=", (Object)1)});
        this.usageNumberToIdMap = queryUsages.values().stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("longnumber"), dynamicObject -> dynamicObject.getString("id"), (v1, v2) -> v1));
        this.usageIdToNameMap = queryUsages.values().stream().collect(Collectors.toMap(dynamicObject -> USAGE_PREFIX + dynamicObject.getString("id"), dynamicObject -> dynamicObject.getString("name")));
    }
}

