/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.bankacct.data.AcctDetailDataListPlugin;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class DormanAcctDetailPlugin
extends AcctDetailDataListPlugin {
    private static final String CHANGE_DATE = "changedate";

    @Override
    protected List<Object[]> getColumnItems() {
        List<Object[]> columnItems = super.getColumnItems();
        columnItems.add(new Object[]{CHANGE_DATE, ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f", (String)"AcctDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        return columnItems;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = DecisionAnlsHelper.dormantDataSet(orgIds, queryDate);
        Set accountIds = DecisionCommonHelper.getFieldValues((DataSet)allDs, (String)"id", Long.class);
        DataSet ds = BankAcctHelper.queryAccountSet(new QFilter("id", "in", (Object)accountIds).toArray());
        DataSet changeDs = this.queryAccountChange(paramMap, accountIds);
        changeDs = this.accountChangeFilter(changeDs);
        ds = this.join(ds, changeDs);
        ds = ds.addFields(new String[]{"org", "org_name", "case when bankinterface = 'bi_true' then 'true' else 'false' end", "1"}, new String[]{"company", "orgname", "isbankinterface", "acctcount"});
        return this.updateFields(ds, paramMap);
    }

    private DataSet queryAccountChange(Map<String, Object> paramMap, Set<Long> accountIds) {
        Date queryDate = DateUtils.getNextDay((Date)DecisionAnlsHelper.getQueryDate(paramMap), (int)1);
        QFilter filter = new QFilter("applydate", "<", (Object)queryDate).and("entryentity2.e_accountbank", "in", accountIds);
        return QueryServiceHelper.queryDataSet((String)"BankAcctSum-change", (String)"am_changeapply", (String)"entryentity2.e_accountbank accountid,auditdate changedate", (QFilter[])filter.toArray(), (String)"auditdate DESC");
    }

    private DataSet accountChangeFilter(DataSet ds) {
        HashSet<Long> accountIds = new HashSet<Long>(1024);
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(ds.getRowMeta());
        while (ds.hasNext()) {
            Row row = ds.next();
            Long accountId = row.getLong("accountid");
            if (!accountIds.add(accountId)) continue;
            dataSetBuilder.append(row);
        }
        return dataSetBuilder.build();
    }

    private DataSet join(DataSet ds, DataSet changeDs) {
        return ds.leftJoin(changeDs).on("id", "accountid").select(ds.getRowMeta().getFieldNames(), new String[]{CHANGE_DATE}).finish();
    }
}

