/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.util.CollectionUtils;
import kd.sdk.tmc.tda.extpoint.bankacct.IParentAcctInterface;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.bankacct.extpoint.ParentAcctDefaultExt;
import kd.tmc.tda.report.common.helper.AbstractDecisionDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundConcentrationDataHelper
extends AbstractDecisionDataHelper {
    private static final String COMPANY = "company";
    private static final String COMPANYNAME = "companyname";
    private static final String AMOUNT = "amount";
    private static final String VALIBALANCE = "valibalance";
    private static final String REALRESTRICTEDAMT = "realrestrictedamt";
    private static final String OFFSETAMOUNT = "offsetamount";
    private static final String OFFSETVALIBALANCE = "offsetvalibalance";
    private static final String OFFSETREALRESTRICTEDAMT = "offsetrealrestrictedamt";
    private static final String FINANCILAMOUNT = "financilamount";
    private static final String ACCTGROUPAMOUNT = "acctgroupamount";
    private static final String SUBTOTALAMOUNT = "subtotalamount";
    private static final String ORGID = "orgid";
    private static final String ROWID = "rowid";
    private static final String ORGNAME = "orgname";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String ISDOMESTIC = "isdomestic";
    private static final String CLICK = "click";
    private static final String[] SELECT_FIELDS = new String[]{"company", "companyname", "finorgtype", "accountbank", "fundtype", "amount", "realvalibalance", "realrestrictedamt", "isoffset", "isdomestic", "acctproperty", "businessunit"};
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("amount", "valibalance", "realrestrictedamt", "financilamount", "acctgroupamount", "subtotalamount");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet queryDataSetFromDb(Map<String, Object> paramMap, String algoKey) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet fundBalance = null;
        DataSet parentBalance = null;
        try {
            parentBalance = CashFundsDataHelper.getFundDataSet((String)algoKey, (List)orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)false);
            parentBalance = parentBalance.select(SELECT_FIELDS);
            fundBalance = CashFundsDataHelper.getFundConcentrateDs((DataSet)parentBalance.copy(), (List)orgIds);
            DataSet amountDs = fundBalance.copy().groupBy(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC}).sum(AMOUNT).sum("realvalibalance").sum(REALRESTRICTEDAMT).finish();
            DataSet amountOffSetDs = fundBalance.copy().filter("isoffset = '1' ").groupBy(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC}).sum(AMOUNT).sum("realvalibalance").sum(REALRESTRICTEDAMT).finish().select("company,companyname,isdomestic,amount as offsetamount, realvalibalance as offsetvalibalance, realrestrictedamt as offsetrealrestrictedamt");
            DataSet financialDs = fundBalance.filter("finorgtype = '3'").select("company,companyname,isdomestic,amount as financilamount").groupBy(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC}).sum(FINANCILAMOUNT).finish();
            List<Long> acctIds = this.getParentAcctIdsByExtPoint(paramMap);
            DataSet acctDs = !acctIds.isEmpty() ? parentBalance.filter("finorgtype != '3' and fundtype = 0 and accountbank in acctIds", Collections.singletonMap("acctIds", acctIds)).select("company,companyname,isdomestic,amount as acctgroupamount").groupBy(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC}).sum(ACCTGROUPAMOUNT).finish() : DecisionAnlsHelper.createEmptyDataSet(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC, ACCTGROUPAMOUNT}, new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.BigDecimalType});
            DataSet resultDs = amountDs.leftJoin(financialDs).on(COMPANY, COMPANY).on(ISDOMESTIC, ISDOMESTIC).select(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC, AMOUNT, "realvalibalance as valibalance", REALRESTRICTEDAMT, FINANCILAMOUNT}).finish().leftJoin(amountOffSetDs).on(COMPANY, COMPANY).on(ISDOMESTIC, ISDOMESTIC).select(new String[]{COMPANY, COMPANYNAME, ISDOMESTIC, AMOUNT, VALIBALANCE, REALRESTRICTEDAMT, FINANCILAMOUNT, OFFSETAMOUNT, OFFSETVALIBALANCE, OFFSETREALRESTRICTEDAMT}).finish().leftJoin(acctDs).on(COMPANY, COMPANY).on(ISDOMESTIC, ISDOMESTIC).select(new String[]{"company as orgid", "companyname as orgname", ISDOMESTIC, AMOUNT, VALIBALANCE, REALRESTRICTEDAMT, OFFSETAMOUNT, OFFSETVALIBALANCE, OFFSETREALRESTRICTEDAMT, FINANCILAMOUNT, ACCTGROUPAMOUNT}).finish();
            DataSet dataSet = resultDs = resultDs.addField("financilamount + acctgroupamount", SUBTOTALAMOUNT);
            return dataSet;
        }
        finally {
            if (fundBalance != null) {
                fundBalance.close();
            }
            if (parentBalance != null) {
                parentBalance.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        if (ds.isEmpty()) {
            if (!Arrays.asList(ds.getRowMeta().getFieldNames()).contains("sumlevel")) {
                ds = ds.addField("0", "sumlevel");
            }
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta());
        }
        DataSet sDataSet = null;
        DataSet orgDateSet = null;
        DataSet sumDataSet = null;
        try {
            Map<String, Object> paramMap = this.transQueryParam(queryParam);
            int areaNum = (Integer)paramMap.get(CLICK);
            ds = this.getSourceDsByChoice(ds, areaNum);
            Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
            orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
            List<String> fieldList = this.getOrgFieldList();
            fieldList.addAll(AMOUNT_FIELDS);
            String[] selectFields = fieldList.toArray(new String[fieldList.size()]);
            DataSet leftJoinBankDataSet = orgDateSet.copy().leftJoin(ds.copy()).on(ORGID, ORGID).select(selectFields).finish();
            DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
            sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, AMOUNT_FIELDS, "orgname,sortcode");
            List subOrgIds = (List)paramMap.get("suborgids");
            sumDataSet = CollectionUtils.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid = " + ((DynamicObject)parentOrgs.get(0)).getString("id")) : sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds));
            sumDataSet = sumDataSet.addField(ROWID, ORGID).addField(ORGNAME, "mixorgname").orderBy(new String[]{"sortcode"});
            DataSet offsetDs = ds.updateField(ORGID, ((DynamicObject)parentOrgs.get(0)).getString("id")).groupBy(new String[]{ORGID}).sum(OFFSETAMOUNT).sum(OFFSETVALIBALANCE).sum(OFFSETREALRESTRICTEDAMT).finish().select("orgid,offsetamount as amount, offsetvalibalance as valibalance, offsetrealrestrictedamt as realrestrictedamt");
            offsetDs = offsetDs.addFields(new String[]{"0.0", "0.0", "0.0"}, new String[]{FINANCILAMOUNT, ACCTGROUPAMOUNT, SUBTOTALAMOUNT});
            offsetDs = offsetDs.leftJoin(orgDateSet).on(ORGID, ORGID).select(selectFields).finish();
            offsetDs = offsetDs.updateField(AMOUNT, "amount * (-1)").updateField(VALIBALANCE, "valibalance * (-1)").updateField(REALRESTRICTEDAMT, "realrestrictedamt* (-1)").updateField(ORGNAME, '\'' + this.getFinorgtype() + '\'').updateField("sumlevel", "0").updateField(ISGROUPNODE, "'0'");
            DataSet resultSet = sumDataSet.select(selectFields).union(offsetDs);
            String statName = '\'' + ((DynamicObject)parentOrgs.get(0)).getString("name") + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CashTotalAmountQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]) + '\'';
            sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, AMOUNT_FIELDS, ORGNAME).updateField(ORGNAME, statName);
            resultSet = resultSet.union(sDataSet);
            DataSet dataSet = resultSet = resultSet.addFields(new String[]{"case when amount =0 then 0 else (subtotalamount/amount)*100 end", "case when valibalance = 0 then 0 else (subtotalamount/valibalance)*100 end"}, new String[]{"fullfundcollection", "valifundcollection"});
            return dataSet;
        }
        finally {
            if (orgDateSet != null) {
                orgDateSet.close();
            }
            if (sumDataSet != null) {
                sumDataSet.close();
            }
            if (sDataSet != null) {
                sDataSet.close();
            }
        }
    }

    private List<String> getOrgFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(10);
        fieldList.add("mixorgname orgname");
        fieldList.add("0 sumlevel");
        fieldList.add(ORGID);
        fieldList.add("pid");
        fieldList.add("level");
        fieldList.add(ISGROUPNODE);
        fieldList.add(ROWID);
        fieldList.add("sortcode");
        return fieldList;
    }

    private String getFinorgtype() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashTotalAmountQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private List<Long> getParentAcctIdsByExtPoint(Map<String, Object> param) {
        ParentAcctDefaultExt interfaceAcct = new ParentAcctDefaultExt();
        PluginProxy pluginProxy = PluginProxy.create((Object)interfaceAcct, IParentAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.parentAcct", null);
        List result = pluginProxy.callReplaceIfPresent(p -> p.getParentAcct(param));
        return (List)result.get(0);
    }

    private DataSet getSourceDsByChoice(DataSet allDs, int areaNum) {
        if (areaNum == 0) {
            GroupbyDataSet groupbyDataSet = allDs.groupBy(new String[]{ORGID, ORGNAME});
            for (String amountField : AMOUNT_FIELDS) {
                groupbyDataSet.sum(amountField);
            }
            allDs = groupbyDataSet.sum(OFFSETAMOUNT).sum(OFFSETVALIBALANCE).sum(OFFSETREALRESTRICTEDAMT).finish();
        } else if (areaNum == 1) {
            allDs = allDs.filter("isdomestic = '1'").removeFields(new String[]{ISDOMESTIC});
        } else if (areaNum == 2) {
            allDs = allDs.filter("isdomestic = '0'").removeFields(new String[]{ISDOMESTIC});
        }
        return allDs;
    }
}

