/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BankAcctByChangeDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ACCT_OP_TYPE = "acctoptype";
    private static final String ACCT_OP_ORDER = "acctoporder";
    private List<String> ACCT_COLS = Arrays.asList("bankcate_" + TdaFinOrgTypeEnum.BANK.getValue(), "bankcate_" + TdaFinOrgTypeEnum.CLEARINGHOUSE.getValue(), "bankcate_" + TdaFinOrgTypeEnum.FINCOMP.getValue(), "bankcate_" + TdaFinOrgTypeEnum.TRDPARTPAY.getValue(), "bankcate_" + TdaFinOrgTypeEnum.OTHERACCT.getValue());
    private static Map<String, String> opMap = new HashMap<String, String>(){
        {
            this.put("1", ResManager.loadKDString((String)"\u8d26\u6237\u5f00\u6237", (String)"BankAcctByChangeDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("2", ResManager.loadKDString((String)"\u8d26\u6237\u53d8\u66f4", (String)"BankAcctByChangeDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"\u8d26\u6237\u9500\u6237", (String)"BankAcctByChangeDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
    };

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{ACCT_OP_TYPE, ResManager.loadKDString((String)"\u8d26\u6237\u64cd\u4f5c\u7c7b\u578b", (String)"BankAcctByChangeDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{ACCT_OP_ORDER, ResManager.loadKDString((String)"\u8d26\u6237\u64cd\u4f5c\u987a\u5e8f", (String)"BankAcctByChangeDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"dateRange", ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"BankAcctByChangeDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{this.ACCT_COLS.get(0), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BankAcctByChangeDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.ACCT_COLS.get(2), ResManager.loadKDString((String)"\u8d22\u53f8\u8d26\u6237", (String)"BankAcctByChangeDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.ACCT_COLS.get(1), ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"AcctDisplayByBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.ACCT_COLS.get(3), ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8d26\u6237", (String)"AcctDisplayByBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.ACCT_COLS.get(4), ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"AcctDisplayByBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"CashBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Object> dateRangeMap = BankAcctHelper.getDateRangeMap(queryDate);
        DataSet bankAcctSet = BankAcctHelper.queryUncloseacct(((Object)((Object)this)).getClass().getName(), paramMap).filter("opendate != NULL AND opendate < querydate AND opendate >= minDate", dateRangeMap).select(new String[]{"id", "finorgtype", "opendate", "closedate"});
        DataSet[] bankAcctSets = bankAcctSet.splitByFilter(new String[]{"true", "true", "true"}, false);
        DataSet acctOpenSet = bankAcctSets[0].select(new String[]{"finorgtype", "opendate as opDate"}).addFields(new String[]{"1", ResManager.loadKDString((String)"'\u8d26\u6237\u5f00\u6237'", (String)"BankAcctByChangeDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{ACCT_OP_ORDER, ACCT_OP_TYPE});
        DataSet acctCloseSet = bankAcctSets[1].filter("closedate != NULL AND closedate < querydate AND closedate >= minDate", dateRangeMap).select(new String[]{"finorgtype", "closedate as opDate"}).addFields(new String[]{"3", ResManager.loadKDString((String)"'\u8d26\u6237\u9500\u6237'", (String)"BankAcctByChangeDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{ACCT_OP_ORDER, ACCT_OP_TYPE});
        DataSet acctChangeSet = BankAcctHelper.getAcctChangeSet(paramMap);
        acctChangeSet = acctChangeSet.leftJoin(bankAcctSets[2]).on("accountid", "id").select(new String[]{"auditdate as opDate"}, new String[]{"id as accountid", "finorgtype"}).finish().filter("accountid is not null").select(new String[]{"finorgtype", "opDate"}).addFields(new String[]{"2", ResManager.loadKDString((String)"'\u8d26\u6237\u53d8\u66f4'", (String)"BankAcctByChangeDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{ACCT_OP_ORDER, ACCT_OP_TYPE});
        DataSet union = acctOpenSet.union(new DataSet[]{acctCloseSet, acctChangeSet});
        DataSet[] acctSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(union);
        union = acctSets[0].union(BankAcctHelper.getUnBankAcctSet(acctSets));
        DataSet result = this.getDateRangeSet(dateRangeMap, union);
        result = this.addAbsentRow(result, dateRangeMap);
        return result.orderBy(new String[]{ACCT_OP_ORDER});
    }

    private DataSet getDateRangeSet(Map<String, Object> dateRangeMap, DataSet union) {
        DataSet[] splitsSet = BankAcctHelper.getDateRangeDataSets(union, dateRangeMap);
        DataSet result = null;
        List dateList = dateRangeMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        for (int i = 0; i < splitsSet.length; ++i) {
            DataSet splitSet = splitsSet[i].select(new String[]{ACCT_OP_TYPE, ACCT_OP_ORDER, "finorgtype"}).groupBy(new String[]{ACCT_OP_TYPE, ACCT_OP_ORDER, "finorgtype"}).count().finish().addField("'" + (String)dateList.get(i) + "'", "dateRange");
            result = result == null ? splitSet : result.union(splitSet);
        }
        result = DecisionAnlsHelper.ChangeRowToColDataSet(result, "finorgtype", String.join((CharSequence)",", ACCT_OP_TYPE, ACCT_OP_ORDER, "dateRange"), "bankcate_");
        result = DecisionAnlsHelper.addAbsentFields(result, this.ACCT_COLS);
        return DecisionAnlsHelper.updateValueWhenNull(result, this.ACCT_COLS);
    }

    private DataSet addAbsentRow(DataSet dataSet, Map<String, Object> dateRangeMap) {
        List dateSubList = dateRangeMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()).subList(0, 4);
        ArrayList opDateRanges = new ArrayList(16);
        opMap.forEach((opOrder, opType) -> dateSubList.forEach(dateRange -> opDateRanges.add(Pair.of((Object)opOrder, (Object)dateRange))));
        ArrayList<String> exitKeys = new ArrayList<String>(16);
        for (Row next : dataSet.copy()) {
            String opOrder2 = next.getString(ACCT_OP_ORDER);
            String dateRange = next.getString("dateRange");
            exitKeys.add(opOrder2 + "_" + dateRange);
        }
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        RowMeta rowMeta = dataSet.getRowMeta();
        opDateRanges.forEach(pair -> {
            String opOrder = (String)pair.getLeft();
            String dateRange = (String)pair.getRight();
            if (!exitKeys.contains(opOrder + "_" + dateRange)) {
                collection.add(new Object[]{opMap.get(opOrder), opOrder, dateRange, "0", "0", "0", "0", "0"});
            }
        });
        if (EmptyUtil.isNoEmpty(collection)) {
            DataSet createRows = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), collection);
            dataSet = dataSet.union(createRows);
        }
        return dataSet;
    }

    @Override
    protected List<String> getLinkReport() {
        List<String> objects = Collections.singletonList("tda_acctbankchangerpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "dateRange";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankchangerpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u53d8\u52a8\u5206\u6790\u8868", (String)"BankAcctByChangeDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        showParameter.getCustomParams().put("dateRange", ids.get(0));
        this.fireLinkageShowForm(view, showParameter);
    }
}

