/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctByTypeDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ACCT_TYPE = "accttype";
    private static final String ACCT_COUNT = "acctcount";
    private static final int TOP_NUM = 6;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{ACCT_TYPE, ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"BankAcctByTypeDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{ACCT_COUNT, ResManager.loadKDString((String)"\u5206\u5e03\u6570\u91cf", (String)"BankAcctByUsageDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"AcctDisplayByBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] configSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        bankAcctSet = configSets[0].union(BankAcctHelper.getUnBankAcctSet(configSets));
        bankAcctSet = bankAcctSet.select("acctstyle as accttype");
        DataSet dataSet = bankAcctSet.filter("accttype != null and accttype != ''");
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        dataSet = this.dealAcctTypes(dataSet);
        dataSet = dataSet.groupBy(new String[]{ACCT_TYPE}).count(ACCT_COUNT).finish();
        dataSet = dataSet.updateField(ACCT_TYPE, "case when accttype is null or accttype='' then ' ' else accttype end");
        List<String> acctstyles = BankAcctHelper.getEnumItemsByProperty("acctstyle").values().stream().map(valueMapItem -> valueMapItem.getName().getLocaleValue()).collect(Collectors.toList());
        DataSet result = DecisionAnlsHelper.creatAbsentRow(dataSet, ACCT_TYPE, acctstyles, 0, () -> new Object[]{"", "0"});
        return this.genTopSet(result);
    }

    private DataSet genTopSet(DataSet result) {
        result = result.orderBy(new String[]{"acctcount desc"}).addBalanceField("1", "qingsort");
        DataSet[] resultSplit = result.splitByFilter(new String[]{"qingsort <= 6", "qingsort > 6"}, false);
        DataSet resultSet = resultSplit[0].select(new String[]{ACCT_TYPE, ACCT_COUNT, "qingsort"});
        if (!resultSplit[1].isEmpty()) {
            DataSet otherSet = resultSplit[1].groupBy().sum(ACCT_COUNT).min("qingsort").finish();
            otherSet = otherSet.select(new String[]{String.format("%s as accttype", ResManager.loadKDString((String)"'\u5176\u4ed6'", (String)"BankAcctByUsageDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])), ACCT_COUNT, "qingsort"});
            resultSet = resultSet.union(otherSet);
        }
        return resultSet;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbanktyperpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ACCT_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbanktyperpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b\u5206\u5e03\u8868", (String)"BankAcctByTypeDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    private DataSet dealAcctTypes(DataSet dataSet) {
        final Map<String, ValueMapItem> acctTypeEnum = BankAcctHelper.getEnumItemsByProperty("acctstyle");
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String acctType = row.getString(BankAcctByTypeDataPlugin.ACCT_TYPE);
                int acctTypeIndex = rowMeta.getFieldIndex(BankAcctByTypeDataPlugin.ACCT_TYPE, false);
                ValueMapItem valueMapItem = (ValueMapItem)acctTypeEnum.get(acctType);
                String typeName = "";
                if (valueMapItem != null) {
                    typeName = valueMapItem.getName().getLocaleValue();
                }
                data[acctTypeIndex] = typeName;
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }
}

