/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.StringUtils;

public class BankAcctByUsageDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ACCT_USAGE = "acctusage";
    private static final String ACCT_COUNT = "acctcount";
    private static final int TOP_NUM = 6;
    private static final String ONE_LEVEL_USAGE_NUMBER = "onelevelnumber";
    private Map<String, String> usageMap;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{ACCT_USAGE, ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"BankAcctByUsageDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{ACCT_COUNT, ResManager.loadKDString((String)"\u5206\u5e03\u6570\u91cf", (String)"BankAcctByUsageDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"AcctDisplayByBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] configSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        bankAcctSet = configSets[0].union(BankAcctHelper.getUnBankAcctSet(configSets));
        bankAcctSet = bankAcctSet.select("usagelongnumber");
        DataSet dataSet = bankAcctSet.filter("usagelongnumber != null and usagelongnumber != ''");
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        dataSet = dataSet.addFields(new String[]{"'0'", "''"}, new String[]{ONE_LEVEL_USAGE_NUMBER, ACCT_USAGE});
        dataSet = this.dealUsageNumber(dataSet);
        DataSet result = dataSet.groupBy(new String[]{ONE_LEVEL_USAGE_NUMBER, ACCT_USAGE}).count(ACCT_COUNT).finish();
        if (EmptyUtil.isNoEmpty(this.usageMap)) {
            result = DecisionAnlsHelper.creatAbsentRow(result, ACCT_USAGE, this.usageMap.values().stream().collect(Collectors.toList()), 1, () -> new Object[]{"", "''", "0"});
        }
        return this.genTopSet(result);
    }

    private DataSet genTopSet(DataSet result) {
        result = result.orderBy(new String[]{"acctcount desc"}).addBalanceField("1", "qingsort");
        DataSet[] resultSplit = result.splitByFilter(new String[]{"qingsort <= 6", "qingsort > 6"}, false);
        DataSet resultSet = resultSplit[0].select(new String[]{ACCT_USAGE, ACCT_COUNT, "qingsort"});
        if (!resultSplit[1].isEmpty()) {
            DataSet otherSet = resultSplit[1].groupBy().sum(ACCT_COUNT).min("qingsort").finish();
            otherSet = otherSet.select(new String[]{String.format("%s as acctusage", ResManager.loadKDString((String)"'\u5176\u4ed6'", (String)"BankAcctByUsageDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])), ACCT_COUNT, "qingsort"});
            resultSet = resultSet.union(otherSet);
        }
        return resultSet;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbankusagerpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ACCT_USAGE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankusagerpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014\u5206\u5e03\u8868", (String)"BankAcctByUsageDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    private DataSet dealUsageNumber(DataSet dataSet) {
        Map queryUsages = BusinessDataServiceHelper.loadFromCache((String)"bd_acctpurpose", (String)String.join((CharSequence)",", "id", "longnumber", "name"), (QFilter[])new QFilter[]{new QFilter("level", "=", (Object)1)});
        this.usageMap = queryUsages.values().stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("longnumber"), dynamicObject -> dynamicObject.getString("name"), (v1, v2) -> v1));
        if (EmptyUtil.isEmpty(this.usageMap)) {
            return dataSet;
        }
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String usageLongNumber = row.getString("usagelongnumber");
                String[] s = usageLongNumber.split("\\.");
                int usageNumberIndex = rowMeta.getFieldIndex(BankAcctByUsageDataPlugin.ONE_LEVEL_USAGE_NUMBER, false);
                data[usageNumberIndex] = s[0];
                int acctUsageIndex = rowMeta.getFieldIndex(BankAcctByUsageDataPlugin.ACCT_USAGE, false);
                data[acctUsageIndex] = BankAcctByUsageDataPlugin.this.usageMap.get(s[0]);
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }
}

