/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;

public class BankAcctDistSumDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"company.name", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"BankAcctDistSumDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"openorg.name", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"BankAcctDistSumDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"name", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u540d\u79f0", (String)"BankAcctDistSumDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BankAcctDistSumDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"finorginfo", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"BankAcctDistSumDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"finorgtype", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784\u7c7b\u578b", (String)"BankAcctDistSumDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"BankAcctDistSumDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ccode", ResManager.loadKDString((String)"\u5883\u5185\u5916", (String)"BankAcctDistSumDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"issetbankinterface", ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"BankAcctDistSumDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        QFilter fi = new QFilter("org.id", "in", orgIdSet);
        String bankAcctSic = "number, name, bankaccountnumber, acctstatus, company.id, company.name, openorg.id, openorg.name, opendate, bank.id, acctstyle, issetbankinterface";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])fi.toArray(), null);
        DataSet bankIdSet = bankAcctSet.copy().groupBy(new String[]{"bank.id"}).finish();
        HashSet<Long> idSet = new HashSet<Long>();
        for (Row row : bankIdSet) {
            idSet.add(row.getLong("bank.id"));
        }
        String finOrgSic = "id, name finorginfo, country.name country, country.twocountrycode ccode, finorgtype.type finorgtype";
        QFilter filter = new QFilter("id", "in", idSet);
        DataSet bankSet = QueryServiceHelper.queryDataSet((String)"FinOrgInfo", (String)"bd_finorginfo", (String)finOrgSic, (QFilter[])filter.toArray(), null);
        return bankAcctSet.join(bankSet).on("bank.id", "id").select(new String[]{"name", "bankaccountnumber", "acctstatus", "company.name", "country", "ccode", "openorg.name", "opendate", "acctstyle", "issetbankinterface", "finorginfo", "finorgtype"}).finish();
    }

    @Override
    protected Object translateCellDisplay(String field, Object value, Row rs) {
        switch (field) {
            case "ccode": {
                if ("CN".equals(value)) {
                    value = AcctDisplayByBankTypeEnum.DOMESTIC.getName();
                    break;
                }
                value = AcctDisplayByBankTypeEnum.OVERSEAS.getName();
                break;
            }
            case "acctstyle": {
                value = AcctStyleEnum.getName((String)((String)value));
                break;
            }
            case "issetbankinterface": {
                value = Boolean.TRUE.equals(value) ? ResManager.loadKDString((String)"\u94f6\u4f01", (String)"BankAcctDistSumDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u94f6\u4f01", (String)"BankAcctDistSumDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]);
            }
        }
        return value;
    }
}

