/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class DormantDataQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ORGNAME = "orgname";
    private static final String SIMPLENAME = "simplename";
    private static final String ACCTCOUNT = "acctcount";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{ORGNAME, ResManager.loadKDString((String)"\u4e8c\u7ea7\u5355\u4f4d", (String)"DormantDataQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{SIMPLENAME, ResManager.loadKDString((String)"\u4e8c\u7ea7\u5355\u4f4d\u7b80\u79f0", (String)"DormantDataQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{ACCTCOUNT, ResManager.loadKDString((String)"\u8d26\u6237\u6570\u91cf", (String)"DormantDataQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_seconddormancyrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ORGNAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_seconddormancyrpt");
        this.fireLinkageShowForm(view, param);
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgid = ((DynamicObject)paramMap.get("org")).getLong("id");
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet detailDataSet = DecisionAnlsHelper.getAcctByOrgIdAndDate(orgIds, queryDate, orgview);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgview, (Long)orgid, (boolean)true);
        if (!EmptyUtil.isEmpty((Collection)secondOrgIds)) {
            detailDataSet = detailDataSet.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds));
        } else {
            Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
            detailDataSet = detailDataSet.filter("rowid = id", Collections.singletonMap("id", orgId));
        }
        return detailDataSet.orderBy(new String[]{"acctcount desc"});
    }
}

