/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundConcentrationQingPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String FUNDCONCENTRATION = "fundConcentration";
    private static final String FUNDTYPE = "fundType";
    private static final String FUND_TYPE_NUM = "fundTypeNum";
    private static final String AREA = "area";
    private static final String AREA_NUM = "area_num";
    private static final String AREANUMBER = "areanumber";
    private static final String COLLECTAMOUNT = "collectamount";
    private static final String FINANCEAMOUNT = "financeamount";
    private static final String COMPANYAMOUNT = "companyamount";
    private static final String AMOUNT = "amount";
    private static final String COLLECTABLEAMOUNT = "collectableamount";
    private static final String ISDOMESTIC = "isdomestic";
    private static final String COLLECTABLERATE = "collectablerate";
    private static final String ALLRATE = "allrate";
    private static String[] newFieldNames = new String[]{"fundConcentration", "fundType", "fundTypeNum", "area", "area_num"};
    private static DataType[] newDataTypes = new DataType[]{DataType.BigDecimalType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.IntegerType};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{FUNDCONCENTRATION, ResManager.loadKDString((String)"\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundConcentrationQingPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{FUNDTYPE, ResManager.loadKDString((String)"\u8d44\u91d1\u7c7b\u578b", (String)"FundConcentrationQingPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FUND_TYPE_NUM, ResManager.loadKDString((String)"\u8d44\u91d1\u7c7b\u578b\u7f16\u7801", (String)"FundConcentrationQingPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AREA, ResManager.loadKDString((String)"\u533a\u57df", (String)"FundConcentrationQingPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AREA_NUM, ResManager.loadKDString((String)"\u533a\u57df\u7f16\u7801", (String)"FundConcentrationQingPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        DataSet fundCcrAnlsByPointDataSet = CashConcentrationDataHelper.getFundDataSet("FundCcrAnlsByPointQingPlugin", (List)paramMap.get("allorgids"), DecisionAnlsHelper.getQueryDate(paramMap), paramMap, false);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.updateFields(new String[]{ISDOMESTIC, AMOUNT, COLLECTABLEAMOUNT}, new String[]{"case when isdomestic is null then '1' else isdomestic end", "case when isoffset = '1' then 0.0 else amount end", "case when isoffset = '1' then 0.0 else collectableamount end"});
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.select(new String[]{ISDOMESTIC, COLLECTAMOUNT, FINANCEAMOUNT, COMPANYAMOUNT, AMOUNT, COLLECTABLEAMOUNT});
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.groupBy(new String[]{ISDOMESTIC}).sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish();
        DataSet[] fundCcrAnlsByPointDataSets = fundCcrAnlsByPointDataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet allAreaSet = fundCcrAnlsByPointDataSets[0].groupBy().sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish().addField("'2'", AREANUMBER);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSets[1].addField(ISDOMESTIC, AREANUMBER).select(allAreaSet.getRowMeta().getFieldNames()).union(allAreaSet);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.addField("case when collectableamount is null or collectableamount = 0 then 0.0 else (collectamount / collectableamount) end", COLLECTABLERATE);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.addField("case when amount is null or amount = 0 then 0.0 else (collectamount / amount) end", ALLRATE);
        fundCcrAnlsByPointDataSet = DecisionAnlsHelper.creatAbsentRow(fundCcrAnlsByPointDataSet, AREANUMBER, Arrays.asList("0", "1", "2"), 5, () -> new Object[]{"0.0", "0.0", "0.0", "0.0", "0.0", "0", "0.0", "0.0"});
        DataSet newResult = this.addPullDownField(fundCcrAnlsByPointDataSet);
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"FinanceCostDataHelper.handleIntCalc").createDataSetBuilder(builderMeta);
        String coll = ResManager.loadKDString((String)"\u53ef\u5f52\u96c6", (String)"FundConcentrationQingPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
        String full = ResManager.loadKDString((String)"\u5168\u53e3\u5f84", (String)"FundConcentrationQingPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        for (Row row : newResult) {
            BigDecimal collecTableRate = row.getBigDecimal(COLLECTABLERATE);
            BigDecimal allRate = row.getBigDecimal(ALLRATE);
            String area = row.getString(AREA);
            String areanum = row.getString(AREANUMBER);
            Integer newAreaNum = 0;
            if ("1".equals(areanum)) {
                newAreaNum = 1;
            } else if ("0".equals(areanum)) {
                newAreaNum = 2;
            }
            builder.append(new Object[]{allRate, full, 0, area, newAreaNum});
            builder.append(new Object[]{collecTableRate, coll, 1, area, newAreaNum});
        }
        return builder.build();
    }

    private DataSet addPullDownField(DataSet dataSet) {
        dataSet = dataSet.addField("case when areanumber = '0' then '" + this.getMulText(0) + "' when areanumber = '1' then '" + this.getMulText(1) + "' else '" + this.getMulText(2) + "' end", AREA);
        return dataSet;
    }

    private String getMulText(int areaType) {
        if (0 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        if (1 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_fundconcentration");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_collfunddistbyorgrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u96c6\u4e2d\u5ea6\u5206\u5e03\u8868", (String)"CashConcernRateByOrgQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        String area = "2";
        if ("1".equals(ids.get(0))) {
            area = "1";
        } else if ("2".equals(ids.get(0))) {
            area = "0";
        }
        showParameter.getCustomParams().put("dateRange", area);
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREA_NUM;
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(4, 4);
        }
        return value;
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId("tda_collfunddistbyorgrpt");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u96c6\u4e2d\u5ea6\u5206\u5e03\u8868", (String)"CashConcernRateByOrgQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        String selectValue = null;
        if (EmptyUtil.isNoEmpty((Object)clickArgs.get((Object)"selectFilter"))) {
            selectValue = (String)((JSONObject)clickArgs.get((Object)"selectFilter")).get((Object)ResManager.loadKDString((String)"\u533a\u57df", (String)"FundConcentrationQingPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        String area = "2";
        if (EmptyUtil.isNoEmpty(selectValue)) {
            if (ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]).equals(selectValue)) {
                area = "1";
            } else if (ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]).equals(selectValue)) {
                area = "0";
            }
        }
        param.getCustomParams().put("dateRange", area);
    }
}

