/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashBalanceAvailableDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String CURRENCY = "currency";
    private static final String CURRENCYNUMBER = "currencynumber";
    private static final String VALIBALANCE = "valibalance";
    private static final String REALRESTRICTEDAMT = "restricted";
    private static final String COMPANY = "company";
    private static final String ORG = "rowid";
    private static final String ORG_NAME = "org_name";
    private static final String PID = "pid";
    private static final String LEVEL = "level";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String ISOFFSET = "isoffset";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("cny_valibalance", "usd_valibalance", "hkd_valibalance", "other_valibalance", "cny_restricted", "usd_restricted", "hkd_restricted", "other_restricted");
    private static final List<String> TOTAL_FIELDS = Arrays.asList("subtotal_valibalance", "subtotal_restricted", "cny_total", "usd_total", "hkd_total", "other_total", "subtotal_total");

    private String getFinorgtype() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashTotalAmountQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgids = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)allOrgids) && allOrgids.size() > 1) {
            allOrgids.remove(orgId);
        }
        DataSet usageLimitDs = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgids, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true);
        String selectStr = "company,currency,isoffset,realvalibalance as valibalance,realrestrictedamt as restricted,case when currencynumber != 'CNY' and currencynumber != 'HKD' and currencynumber != 'USD'then 'other_' else concat(lower(currencynumber),'_') end as currencynumber";
        DataSet allDataSet = usageLimitDs.select(selectStr);
        List<String> groupFieldNames = Arrays.asList(CURRENCYNUMBER, CURRENCY, COMPANY, ISOFFSET);
        List<String> amountFieldName = Arrays.asList(VALIBALANCE, REALRESTRICTEDAMT);
        DataSet changeSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(allDataSet, CURRENCYNUMBER, String.join((CharSequence)",", groupFieldNames.toArray(new String[groupFieldNames.size()])), "", amountFieldName);
        changeSet = DecisionAnlsHelper.addAbsentFields(changeSet, AMOUNT_FIELDS);
        return changeSet.groupBy(new String[]{COMPANY, ISOFFSET}).sum(AMOUNT_FIELDS.get(0)).sum(AMOUNT_FIELDS.get(1)).sum(AMOUNT_FIELDS.get(2)).sum(AMOUNT_FIELDS.get(3)).sum(AMOUNT_FIELDS.get(4)).sum(AMOUNT_FIELDS.get(5)).sum(AMOUNT_FIELDS.get(6)).sum(AMOUNT_FIELDS.get(7)).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        DataSet offsetDs = dataSets[1].filter("isoffset='1'").updateField(COMPANY, ((DynamicObject)parentOrgs.get(0)).getString("id"));
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> fieldList = this.getOrgFieldList();
        fieldList.addAll(AMOUNT_FIELDS);
        String[] selectFields = fieldList.toArray(new String[fieldList.size()]);
        offsetDs = offsetDs.leftJoin(orgDateSet).on(COMPANY, ORG).select(selectFields).finish();
        offsetDs = offsetDs.updateFields(new String[]{"cny_valibalance", "usd_valibalance", "hkd_valibalance", "other_valibalance", "cny_restricted", "usd_restricted", "hkd_restricted", "other_restricted", ORG_NAME, "sumlevel", ISGROUPNODE}, new String[]{"cny_valibalance * (-1)", "usd_valibalance * (-1)", "hkd_valibalance* (-1)", "other_valibalance* (-1)", "cny_restricted* (-1)", "usd_restricted* (-1)", "hkd_restricted* (-1)", "other_restricted* (-1)", '\'' + this.getFinorgtype() + '\'', "0", "'0'"});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        DataSet leftJoinBankDataSet = orgDateSet.leftJoin(allDs).on(ORG, COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, AMOUNT_FIELDS, "org_name,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).orderBy(new String[]{"sortcode"});
        fieldList.set(0, ORG_NAME);
        DataSet resultSet = sumDataSet.select(fieldList.toArray(new String[0])).union(offsetDs);
        resultSet = resultSet.addFields(new String[]{"cny_valibalance + usd_valibalance + hkd_valibalance + other_valibalance", "cny_restricted + usd_restricted + hkd_restricted + other_restricted"}, new String[]{"subtotal_valibalance", "subtotal_restricted"});
        resultSet = resultSet.addFields(new String[]{"cny_valibalance + cny_restricted", "usd_valibalance + usd_restricted", "hkd_valibalance + hkd_restricted", "other_valibalance + other_restricted", "subtotal_valibalance + subtotal_restricted"}, new String[]{"cny_total", "usd_total", "hkd_total", "other_total", "subtotal_total"});
        ArrayList sumFields = new ArrayList(){
            {
                this.addAll(AMOUNT_FIELDS);
                this.addAll(TOTAL_FIELDS);
            }
        };
        resultSet = resultSet.addField("cny_total + usd_total + hkd_total + other_total + subtotal_total", "totalamount");
        resultSet = resultSet.filter("totalamount != 0 and totalamount != null");
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, sumFields, ORG_NAME);
        return resultSet.union(sDataSet).addField(ORG, "orgid");
    }

    private List<String> getOrgFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(10);
        fieldList.add("mixorgname org_name");
        fieldList.add("0 sumlevel");
        fieldList.add(ORG);
        fieldList.add(PID);
        fieldList.add(LEVEL);
        fieldList.add(ISGROUPNODE);
        fieldList.add("sortcode");
        return fieldList;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(AMOUNT_FIELDS);
        fields.addAll(TOTAL_FIELDS);
        return fields;
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        ds = ds.groupBy(groups).sum("cny_valibalance").sum("usd_valibalance").sum("hkd_valibalance").sum("other_valibalance").sum("cny_restricted").sum("usd_restricted").sum("hkd_restricted").sum("other_restricted").finish().orderBy(groups);
        return ds;
    }
}

