/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashBalanceFinAndSettleDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String ORG = "rowid";
    private static final String ORG_NAME = "org_name";
    private static final String PID = "pid";
    private static final String LEVEL = "level";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String ISOFFSET = "isoffset";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("cny_total", "usd_total", "hkd_total", "other_total", "cny_fincom", "usd_fincom", "hkd_fincom", "other_fincom", "cny_settle", "usd_settle", "hkd_settle", "other_settle");
    private static final List<String> TOTAL_FIELDS = Arrays.asList("subtotal_total", "subtotal_fincom", "subtotal_settle");

    private String getFinorgtype() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashTotalAmountQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgids = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)allOrgids) && allOrgids.size() > 1) {
            allOrgids.remove(orgId);
        }
        DataSet ds = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgids, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true);
        ds = ds.updateField("currencynumber", "case when currencynumber != 'CNY' and currencynumber != 'HKD' and currencynumber != 'USD' then 'other' else lower(currencynumber) end");
        ds = ds.select("company,finorgtype,currencynumber,isoffset,realvalibalance + realrestrictedamt as totalamount");
        ds = ds.groupBy(new String[]{COMPANY, "finorgtype", "currencynumber", ISOFFSET}).sum("totalamount").finish();
        DataSet[] splitDs = ds.splitByFilter(new String[]{"true", "finorgtype = '1'", "finorgtype = '3'"}, false);
        DataSet totalDataSet = splitDs[0];
        DataSet settleDataSet = splitDs[1];
        DataSet finDataSet = splitDs[2];
        totalDataSet = totalDataSet.updateField("finorgtype", "'0'");
        settleDataSet = settleDataSet.updateField(ISOFFSET, "'0'");
        finDataSet = finDataSet.updateField(ISOFFSET, "'0'");
        DataSet allDataSet = totalDataSet.union(new DataSet[]{finDataSet, settleDataSet});
        allDataSet = allDataSet.groupBy(new String[]{COMPANY, "finorgtype", "currencynumber", ISOFFSET}).sum("totalamount").finish();
        allDataSet = allDataSet.select("company,isoffset,case when finorgtype = '0' and currencynumber='cny'  then totalamount else 0 end as cny_total,case when finorgtype = '0' and currencynumber='usd' then totalamount else 0 end as usd_total,case when finorgtype = '0' and currencynumber='hkd' then totalamount else 0 end as hkd_total,case when finorgtype = '0' and currencynumber='other' then totalamount else 0 end as other_total,case when finorgtype = '3' and currencynumber='cny' then totalamount else 0 end as cny_fincom,case when finorgtype = '3' and currencynumber='usd' then totalamount else 0 end as usd_fincom,case when finorgtype = '3' and currencynumber='hkd' then totalamount else 0 end as hkd_fincom,case when finorgtype = '3' and currencynumber='other' then totalamount else 0 end as other_fincom,case when finorgtype = '1' and currencynumber='cny' then totalamount else 0 end as cny_settle,case when finorgtype = '1' and currencynumber='usd' then totalamount else 0 end as usd_settle,case when finorgtype = '1' and currencynumber='hkd' then totalamount else 0 end as hkd_settle,case when finorgtype = '1' and currencynumber='other' then totalamount else 0 end as other_settle");
        return allDataSet.groupBy(new String[]{COMPANY, ISOFFSET}).sum(AMOUNT_FIELDS.get(0)).sum(AMOUNT_FIELDS.get(1)).sum(AMOUNT_FIELDS.get(2)).sum(AMOUNT_FIELDS.get(3)).sum(AMOUNT_FIELDS.get(4)).sum(AMOUNT_FIELDS.get(5)).sum(AMOUNT_FIELDS.get(6)).sum(AMOUNT_FIELDS.get(7)).sum(AMOUNT_FIELDS.get(8)).sum(AMOUNT_FIELDS.get(9)).sum(AMOUNT_FIELDS.get(10)).sum(AMOUNT_FIELDS.get(11)).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        DataSet offsetDs = dataSets[1].filter("isoffset='1'").updateField(COMPANY, ((DynamicObject)parentOrgs.get(0)).getString("id"));
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> fieldList = this.getOrgFieldList();
        fieldList.addAll(AMOUNT_FIELDS);
        String[] selectFields = fieldList.toArray(new String[fieldList.size()]);
        offsetDs = offsetDs.leftJoin(orgDateSet).on(COMPANY, ORG).select(selectFields).finish();
        offsetDs = offsetDs.updateFields(new String[]{"cny_total", "usd_total", "hkd_total", "other_total", ORG_NAME, "sumlevel", ISGROUPNODE}, new String[]{"cny_total * (-1)", "usd_total * (-1)", "hkd_total* (-1)", "other_total* (-1)", '\'' + this.getFinorgtype() + '\'', "0", "'0'"});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        DataSet leftJoinBankDataSet = orgDateSet.leftJoin(allDs).on(ORG, COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, AMOUNT_FIELDS, "org_name,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).orderBy(new String[]{"sortcode"});
        fieldList.set(0, ORG_NAME);
        DataSet resultSet = sumDataSet.select(fieldList.toArray(new String[0])).union(offsetDs);
        resultSet = resultSet.addFields(new String[]{"cny_total + usd_total + hkd_total + other_total", "cny_fincom + usd_fincom + hkd_fincom + other_fincom", "cny_settle + usd_settle + hkd_settle + other_settle"}, new String[]{"subtotal_total", "subtotal_fincom", "subtotal_settle"});
        ArrayList sumFields = new ArrayList(){
            {
                this.addAll(AMOUNT_FIELDS);
                this.addAll(TOTAL_FIELDS);
            }
        };
        resultSet = resultSet.filter("subtotal_total != 0 and subtotal_total != null");
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, sumFields, ORG_NAME);
        return resultSet.union(sDataSet).addField(ORG, "orgid");
    }

    private List<String> getOrgFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(10);
        fieldList.add("mixorgname org_name");
        fieldList.add("0 sumlevel");
        fieldList.add(ORG);
        fieldList.add(PID);
        fieldList.add(LEVEL);
        fieldList.add(ISGROUPNODE);
        fieldList.add("sortcode");
        return fieldList;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(AMOUNT_FIELDS);
        fields.addAll(TOTAL_FIELDS);
        return fields;
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        ds = ds.groupBy(groups).sum(AMOUNT_FIELDS.get(0)).sum(AMOUNT_FIELDS.get(1)).sum(AMOUNT_FIELDS.get(2)).sum(AMOUNT_FIELDS.get(3)).sum(AMOUNT_FIELDS.get(4)).sum(AMOUNT_FIELDS.get(5)).sum(AMOUNT_FIELDS.get(6)).sum(AMOUNT_FIELDS.get(7)).sum(AMOUNT_FIELDS.get(8)).sum(AMOUNT_FIELDS.get(9)).sum(AMOUNT_FIELDS.get(10)).sum(AMOUNT_FIELDS.get(11)).finish();
        return ds;
    }
}

