/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String DISPLAY_TYPE = "displayType";
    private static final String BANKCATE = "bankcate";
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "99";
    private static final String STAT = "stat";
    private static final String ROWID = "rowid";
    private static final String VALIBALANCE = "valibalance";
    private static final String COMPANY = "company";
    private static final String AMOUNTRATE = "amountrate";
    private static final String BANKNAME = "bankname";
    private static final String ORGNAME = "orgname";
    private static final String TMC_TDA_REPORT = "tmc-tda-report";
    private static final String BANK_SUM = "bankSum";
    private static final String ISOFFSET = "isoffset";
    private static final String SUM_OFFSET = "sumOffset";
    private static final String SUM_CLEARINGHOUSE_OFFSET = "sumClearinghouseOffset";
    private static final String SUM_FINCOMP_OFFSET = "sumFinCompOffset";
    public static final int TOP_NUMBER = 15;

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return this.getQueryDataSet((List)paramMap.get("allorgids"), queryDate, paramMap);
    }

    private DataSet getQueryDataSet(List<Long> orgIds, Date queryDate, Map<String, Object> paramMap) {
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty(orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet fundDataSet = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        String filterBankString = String.format("bankcatename not like '%1$s%2$s%3$s'", "%", ResManager.loadKDString((String)"\u4eba\u6c11\u94f6\u884c", (String)"CashBankQingAnlsPlugin_8", (String)TMC_TDA_REPORT, (Object[])new Object[0]), "%");
        fundDataSet = fundDataSet.filter(filterBankString);
        List<String> finOrgTypeList = Arrays.asList(FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.FINCOMP.getValue(), FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        fundDataSet = fundDataSet.filter("finorgtype in finorgtypes", Collections.singletonMap("finorgtypes", finOrgTypeList)).updateField(VALIBALANCE, "realvalibalance + realrestrictedamt").select(new String[]{COMPANY, "bankcatename bankname", "bankcateid bankcate", "isdomestic", "finorgtype", VALIBALANCE, ISOFFSET});
        fundDataSet = fundDataSet.groupBy(new String[]{COMPANY, BANKNAME, BANKCATE, "isdomestic", "finorgtype", ISOFFSET}).sum(VALIBALANCE).finish();
        return fundDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, Collections.singleton(VALIBALANCE));
        DataSet offsetDataSet = ds.copy().filter("isoffset = '1'").select("valibalance,isdomestic,case when finorgtype = '1' then valibalance else 0 end as sumClearinghouseOffset,case when finorgtype = '3' then valibalance else 0 end as sumFinCompOffset");
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        offsetDataSet = AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(displayType) ? offsetDataSet.filter("isdomestic = '1' ") : offsetDataSet.filter("isdomestic = '0' ");
        offsetDataSet = offsetDataSet.groupBy().sum(VALIBALANCE, SUM_OFFSET).sum(SUM_FINCOMP_OFFSET).sum(SUM_CLEARINGHOUSE_OFFSET).finish().addField("2", "sumleveloffset");
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        DataSet bankDataSet = DecisionAnlsHelper.getAcctByType(ds.copy(), displayByBankTypeEnum);
        DataSet unionSet = this.setTopBank(bankDataSet);
        unionSet = this.setFinCompanyData(ds, displayByBankTypeEnum, unionSet);
        Map<Long, String> bankMap = this.getBankColKayAndNameMap(unionSet.copy().groupBy(new String[]{BANKCATE, BANKNAME}).finish());
        DataSet groupSet = unionSet.select(new String[]{COMPANY, BANKCATE, VALIBALANCE}).groupBy(new String[]{COMPANY, BANKCATE}).sum(VALIBALANCE).finish();
        DataSet result = DecisionAnlsHelper.ChangeMultRowToColDataSet(groupSet, BANKCATE, COMPANY, PREFIX, Collections.singletonList(VALIBALANCE));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = this.getSumField(result);
        List<String> selectField = this.getSelectField(sumField);
        selectField.add("sortcode");
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on(ROWID, COMPANY).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(VALIBALANCE)).collect(Collectors.toSet());
        sumColSet.remove("bankcate_99valibalance");
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : "0", STAT);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode", "stat desc"});
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        ArrayList<String> showColName = new ArrayList<String>(sumField);
        Set<String> bankCols = this.getBankCols(sumField);
        bankCols.remove("bankcate_99valibalance");
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(bankCols) ? String.join((CharSequence)"+", bankCols) : "0", BANK_SUM);
        sumField.add(BANK_SUM);
        sumField.add(STAT);
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, ORGNAME);
        if (!offsetDataSet.isEmpty()) {
            String[] fieldNames;
            DataSet offsetJoinTotal = totalSet.leftJoin(offsetDataSet).on("sumlevel", "sumleveloffset").select((String[])ArrayUtils.addAll((Object[])totalSet.getRowMeta().getFieldNames(), (Object[])new String[]{SUM_OFFSET, SUM_FINCOMP_OFFSET, SUM_CLEARINGHOUSE_OFFSET})).finish().updateFields(new String[]{SUM_OFFSET, SUM_FINCOMP_OFFSET, SUM_CLEARINGHOUSE_OFFSET}, new String[]{"case when sumOffset is null then 0 else sumOffset end sumOffset", "case when sumFinCompOffset is null then 0 else sumFinCompOffset end sumFinCompOffset", "case when sumClearinghouseOffset is null then 0 else sumClearinghouseOffset end sumClearinghouseOffset"});
            if (sumField.contains("bankcate_1valibalance")) {
                offsetJoinTotal = offsetJoinTotal.updateField("bankcate_1valibalance", "bankcate_1valibalance - sumClearinghouseOffset");
            }
            if (sumField.contains("bankcate_3valibalance")) {
                offsetJoinTotal = offsetJoinTotal.updateField("bankcate_3valibalance", "bankcate_3valibalance - sumFinCompOffset");
            }
            totalSet = offsetJoinTotal.copy().updateField(STAT, "stat - sumOffset").removeFields(new String[]{SUM_OFFSET, SUM_FINCOMP_OFFSET, SUM_CLEARINGHOUSE_OFFSET});
            if (sumField.contains("bankcate_1valibalance")) {
                offsetJoinTotal = offsetJoinTotal.updateField("bankcate_1valibalance", "case when sumClearinghouseOffset is null then 0 else sumClearinghouseOffset  * -1 end");
            }
            if (sumField.contains("bankcate_3valibalance")) {
                offsetJoinTotal = offsetJoinTotal.updateField("bankcate_3valibalance", "case when sumFinCompOffset is null then 0 else sumFinCompOffset  * -1 end");
            }
            DataSet offsetRow = offsetJoinTotal.updateField(STAT, "case when sumOffset is null then 0 else sumOffset  * -1 end").removeFields(new String[]{SUM_OFFSET, SUM_FINCOMP_OFFSET, SUM_CLEARINGHOUSE_OFFSET});
            for (String col : fieldNames = offsetRow.getRowMeta().getFieldNames()) {
                if (STAT.equals(col) || "bankcate_1valibalance".equals(col) || "bankcate_3valibalance".equals(col)) continue;
                offsetRow = offsetRow.updateField(col, "null");
            }
            offsetRow = offsetRow.updateField(ORGNAME, ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashBankDataListPlugin_1", (String)TMC_TDA_REPORT, (Object[])new Object[0])).updateField("sumlevel", "3");
            sumDataSet = sumDataSet.union(offsetRow);
        }
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = this.getCols(totalSet.copy(), bankMap, displayByBankTypeEnum);
        queryParam.getCustomParam().put("topBankMap", cols);
        DataSet showData = sumDataSet.union(totalSet);
        showData = this.setRateColData(showColName, showData);
        return showData;
    }

    private DataSet setRateColData(List<String> showColName, DataSet showData) {
        String finCompColName = this.getBankcateAmountColName(FinOrgTypeEnum.FINCOMP.getValue());
        String clearingHouseColName = this.getBankcateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        boolean existsBankSumCol = showData.getRowMeta().getFieldIndex(BANK_SUM, false) != -1;
        for (String col : showColName) {
            if (finCompColName.equals(col) || clearingHouseColName.equals(col)) continue;
            String colName = existsBankSumCol ? BANK_SUM : STAT;
            showData = showData.addField(this.getCaseWhenSql(col, colName), col + AMOUNTRATE);
        }
        return showData;
    }

    private String getCaseWhenSql(String dividend, String divisor) {
        return String.format(" case when (%s is null or %s = 0) then 0 else (%s) end ", divisor, divisor, dividend + "/" + divisor);
    }

    private DataSet setFinCompanyData(DataSet ds, AcctDisplayByBankTypeEnum displayByBankTypeEnum, DataSet unionSet) {
        boolean isSettlementCenter = BasicParamHelper.getAppBooleamParameter((String)"tda_acct_queryparamset", (String)"issettlementcenter");
        ds = displayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC ? ds.filter("isdomestic = '1'") : ds.filter("isdomestic = '0'");
        DataSet finCompLimitSet = DecisionAnlsHelper.getfinCompCreditLimit(ds).updateField(BANKCATE, FinOrgTypeEnum.FINCOMP.getValue());
        unionSet = unionSet.union(finCompLimitSet);
        if (isSettlementCenter) {
            DataSet clearingHouse = ds.filter("finorgtype = '1'").updateField(BANKCATE, FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            unionSet = unionSet.union(clearingHouse);
        }
        return unionSet;
    }

    private DataSet setTopBank(DataSet bankDataSet) {
        DataSet unionSet;
        Pair<DataSet, DataSet> splitDataSet = DecisionAnlsHelper.splitTopBank(bankDataSet, VALIBALANCE, 15);
        DataSet topBankSet = (DataSet)splitDataSet.getValue0();
        Set<String> topBankCate = DecisionAnlsHelper.getTopBanks(topBankSet.copy(), BANKCATE);
        this.getQueryParam().getCustomParam().put("topBankCate", topBankCate);
        if (splitDataSet.getValue1() != null && !((DataSet)splitDataSet.getValue1()).isEmpty()) {
            DataSet otherBankSet = (DataSet)splitDataSet.getValue1();
            DataSet otherBankCreditLimitSet = otherBankSet.copy().updateField(BANKCATE, OHTERBANK_ID);
            unionSet = topBankSet.union(new DataSet[]{otherBankSet, otherBankCreditLimitSet});
        } else {
            unionSet = topBankSet;
        }
        return unionSet;
    }

    private Set<String> getBankCols(List<String> sumField) {
        return sumField.stream().filter(f -> f.endsWith(VALIBALANCE) && !this.getBankcateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()).equals(f) && !this.getBankcateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()).equals(f)).collect(Collectors.toSet());
    }

    private List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(30);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    private List<AbstractReportColumn> getCols(DataSet totalSet, Map<Long, String> bankMap, AcctDisplayByBankTypeEnum displayByBankTypeEnum) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        Set<String> bankCols = this.getBankCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()));
        ArrayList<AbstractReportColumn> reportColumns = new ArrayList<AbstractReportColumn>();
        String otherBankCateColKey = this.getBankcateAmountColName(OHTERBANK_ID);
        if (CollectionUtils.isNotEmpty(bankCols)) {
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            bankCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherBankCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            totalRowData.sort((o1, o2) -> ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1()));
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String substring = colKey.substring(PREFIX.length(), colKey.indexOf(VALIBALANCE));
                Long bankCateId = Long.valueOf(substring);
                if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(substring)) continue;
                reportColumns.add(this.getReportCol(bankMap.get(bankCateId), colKey, true));
            }
        }
        if (this.colExists(totalSet, OHTERBANK_ID)) {
            reportColumns.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"CashBankDataListPlugin_2", (String)TMC_TDA_REPORT, (Object[])new Object[0]), this.getBankcateAmountColName(OHTERBANK_ID), true));
        }
        if (displayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            reportColumns.add(this.getReportCol(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CashBankDataListPlugin_3", (String)TMC_TDA_REPORT, (Object[])new Object[0]), BANK_SUM, false));
        }
        if (this.colExists(totalSet, FinOrgTypeEnum.FINCOMP.getValue())) {
            reportColumns.add(this.getReportCol(FinOrgTypeEnum.FINCOMP.getName(), this.getBankcateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()), false));
        }
        if (this.colExists(totalSet, FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            reportColumns.add(this.getReportCol(FinOrgTypeEnum.CLEARINGHOUSE.getName(), this.getBankcateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()), false));
        }
        return reportColumns;
    }

    private AbstractReportColumn getReportCol(String catpion, String colKey, boolean isGroupCol) {
        ReportColumn result;
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        Set topBankCate = (Set)this.getQueryParam().getCustomParam().get("topBankCate");
        Boolean isShowAll = (Boolean)this.getQueryParam().getCustomParam().get("isShowAll");
        if (isGroupCol) {
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(colKey + "Group");
            newColGroup.setCaption(new LocaleString(catpion));
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("decimal");
            newCol.setScale(2);
            newCol.setZeroShow(true);
            newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"CashBankDataListPlugin_4", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            newCol.setStyle(columnStyle);
            if ("bankcate_99valibalance".equals(colKey)) {
                newCol.setHyperlink(true);
            }
            ReportColumn newColRate = new ReportColumn();
            newColRate.setFieldKey(colKey + AMOUNTRATE);
            newColRate.setFieldType("text");
            newColRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6bd4\u4f8b", (String)"CashBankDataListPlugin_5", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            newColRate.setStyle(columnStyle);
            String bankCate = colKey.substring(PREFIX.length(), colKey.indexOf(VALIBALANCE));
            if (!topBankCate.isEmpty() && !topBankCate.contains(bankCate)) {
                if (isShowAll != null && isShowAll.booleanValue()) {
                    newCol.setHide(false);
                    newColRate.setHide(false);
                    if (OHTERBANK_ID.equals(bankCate)) {
                        newCol.setHide(true);
                        newColRate.setHide(true);
                    }
                } else {
                    newCol.setHide(true);
                    newColRate.setHide(true);
                    if (OHTERBANK_ID.equals(bankCate)) {
                        newCol.setHide(false);
                        newColRate.setHide(false);
                    }
                }
            }
            List children = newColGroup.getChildren();
            children.add(newCol);
            children.add(newColRate);
            result = newColGroup;
        } else {
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("decimal");
            newCol.setScale(2);
            newCol.setZeroShow(true);
            newCol.setCaption(new LocaleString(catpion));
            newCol.setStyle(columnStyle);
            result = newCol;
        }
        return result;
    }

    private boolean colExists(DataSet dataSet, String bankCateId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + bankCateId + VALIBALANCE, false) != -1;
    }

    private Map<Long, String> getBankColKayAndNameMap(DataSet allData) {
        HashMap<Long, String> bankMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                bankMap.put(row.getLong(BANKCATE), row.getString(BANKNAME));
            }
        }
        return bankMap;
    }

    private String getBankcateAmountColName(Object bankCateId) {
        return PREFIX + bankCateId + VALIBALANCE;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topBankMap");
        columns.addAll(cols);
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(STAT);
        newCol.setFieldType("decimal");
        newCol.setScale(2);
        newCol.setZeroShow(true);
        newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CashBankDataListPlugin_6", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        columns.add((AbstractReportColumn)newCol);
        return columns;
    }
}

