/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.cash.helper.CashDistributionByAreaHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CashDistributionByAreaDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static String TOTAL = "total";
    private static String COUNTRY = "country";
    public static String AREA_OTHER = "area_0";
    private List<String> COUNT_FIELDS = new ArrayList<String>(16);
    private List<String> ORDER_FIELDS = new ArrayList<String>(16);
    private static int TOP_NUM = 15;

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        return CashDistributionByAreaHelper.query(this.transQueryParam(reportQueryParam));
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        RowMeta rowMeta = ds.getRowMeta();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map paramMap = this.transQueryParam(queryParam);
        DataSet processDataSet = CashDistributionByAreaHelper.processDataSet(ds.copy(), paramMap);
        this.COUNT_FIELDS.clear();
        DataSet filterResultDataSet = CashDistributionByAreaHelper.filterResultDataSet(processDataSet, paramMap).orderBy(new String[]{"sortcode"});
        this.COUNT_FIELDS = CashDistributionByAreaHelper.getCountFields(filterResultDataSet);
        DataSet dataSet = filterResultDataSet.addField(String.join((CharSequence)"+", this.COUNT_FIELDS), TOTAL);
        this.COUNT_FIELDS.add(TOTAL);
        dataSet = this.addOffsetRow(ds, dataSet, paramMap);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(dataSet, this.COUNT_FIELDS, "mixorgname");
        List<String> orderCols = this.setColOrder(totalDataSet);
        DataSet resultSet = dataSet.union(totalDataSet);
        if (this.ORDER_FIELDS.contains(AREA_OTHER)) {
            resultSet = resultSet.addField(TOTAL + "-(" + String.join((CharSequence)"+", orderCols.subList(0, TOP_NUM)) + ")", AREA_OTHER);
        }
        return resultSet.addField("rowid", "orgid").addField("mixorgname", "org_name");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.ORDER_FIELDS);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map countryMap = BusinessDataServiceHelper.loadFromCache((String)"bd_country", (String)String.join((CharSequence)",", "id", "name"), null);
        this.ORDER_FIELDS.stream().forEach(fieldName -> {
            String countryName = "";
            String[] splitName = fieldName.split("_");
            if (fieldName.equals(TOTAL)) {
                countryName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CashDistributionByAreaDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
            } else if (EmptyUtil.isNoEmpty((String)splitName[1])) {
                DynamicObject country = (DynamicObject)countryMap.get(Long.valueOf(splitName[1]));
                if (country != null) {
                    countryName = country.getString("name");
                }
                if ("1000001".equals(splitName[1])) {
                    countryName = ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646", (String)"CashDistributionByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
                } else if ("0".equals(splitName[1])) {
                    countryName = ResManager.loadKDString((String)"\u5176\u4ed6\u56fd\u5bb6", (String)"CashDistributionByAreaDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
                }
            }
            columns.add((AbstractReportColumn)this.createColumn((String)fieldName, countryName));
        });
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        return reportColumn;
    }

    private List<String> setColOrder(DataSet dataSet) {
        Iterator iterator = dataSet.copy().iterator();
        ArrayList<Pair> pairs = new ArrayList<Pair>(this.COUNT_FIELDS.size());
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (String fieldName : this.COUNT_FIELDS) {
                if (!fieldName.startsWith(CashDistributionByAreaHelper.AREA_PREFIX)) continue;
                BigDecimal amount = row.getBigDecimal(fieldName);
                if (amount == null) {
                    amount = BigDecimal.ZERO;
                }
                Pair pair = Pair.of((Object)amount, (Object)fieldName);
                pairs.add(pair);
            }
        }
        List<String> orderFields = pairs.stream().sorted(Comparator.comparing(p -> (BigDecimal)((Pair)p).getKey()).reversed()).map(Pair::getValue).collect(Collectors.toList());
        this.ORDER_FIELDS.clear();
        if (orderFields.size() > TOP_NUM) {
            this.ORDER_FIELDS = new ArrayList(orderFields.subList(0, TOP_NUM));
            this.ORDER_FIELDS.add(AREA_OTHER);
        } else {
            this.ORDER_FIELDS = new ArrayList(orderFields);
        }
        this.ORDER_FIELDS.add(TOTAL);
        return orderFields;
    }

    private DataSet addOffsetRow(DataSet ds, DataSet dataSet, Map<String, Object> paramMap) {
        DataSet resultSet = dataSet;
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allOrgIds = (List)paramMap.get("allorgids");
        ArrayList subOrgIds = new ArrayList(allOrgIds);
        subOrgIds.remove(orgId);
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            ds = ds.where("org in (" + TmcBusinessBaseHelper.idListToString(subOrgIds) + ")");
        }
        DataSet filterSet = ds.filter("isoffset = '1'").groupBy(new String[]{COUNTRY}).sum(CashDistributionByAreaHelper.BALANCE).finish();
        Iterator iterator = filterSet.iterator();
        ArrayList<String> countryNames = new ArrayList<String>(dataSet.getRowMeta().getFieldNames().length);
        ArrayList<String> countryvalues = new ArrayList<String>(dataSet.getRowMeta().getFieldNames().length);
        BigDecimal total = BigDecimal.ZERO;
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                countryNames.add(CashDistributionByAreaHelper.AREA_PREFIX + next.getString(COUNTRY));
                countryvalues.add(next.getBigDecimal(CashDistributionByAreaHelper.BALANCE).negate().toPlainString());
                total = total.add(next.getBigDecimal(CashDistributionByAreaHelper.BALANCE).negate());
            }
            countryNames.add(TOTAL);
            countryvalues.add(total.toPlainString());
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            DataType[] dataTypes = dataSet.getRowMeta().getDataTypes();
            DataSet offsetRowSet = DecisionAnlsHelper.createRowByDefault(fieldNames, dataTypes);
            String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashDistributionByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
            countryNames.add("mixorgname");
            countryvalues.add("'" + offsetName + "'");
            offsetRowSet = offsetRowSet.updateFields(countryNames.toArray(new String[0]), countryvalues.toArray(new String[0]));
            resultSet = dataSet.union(offsetRowSet);
        }
        return resultSet;
    }
}

