/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDomesticAndForeignDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String CURRENCY = "currency";
    private static final String AREATYPE = "areatype";
    private static final String VALIBALANCE = "valibalance";
    private static final String REALRESTRICTEDAMT = "restricted";
    private static final String COMPANY = "company";
    private static final String ORG = "rowid";
    private static final String ORG_NAME = "mixorgname";
    private static final String ISOFFSET = "isoffset";
    private static String[] GROUP_FIELD_NAMES = new String[]{"currency", "company", "isoffset", "areatype"};
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("domestic_valibalance", "domestic_restricted", "foreign_valibalance", "foreign_restricted");
    private static final List<String> TOTAL_FIELDS = Arrays.asList("domestic_subtotal", "foreign_subtotal", "total_valibalance", "total_restricted", "total_subtotal");

    private String getFinorgtype() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashTotalAmountQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgIds = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)allOrgIds) && allOrgIds.size() > 1) {
            allOrgIds.remove(orgId);
        }
        DataSet usageLimitDs = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgIds, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true);
        String sic = "company,isoffset,currency,realvalibalance as valibalance,realrestrictedamt as restricted,case when isdomestic_fund = '1' or isdomestic_fund is null then 'domestic_' else 'foreign_' end  as areatype";
        DataSet allDataSet = usageLimitDs.select(sic);
        List<String> amountFieldName = Arrays.asList(VALIBALANCE, REALRESTRICTEDAMT);
        DataSet changeSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(allDataSet, AREATYPE, String.join((CharSequence)",", GROUP_FIELD_NAMES), "", amountFieldName);
        changeSet = DecisionAnlsHelper.addAbsentFields(changeSet, AMOUNT_FIELDS);
        return this.groupby(changeSet, new String[]{COMPANY, ISOFFSET});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet offsetDs = ds.copy().filter("isoffset='1'").updateField(COMPANY, ((DynamicObject)parentOrgs.get(0)).getString("id"));
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String[] selectFields = DecisionAnlsHelper.getSelectField(AMOUNT_FIELDS);
        offsetDs = offsetDs.leftJoin(orgDateSet).on(COMPANY, ORG).select(selectFields).finish();
        offsetDs = offsetDs.updateFields(new String[]{"domestic_valibalance", "domestic_restricted", "foreign_valibalance", "foreign_restricted", ORG_NAME, "sumlevel", "isgroupnode"}, new String[]{"domestic_valibalance * (-1)", "domestic_restricted * (-1)", "foreign_valibalance* (-1)", "foreign_restricted* (-1)", '\'' + this.getFinorgtype() + '\'', "0", "'0'"});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        DataSet leftJoinBankDataSet = orgDateSet.leftJoin(allDs).on(ORG, COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, AMOUNT_FIELDS, "mixorgname,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).orderBy(new String[]{"sortcode"});
        DataSet resultSet = sumDataSet.union(offsetDs.select(sumDataSet.getRowMeta().getFieldNames()));
        resultSet = resultSet.addFields(new String[]{"domestic_valibalance + domestic_restricted", "foreign_valibalance + foreign_restricted"}, new String[]{"domestic_subtotal", "foreign_subtotal"});
        resultSet = resultSet.addFields(new String[]{"domestic_valibalance + foreign_valibalance", "domestic_restricted + foreign_restricted", "domestic_subtotal + foreign_subtotal"}, new String[]{"total_valibalance", "total_restricted", "total_subtotal"});
        resultSet = resultSet.filter("total_subtotal != 0 and total_subtotal != null");
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, new ArrayList<String>(this.getAmountFields()), ORG_NAME);
        resultSet = resultSet.union(sDataSet).addField(ORG, "orgid");
        return resultSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(AMOUNT_FIELDS);
        fields.addAll(TOTAL_FIELDS);
        return fields;
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        GroupbyDataSet groupbyDs = ds.groupBy(groups);
        for (String amountField : AMOUNT_FIELDS) {
            groupbyDs = groupbyDs.sum(amountField);
        }
        return groupbyDs.finish().orderBy(groups);
    }
}

