/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashOtherBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final List<String> FIN_ORG_TYPE_LIST = Collections.singletonList(FinOrgTypeEnum.BANK.getValue());
    private static final String DISPLAY_TYPE = "displayType";
    private static final String VALIBALANCE = "valibalance";
    private static final String COMPANY = "company";
    private static final String BANK_NAME = "bankname";
    private static final int TOP_NUMBER = 15;

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        String orgViewNumber = orgView.getString("number");
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(orgId), (boolean)true, (boolean)true);
        return this.getQueryDataSet(allOrgIds, queryDate, paramMap);
    }

    private DataSet getQueryDataSet(List<Long> orgIds, Date queryDate, Map<String, Object> paramMap) {
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty(orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet fundDataSet = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        String filterBankString = String.format("bankcatename not like '%1$s%2$s%3$s'", "%", ResManager.loadKDString((String)"\u4eba\u6c11\u94f6\u884c", (String)"CashBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "%");
        fundDataSet = fundDataSet.filter(filterBankString);
        fundDataSet = fundDataSet.filter("finorgtype in finorgtypes", Collections.singletonMap("finorgtypes", FIN_ORG_TYPE_LIST)).updateField(VALIBALANCE, "realvalibalance + realrestrictedamt").select(new String[]{COMPANY, "bankcatename bankname", "isdomestic", "finorgtype", VALIBALANCE});
        return fundDataSet.groupBy(new String[]{COMPANY, BANK_NAME, "isdomestic", "finorgtype"}).sum(VALIBALANCE).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        ds = DecisionAnlsHelper.getAcctByType(ds, displayByBankTypeEnum);
        ds = this.getNoTopBankDs(ds);
        String currentOrgId = (String)paramMap.get("current_org_id");
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(Long.valueOf(currentOrgId)), (boolean)true, (boolean)true);
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        if (EmptyUtil.isNoEmpty((String)currentOrgId) && currentOrgId.equals("" + orgId)) {
            subOrgIds.remove(orgId);
        }
        ds = ds.filter("company in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("valibalance>0");
        ds = ds.groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).finish().orderBy(new String[]{"valibalance DESC"});
        DataSet sumDs = ds.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).finish();
        ds = ds.addField("0", "sumlevel");
        sumDs = sumDs.addField("1", "sumlevel");
        return ds.union(sumDs);
    }

    private DataSet getNoTopBankDs(DataSet ds) {
        DataSet topBankTempDs = ds.copy().filter("bankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(VALIBALANCE).finish().orderBy(new String[]{"valibalance DESC"}).top(15);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        DataSet noTopBankDs = ds.filter(DecisionAnlsHelper.buildOtherFilter(topBanks, BANK_NAME));
        return noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(VALIBALANCE).finish();
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(VALIBALANCE);
    }
}

