/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsTrendDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashTrendChartDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String STAT = "stat";
    private static List<String> amountFieldName = Arrays.asList("realvalibalance", "realrestrictedamt", "subtotal");

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        DataSet usageLimitDs;
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgids = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)allOrgids) && allOrgids.size() > 1) {
            allOrgids.remove(orgId);
        }
        if ((usageLimitDs = CashFundsTrendDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgids, (Date)queryDate, (Map)paramMap, (boolean)true)).copy().isEmpty()) {
            usageLimitDs = usageLimitDs.addFields(new String[]{"''", "0", "0", "0"}, new String[]{"mixorgname", "orgid", "isgroupnode", "sumlevel"});
            return DecisionAnlsHelper.createEmptyDataSet(usageLimitDs.getRowMeta().getFieldNames(), usageLimitDs.getRowMeta().getDataTypes());
        }
        DataSet offsetResult = usageLimitDs.copy().filter("isoffset = '1'");
        usageLimitDs = usageLimitDs.updateField("isoffset", "'0'");
        usageLimitDs = usageLimitDs.union(offsetResult);
        usageLimitDs = usageLimitDs.select("isoffset,company,bizdate,realvalibalance,realrestrictedamt").groupBy(new String[]{"isoffset", "company", "bizdate"}).sum("realvalibalance").sum("realrestrictedamt").finish().addField("realvalibalance+realrestrictedamt", "subtotal");
        usageLimitDs = AmountTransHelper.dealRowOtherValue((DataSet)usageLimitDs, (Map)paramMap, new HashSet<String>(amountFieldName));
        DataSet changeRowData = DecisionAnlsHelper.ChangeMultRowToColDataSet(usageLimitDs, "bizdate", "company,isoffset", "month_", amountFieldName);
        DataSet[] splitDataSet = changeRowData.splitByFilter(new String[]{"isoffset = '0'"}, true);
        DataSet result = splitDataSet[0];
        DataSet offsetData = splitDataSet[1];
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = CashTrendChartDataListPlugin.getSumField(result);
        List<String> selectField = CashTrendChartDataListPlugin.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on("rowid", "company").select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "orgid,orgname,mixorgname,sortcode");
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        if (EmptyUtil.isNoEmpty((Object)filterOrg)) {
            sumDataSet = sumDataSet.filter("rowid in filterorg", Collections.singletonMap("filterorg", filterOrg));
        }
        sumDataSet = sumDataSet.addField(String.join((CharSequence)"+", sumField.stream().filter(f -> f.endsWith("subtotal")).collect(Collectors.toSet())), STAT);
        sumDataSet = sumDataSet.filter("stat > 0").orderBy(new String[]{"sortcode", "stat desc"});
        DataSet offsetRow = DecisionAnlsHelper.createRowByDefault(sumDataSet.getRowMeta().getFieldNames(), sumDataSet.getRowMeta().getDataTypes());
        offsetRow = offsetRow.updateField("mixorgname", ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashTrendChartDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        offsetRow = offsetRow.updateField("sumlevel", "3");
        if (!offsetData.copy().isEmpty()) {
            offsetData = offsetData.select(sumField.stream().collect(Collectors.joining(",")));
            GroupbyDataSet gdsTemp = offsetData.groupBy();
            for (String tempField : sumField) {
                gdsTemp.sum(tempField);
            }
            DataSet groupData = gdsTemp.finish();
            Row row = groupData.next();
            for (String tempField : sumField) {
                offsetRow = offsetRow.updateField(tempField, Optional.ofNullable(row.getBigDecimal(tempField)).orElseGet(() -> BigDecimal.ZERO).multiply(new BigDecimal(-1)).toPlainString());
            }
            sumDataSet = sumDataSet.union(offsetRow);
        }
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol");
        sumField.add(STAT);
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumField, "orgname").updateField("mixorgname", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashTrendChartDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        return sumDataSet.union(totalSet);
    }

    private static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith("month_")) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("orgname");
        selectField.add("mixorgname");
        selectField.add("rowid");
        selectField.add("orgid");
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map paramMap = this.transQueryParam(this.getQueryParam());
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dateDataSet = DecisionAnlsHelper.getDateDateSet(queryDate);
        while (dateDataSet.hasNext()) {
            Row date = dateDataSet.next();
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey("month_" + date.getString("datestring"));
            newColGroup.setCaption(new LocaleString(date.getString("datestring")));
            for (String amountField : amountFieldName) {
                String caption = "";
                switch (amountField) {
                    case "subtotal": {
                        caption = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CashTrendChartDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                    case "realvalibalance": {
                        caption = ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1", (String)"CashTrendChartDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                    case "realrestrictedamt": {
                        caption = ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1", (String)"CashTrendChartDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                }
                ReportColumn newCol = new ReportColumn();
                newCol.setFieldKey("month_" + date.getString("datestring") + amountField);
                newCol.setFieldType("decimal");
                newCol.setScale(2);
                newCol.setZeroShow(true);
                newCol.setCaption(new LocaleString(caption));
                newColGroup.getChildren().add(newCol);
            }
            columns.add((AbstractReportColumn)newColGroup);
        }
        return columns;
    }
}

