/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class CashBankListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String DISPLAY_TYPE = "displayType";
    private static final String PREFIX = "bankcate_";
    private static final String FILTER_COMPANY = "filter_company";
    private static final String BTN_SHOWALL = "btn_showall";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        queryParam.getFilter().addFilterItem(DISPLAY_TYPE, formShowParameter.getCustomParams().get(DISPLAY_TYPE));
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPk, rowData, queryParam);
        BigDecimal onehundred = new BigDecimal("100");
        Iterator iterator = rowData.iterator();
        Set<String> showColName = this.getRateColName(rowData);
        while (iterator.hasNext()) {
            CashBankListPlugin.setCellShow(onehundred, showColName, (DynamicObject)iterator.next());
        }
    }

    private static void setCellShow(BigDecimal onehundred, Set<String> showColName, DynamicObject row) {
        for (String colName : showColName) {
            BigDecimal rateBigDecimal;
            BigDecimal bigDecimal = rateBigDecimal = StringUtils.isEmpty((String)row.getString(colName)) ? BigDecimal.ZERO : row.getBigDecimal(colName);
            if (colName.endsWith("amountrate")) {
                String showStr = rateBigDecimal.multiply(onehundred).setScale(2, RoundingMode.HALF_UP).toString() + "%";
                row.set(colName, (Object)showStr);
                continue;
            }
            rateBigDecimal = rateBigDecimal.setScale(2, RoundingMode.HALF_UP);
            row.set(colName, (Object)rateBigDecimal);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("btn_showdetail")) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                if (AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(formShowParameter.getCustomParam(DISPLAY_TYPE))) {
                    param.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u5934\u5bf8\u5883\u5185\u94f6\u884c\u5206\u5e03\u8868\u660e\u7ec6", (String)"CashBankListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
                } else {
                    param.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u5934\u5bf8\u5883\u5916\u94f6\u884c\u5206\u5e03\u8868\u660e\u7ec6", (String)"CashBankListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
                }
            }
            param.getCustomParams().put(DISPLAY_TYPE, formShowParameter.getCustomParam(DISPLAY_TYPE));
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        } else if (BTN_SHOWALL.equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", true);
            this.getView().invokeOperation("refresh");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SHOWALL});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SHOWALL});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString("isgroupnode");
        long orgid = row.getLong(ORGID);
        String fieldName = event.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith(PREFIX)) {
            ReportShowParameter param = new ReportShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
            long parentId = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
            param.getCustomParams().put("parent_id", Long.toString(parentId));
            if (EmptyUtil.isEmpty((Long)orgid)) {
                param.getCustomParams().put("current_org_id", Long.toString(parentId));
            } else {
                param.getCustomParams().put("current_org_id", Long.toString(orgid));
            }
            param.getCustomParams().put(DISPLAY_TYPE, paramMap.get(DISPLAY_TYPE));
            if (this.getView().getFormShowParameter().getCustomParams().get("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            }
            param.setFormId("tda_cashotherbankrpt");
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        if (EmptyUtil.isEmpty((Long)orgid) || !"1".equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgid));
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        param.getCustomParams().put(DISPLAY_TYPE, customParams.get(DISPLAY_TYPE));
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(formShowParameter.getFormId());
        param.setCaption(formShowParameter.getCaption());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString("isgroupnode");
        Object formatValue = packageDataEvent.getFormatValue();
        String fieldKey = ((ReportColumn)packageDataEvent.getSource()).getFieldKey();
        if (fieldKey.startsWith(PREFIX)) {
            return;
        }
        if (formatValue != null && !"1".equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(fieldKey);
        }
    }

    private Set<String> getRateColName(DynamicObjectCollection rowData) {
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        return properties.stream().filter(r -> StringUtils.isNotEmpty((String)r.getName()) && r.getName().startsWith("bank")).map(IMetadata::getName).collect(Collectors.toSet());
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        ReportView reportView = (ReportView)this.getView();
        ReportListModel reportModel = (ReportListModel)reportView.getReportList().getReportModel();
        List reportColumnList = reportModel.getReportTaskResult().getReportColumnList();
        Set<String> columns = reportColumnList.stream().map(ReportColumn::getFieldKey).collect(Collectors.toSet());
        String mergeName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"DecisionAnlsPenetrateCommonListPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
        ArrayList<String> ruleNames = new ArrayList<String>(Arrays.asList("org_name", "mixorgname", "orgname"));
        ruleNames.retainAll(columns);
        if (ruleNames.size() == 0) {
            return;
        }
        StringBuilder conditionBuilder = new StringBuilder((String)ruleNames.get(0)).append(" = '").append(mergeName).append("'");
        if (CollectionUtils.isNotEmpty(columns) && CollectionUtils.isNotEmpty(ruleNames)) {
            columns.forEach(fieldKey -> {
                CellStyleRule cellStyleRule = this.createCellStyleRule("red", (String)fieldKey, conditionBuilder.toString());
                cellStyleRules.add(cellStyleRule);
            });
            columns.forEach(fieldKey -> {
                String s = String.format(" and (%1$s ='0.00' or %1$s ='0.00 %%' or %1$s ='0.00%%')", fieldKey);
                CellStyleRule cellStyleRule = this.createCellStyleRule("white", (String)fieldKey, conditionBuilder + s);
                cellStyleRules.add(cellStyleRule);
            });
        }
        super.setCellStyleRules(cellStyleRules);
    }

    private CellStyleRule createCellStyleRule(String color, String fieldKey, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(fieldKey);
        cellStyleRule.setForeColor(color);
        cellStyleRule.setBackgroundColor("white");
        cellStyleRule.setDegree(100);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }
}

