/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashBankQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ISDOMESTIC = "isdomestic";
    private static final String BANKNAME = "bankname";
    private static final String VALIBALANCE = "valibalance";
    private static final int TOP = 15;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BANKNAME, ResManager.loadKDString((String)"\u94f6\u884c", (String)"CashBankQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{VALIBALANCE, ResManager.loadKDString((String)"\u91d1\u989d", (String)"CashBankQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{ISDOMESTIC, ResManager.loadKDString((String)"\u662f\u5426\u5883\u5185", (String)"CashBankQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"CashBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allFundDataSet = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        String filterBankString = String.format("bankcatename not like '%1$s%2$s%3$s'", "%", ResManager.loadKDString((String)"\u4eba\u6c11\u94f6\u884c", (String)"CashBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "%");
        allFundDataSet = allFundDataSet.filter(filterBankString);
        List<String> finOrgTypeList = Arrays.asList(FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.FINCOMP.getValue(), FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        DataSet fundDataSet = allFundDataSet.filter("finorgtype in finorgtypes ", Collections.singletonMap("finorgtypes", finOrgTypeList)).updateField(VALIBALANCE, "realvalibalance + realrestrictedamt").select(new String[]{"bankcatename bankname", "bankcateid bankcate", ISDOMESTIC, "finorgtype", VALIBALANCE});
        fundDataSet = fundDataSet.groupBy(new String[]{BANKNAME, "bankcate", ISDOMESTIC, "finorgtype"}).sum(VALIBALANCE).finish();
        DataSet[] domesticAndOnerSeaDatasets = fundDataSet.splitByFilter(new String[]{"isdomestic = '1'"}, true);
        DataSet domesticDataset = this.getAfterUnionDataSet(domesticAndOnerSeaDatasets[0]);
        DataSet overSeasDataset = this.getAfterUnionDataSet(domesticAndOnerSeaDatasets[1]);
        return domesticDataset.union(overSeasDataset);
    }

    private DataSet getAfterUnionDataSet(DataSet domesticAndOverSeaDataset) {
        DataSet domesticUnionSet;
        DataSet[] allDataSets = domesticAndOverSeaDataset.splitByFilter(new String[]{"finorgtype = '3'", "finorgtype = '1'", "finorgtype = '0'"}, false);
        DataSet finCompAcctSet = allDataSets[0].updateField(BANKNAME, "'" + FinOrgTypeEnum.FINCOMP.getName() + "'");
        DataSet clearingHouse = allDataSets[1].updateField(BANKNAME, "'" + FinOrgTypeEnum.CLEARINGHOUSE.getName() + "'");
        DataSet bankDomesticAcctSet = allDataSets[2];
        clearingHouse = clearingHouse.select(new String[]{BANKNAME, ISDOMESTIC, VALIBALANCE}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(VALIBALANCE).finish();
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitTopBank(bankDomesticAcctSet, VALIBALANCE, 15);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).select(new String[]{BANKNAME, ISDOMESTIC, VALIBALANCE}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(VALIBALANCE).finish().orderBy(new String[]{"valibalance desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet otherDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"CashBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])).select(new String[]{BANKNAME, ISDOMESTIC, VALIBALANCE}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(VALIBALANCE).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(otherDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        finCompAcctSet = finCompAcctSet.select(new String[]{BANKNAME, ISDOMESTIC, VALIBALANCE}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(VALIBALANCE).finish();
        return domesticUnionSet.union(new DataSet[]{finCompAcctSet, clearingHouse});
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        boolean isDomesticRpt = "tda_domesticacctqingrpt".equals(formId);
        AcctDisplayByBankTypeEnum type = isDomesticRpt ? AcctDisplayByBankTypeEnum.DOMESTIC : AcctDisplayByBankTypeEnum.OVERSEAS;
        String caption = isDomesticRpt ? ResManager.loadKDString((String)"\u8d44\u91d1\u5934\u5bf8\u5883\u5185\u94f6\u884c\u5206\u5e03\u8868", (String)"CashBankQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d44\u91d1\u5934\u5bf8\u5883\u5916\u94f6\u884c\u5206\u5e03\u8868", (String)"CashBankQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.getCustomParams().put("displayType", type.getValue());
        param.setFormId("tda_cashbanksumrpt");
        param.setCaption(caption);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BANKNAME;
    }

    @Override
    protected List<String> getLinkReport() {
        return Arrays.asList("tda_domesticacctqingrpt", "tda_overseasacctqingrpt");
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(VALIBALANCE);
    }
}

