/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashCateQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String FUND_TYPE_NAME = "fundtypename";
    private static final String FUND_TYPE = "fundtype";
    private static final String BALANCE = "fbalance";
    private static final String RATE = "frate";
    private static final String PROFIT = "profit";
    private static final List<Integer> FUND_TYPE_LIST = Arrays.asList(CashTypeEnum.ACCOUNT.getNumber(), CashTypeEnum.NOTICE.getNumber(), CashTypeEnum.FIX.getNumber(), CashTypeEnum.STRUCT.getNumber(), CashTypeEnum.HUGE.getNumber(), CashTypeEnum.FINANCE.getNumber());
    private static final String PARAM = "param";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{FUND_TYPE_NAME, ResManager.loadKDString((String)"\u8d44\u91d1\u5206\u7c7b", (String)"CashCateQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FUND_TYPE, ResManager.loadKDString((String)"\u8d44\u91d1\u5206\u7c7b\u7f16\u53f7", (String)"CashCateQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u4f59\u989d", (String)"CashCateQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PROFIT, ResManager.loadKDString((String)"\u6536\u76ca\u7387", (String)"CashCateQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"profitstr", ResManager.loadKDString((String)"\u6536\u76ca\u7387\uff08%\uff09", (String)"CashCateQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"accountbalance", CashTypeEnum.ACCOUNT.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"accountprofit", CashTypeEnum.ACCOUNT.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"noticebalance", CashTypeEnum.NOTICE.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"noticeprofit", CashTypeEnum.NOTICE.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"fixbalance", CashTypeEnum.FIX.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"fixprofit", CashTypeEnum.FIX.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"structbalance", CashTypeEnum.STRUCT.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"structprofit", CashTypeEnum.STRUCT.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"hugebalance", CashTypeEnum.HUGE.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"hugeprofit", CashTypeEnum.HUGE.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"financebalance", CashTypeEnum.FINANCE.getText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"financeprofit", CashTypeEnum.FINANCE.getProfitText(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"CashCateQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet ds = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        return this.handleDataSet(ds);
    }

    private DataSet handleDataSet(DataSet ds) {
        ds = ds.filter("isoffset='0'").select("fundtype, realvalibalance+realrestrictedamt fbalance, frate");
        ds = ds.groupBy(new String[]{FUND_TYPE}).sum(BALANCE).sum("fbalance*frate", "balancerate").finish().orderBy(new String[]{FUND_TYPE});
        ds = ds.select("fundtype,fbalance,case when fbalance=0 then 0 else balancerate*1.0/fbalance end as profit");
        DataSet resultDs = DecisionAnlsHelper.creatAbsentRow(ds, FUND_TYPE, FUND_TYPE_LIST.stream().map(String::valueOf).collect(Collectors.toList()), 0, () -> new Object[]{"", 0.0, 0.0});
        String props = "fundtype,fbalance,profit,' ' as fundtypename, ' ' as profitstr,case when fundtype=0 then fbalance else 0 end as accountbalance,case when fundtype=0 then profit else 0 end as accountprofit,case when fundtype=1 then fbalance else 0 end as noticebalance,case when fundtype=1 then profit else 0 end as noticeprofit,case when fundtype=2 then fbalance else 0 end as fixbalance,case when fundtype=2 then profit else 0 end as fixprofit,case when fundtype=3 then fbalance else 0 end as structbalance,case when fundtype=3 then profit else 0 end as structprofit,case when fundtype=4 then fbalance else 0 end as hugebalance,case when fundtype=4 then profit else 0 end as hugeprofit,case when fundtype=5 then fbalance else 0 end as financebalance,case when fundtype=5 then profit else 0 end as financeprofit";
        resultDs = resultDs.select(props);
        String fundTypeName = String.format("case when fundtype=0 then '%1$s' when fundtype=1 then '%2$s' when fundtype=2 then '%3$s' when fundtype=3 then '%4$s' when fundtype=4 then '%5$s' when fundtype=5 then '%6$s' else ' ' end", CashTypeEnum.ACCOUNT.getText(), CashTypeEnum.NOTICE.getText(), CashTypeEnum.FIX.getText(), CashTypeEnum.STRUCT.getText(), CashTypeEnum.HUGE.getText(), CashTypeEnum.FINANCE.getText());
        resultDs = resultDs.updateFields(new String[]{FUND_TYPE_NAME, "accountprofit", "profitstr"}, new String[]{fundTypeName, "0.0", "case when fundtype=0 then '--' else concat(round(profit, 2), '%') end"});
        return resultDs.addField(FUND_TYPE, PARAM);
    }

    @Override
    protected List<String> getLinkReport() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("tda_cashcaterpt");
        list.add("tda_cashcatefinrpt");
        return list;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        if (EmptyUtil.isNoEmpty(ids) && String.valueOf(CashTypeEnum.FINANCE.getNumber()).equals(ids.get(0))) {
            param.setFormId("tda_cashcatefinrpt");
        } else {
            param.setFormId(formId);
        }
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add(BALANCE);
        fields.add("accountbalance");
        fields.add("noticebalance");
        fields.add("fixbalance");
        fields.add("structbalance");
        fields.add("hugebalance");
        fields.add("financebalance");
        return fields;
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        if (EmptyUtil.isNoEmpty((Object)((JSONObject)clickArgs.get((Object)"data"))) && CashTypeEnum.FINANCE.getText().equals(((JSONObject)clickArgs.get((Object)"data")).getString("name"))) {
            param.setFormId("tda_cashcatefinrpt");
        }
        if (EmptyUtil.isNoEmpty((Object)((JSONObject)clickArgs.get((Object)"onlegendclick"))) && CashTypeEnum.FINANCE.getText().equals(((JSONObject)clickArgs.get((Object)"onlegendclick")).getString("name"))) {
            param.setFormId("tda_cashcatefinrpt");
        }
    }
}

