/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDistributionByOrgAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"realvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1", (String)"CashDistributionByOrgAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"realrestrictedamt", ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1", (String)"CashDistributionByOrgAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"CashDistributionByOrgAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"total", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CashDistributionByOrgAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List<Long> allOrgIds = this.getOrgIds(paramMap);
        DataSet dataSet = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), allOrgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        dataSet = dataSet.groupBy(new String[]{"company"}).sum("realvalibalance").sum("realrestrictedamt").finish();
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> sumFields = this.getSumField();
        String[] selectFields = DecisionAnlsHelper.getSelectField(sumFields);
        selectFields[0] = "mixorgname as orgname";
        DataSet ds = allOrgDataSet.leftJoin(dataSet).on("rowid", "company").select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(ds, sumFields, "orgid,orgname");
        List<Long> secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)currentOrgId, (boolean)true);
        List<Long> subOrgIds = EmptyUtil.isNoEmpty((Object)secondOrgIds) ? secondOrgIds : allOrgIds;
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            sumDataSet = sumDataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds));
        }
        sumDataSet = sumDataSet.filter("realvalibalance > 0 or realrestrictedamt > 0").addField("realvalibalance+realrestrictedamt", "total").orderBy(new String[]{"total desc"});
        return sumDataSet;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_cashdistbyorgrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_cashdistbyorgrpt");
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "orgname";
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("realvalibalance");
        fields.add("realrestrictedamt");
        return fields;
    }

    private List<String> getSumField() {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("realvalibalance");
        fields.add("realrestrictedamt");
        return fields;
    }
}

